/*-
 * #%L
 * alfresco-tas-restapi
 * %%
 * Copyright (C) 2005 - 2022 Alfresco Software Limited
 * %%
 * This file is part of the Alfresco software. 
 * If the software was purchased under a paid Alfresco license, the terms of 
 * the paid license agreement will prevail.  Otherwise, the software is 
 * provided under the following open source license terms:
 * 
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.alfresco.rest.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

import org.alfresco.rest.core.IRestModel;
import org.alfresco.utility.model.TestModel;

/**
 * Generated by 'Kristian.Dimitrov@hyland.com' on '2022-07-13 15:53' from 'Alfresco Content Services REST API' swagger file 
 * Generated from 'Alfresco Content Services REST API' swagger file
 * Base Path {@linkplain /alfresco/api/-default-/public/alfresco/versions/1}
 */
public class RestRuleSetBodyUpdateModel extends TestModel implements IRestModel<RestRuleSetBodyUpdateModel>
{
    @JsonProperty(value = "entry")
    RestRuleSetBodyUpdateModel model;

    @Override
    public RestRuleSetBodyUpdateModel onModel()
    {
        return model;
    }

    /**
    An ordered list of the rule ids within the rule set.

Rules may not be added or removed from the rule set using this endpoint.

If this field is omitted then there is no change to the rule ordering.

    */	        

    private List<String> ruleIds;	    

    public List<String> getRuleIds()
    {
        return this.ruleIds;
    }

    public void setRuleIds(List<String> ruleIds)
    {
        this.ruleIds = ruleIds;
    }				
}
 
