/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.categories;

import java.util.List;
import java.util.stream.Collectors;
import org.alfresco.rest.categories.CategoriesRestTest;
import org.alfresco.rest.categories.CreateCategoriesTests;
import org.alfresco.rest.model.RestCategoryModel;
import org.alfresco.rest.model.RestCategoryModelsCollection;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetCategoriesTests
extends CategoriesRestTest {
    private static final List<String> DEFAULT_ROOT_CATEGORIES = List.of("Software Document Classification", "Languages", "Regions", "Tags");
    private static final String NON_EXISTING_CATEGORY_ID = "non-existing-category-id";

    @Test(groups={"rest-api"})
    public void testGetCategoryById() {
        Step.STEP((String)"Create a category under root category (as admin)");
        RestCategoryModel rootCategory = this.createCategoryModelWithId("-root-");
        RestCategoryModel aCategory = this.createCategoryModelWithName(RandomData.getRandomName((String)"Category"));
        RestCategoryModel createdCategory = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingCategory(rootCategory).createSingleCategory(aCategory);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        createdCategory.assertThat().field("name").is((Object)aCategory.getName());
        createdCategory.assertThat().field("parentId").is((Object)rootCategory.getId());
        createdCategory.assertThat().field("hasChildren").is((Object)false);
        Step.STEP((String)"Get the created category (as regular user)");
        RestCategoryModel categoryFromGet = this.restClient.authenticateUser(this.user).withCoreAPI().usingCategory(createdCategory).getCategory();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        categoryFromGet.assertThat().isEqualTo((Object)createdCategory, new String[0]);
    }

    @Test(groups={"rest-api"})
    public void testGetCategoryByIdProvidingRootAsId() {
        Step.STEP((String)"Get category with -root- as id");
        RestCategoryModel rootCategory = this.createCategoryModelWithId("-root-");
        this.restClient.authenticateUser(this.user).withCoreAPI().usingCategory(rootCategory).getCategory();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Node id does not refer to a valid category");
    }

    @Test(groups={"rest-api"})
    public void testGetCategoryByIdProvidingFolderAsId() {
        Step.STEP((String)"Create a site and a folder inside it");
        SiteModel site = ((DataSite)this.dataSite.usingUser(this.user)).createPublicRandomSite();
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(site)).createFolder();
        Step.STEP((String)"Get category with folder id passed as id");
        RestCategoryModel rootCategory = this.createCategoryModelWithId(folder.getNodeRef());
        this.restClient.authenticateUser(this.user).withCoreAPI().usingCategory(rootCategory).getCategory();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Node id does not refer to a valid category");
    }

    @Test(groups={"rest-api"})
    public void testGetCategoryByIdProvidingNonExistingId() {
        Step.STEP((String)"Get category with id which does not exist");
        String id = NON_EXISTING_CATEGORY_ID;
        RestCategoryModel rootCategory = this.createCategoryModelWithId(NON_EXISTING_CATEGORY_ID);
        this.restClient.authenticateUser(this.user).withCoreAPI().usingCategory(rootCategory).getCategory();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(NON_EXISTING_CATEGORY_ID);
    }

    @Test(groups={"rest-api"})
    public void testGetCategoryChildren() {
        Step.STEP((String)"Get category children with -root- as parent id");
        RestCategoryModel rootCategory = this.createCategoryModelWithId("-root-");
        RestCategoryModelsCollection childCategoriesList = this.restClient.authenticateUser(this.user).withCoreAPI().usingCategory(rootCategory).getCategoryChildren();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        childCategoriesList.assertThat().entriesListIsNotEmpty();
        Assert.assertTrue((boolean)childCategoriesList.getEntries().stream().map(RestCategoryModel::onModel).map(RestCategoryModel::getName).collect(Collectors.toList()).containsAll(DEFAULT_ROOT_CATEGORIES));
        Step.STEP((String)"Create a new category under root and make sure it is returned as one of root's children");
        RestCategoryModel aCategory = this.createCategoryModelWithName(RandomData.getRandomName((String)"newCategoryUnderRoot"));
        RestCategoryModel createdCategory = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingCategory(rootCategory).createSingleCategory(aCategory);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        childCategoriesList = this.restClient.authenticateUser(this.user).withCoreAPI().usingCategory(rootCategory).getCategoryChildren();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Assert.assertTrue((boolean)childCategoriesList.getEntries().stream().map(RestCategoryModel::onModel).map(RestCategoryModel::getId).collect(Collectors.toList()).contains(createdCategory.getId()));
        Step.STEP((String)"Create 2 more categories under newCategoryUnderRoot and make sure they are returned as children");
        int categoriesCount = 2;
        List<RestCategoryModel> categoriesToCreate = CreateCategoriesTests.getCategoriesToCreate(2);
        RestCategoryModelsCollection createdSubCategories = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingCategory(createdCategory).createCategoriesList(categoriesToCreate);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        childCategoriesList = this.restClient.authenticateUser(this.user).withCoreAPI().usingCategory(rootCategory).getCategoryChildren();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        childCategoriesList.getEntries().containsAll(createdSubCategories.getEntries());
    }

    @Test(groups={"rest-api"})
    public void testGetCategoryChildrenProvidingFolderAsId() {
        Step.STEP((String)"Create a site and a folder inside it");
        SiteModel site = ((DataSite)this.dataSite.usingUser(this.user)).createPublicRandomSite();
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(site)).createFolder();
        Step.STEP((String)"Get category children with folder id passed as parent id");
        RestCategoryModel parentCategory = this.createCategoryModelWithId(folder.getNodeRef());
        this.restClient.authenticateUser(this.user).withCoreAPI().usingCategory(parentCategory).getCategoryChildren();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Node id does not refer to a valid category");
    }

    @Test(groups={"rest-api"})
    public void testGetCategoryChildrenProvidingNonExistingParent() {
        Step.STEP((String)"Get category with folder id passed as id");
        String parentId = NON_EXISTING_CATEGORY_ID;
        RestCategoryModel parentCategory = this.createCategoryModelWithId(NON_EXISTING_CATEGORY_ID);
        this.restClient.authenticateUser(this.user).withCoreAPI().usingCategory(parentCategory).getCategoryChildren();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(NON_EXISTING_CATEGORY_ID);
    }
}

