/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processDefinitions;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestProcessDefinitionModel;
import org.alfresco.rest.model.RestProcessDefinitionModelsCollection;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetProcessDefinitionStartFormModelCoreTests
extends RestTest {
    private UserModel adminUser;
    private RestProcessDefinitionModel randomProcessDefinition;
    private RestProcessDefinitionModelsCollection allProcessDefinitions;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.allProcessDefinitions = this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getAllProcessDefinitions();
    }

    @TestRail(section={"rest-api", "workflow", "process-definitions"}, executionType={ExecutionType.REGRESSION}, description="Verify any user gets a model of the start form type definition for non-network deployments using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "process-definitions", "regression"})
    public void nonNetworkUserGetsStartFormModel() throws Exception {
        UserModel nonNetworkUser = this.dataUser.createRandomTestUser();
        this.randomProcessDefinition = ((RestProcessDefinitionModel)this.allProcessDefinitions.getOneRandomEntry()).onModel();
        this.restClient.authenticateUser(nonNetworkUser).withWorkflowAPI().usingProcessDefinitions(this.randomProcessDefinition).getProcessDefinitionStartFormModel().assertThat().entriesListIsNotEmpty();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Bug(id="ALF-20187")
    @TestRail(section={"rest-api", "workflow", "process-definitions"}, executionType={ExecutionType.REGRESSION}, description="Verify if get request returns status code 404 when invalid processDefinitionId is used")
    @Test(groups={"rest-api", "workflow", "process-definitions", "regression"})
    public void getStartFormModelUsingInvalidProcessDefinitionId() throws Exception {
        this.randomProcessDefinition = ((RestProcessDefinitionModel)this.allProcessDefinitions.getOneRandomEntry()).onModel();
        this.randomProcessDefinition.setId("invalidID");
        this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().usingProcessDefinitions(this.randomProcessDefinition).getProcessDefinitionStartFormModel();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format("no deployed process definition found with id '%s'", "invalidID")).containsErrorKey(RestErrorModel.API_DEFAULT_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Bug(id="ALF-20187")
    @TestRail(section={"rest-api", "workflow", "process-definitions"}, executionType={ExecutionType.REGRESSION}, description="Verify if get request returns status code 404 when empty processDefinitionId is used")
    @Test(groups={"rest-api", "workflow", "process-definitions", "regression"})
    public void getStartFormModelUsingEmptyProcessDefinitionId() throws Exception {
        this.randomProcessDefinition = ((RestProcessDefinitionModel)this.allProcessDefinitions.getOneRandomEntry()).onModel();
        this.randomProcessDefinition.setId("");
        this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().usingProcessDefinitions(this.randomProcessDefinition).getProcessDefinitionStartFormModel();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary("no deployed process definition found with id ''");
    }
}

