/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.categories;

import org.alfresco.rest.categories.CategoriesRestTest;
import org.alfresco.rest.model.RestCategoryModel;
import org.alfresco.rest.requests.Categories;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.http.HttpStatus;
import org.testng.annotations.Test;

public class UpdateCategoriesTests
extends CategoriesRestTest {
    private static final String CATEGORY_NEW_NAME_PREFIX = "NewCategoryName";
    private static final String IGNORE_FIELD_NAME = "name";

    @Test(groups={"rest-api"})
    public void testUpdateCategory_asAdmin() {
        Step.STEP((String)"Prepare as admin a category under root category");
        RestCategoryModel createdCategory = this.prepareCategoryUnderRoot();
        Step.STEP((String)"Update as admin newly created category");
        String categoryNewName = RandomData.getRandomName((String)CATEGORY_NEW_NAME_PREFIX);
        RestCategoryModel fixedCategoryModel = this.createCategoryModelWithName(categoryNewName);
        RestCategoryModel updatedCategory = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingCategory(createdCategory).updateCategory(fixedCategoryModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        updatedCategory.assertThat().isEqualTo((Object)createdCategory, new String[]{IGNORE_FIELD_NAME});
        updatedCategory.assertThat().field(IGNORE_FIELD_NAME).isNot((Object)createdCategory.getName());
        updatedCategory.assertThat().field(IGNORE_FIELD_NAME).is((Object)categoryNewName);
    }

    @Test(groups={"rest-api"})
    public void testUpdateSubcategory_asAdmin() {
        Step.STEP((String)"Prepare as admin a category under root category");
        RestCategoryModel createdCategory = this.prepareCategoryUnderRoot();
        Step.STEP((String)"Prepare as admin a subcategory of root's child category");
        RestCategoryModel createdSubcategory = this.prepareCategoryUnder(createdCategory);
        Step.STEP((String)"Update as admin newly created subcategory");
        String categoryNewName = RandomData.getRandomName((String)CATEGORY_NEW_NAME_PREFIX);
        RestCategoryModel fixedCategoryModel = this.createCategoryModelWithName(categoryNewName);
        RestCategoryModel updatedCategory = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingCategory(createdSubcategory).updateCategory(fixedCategoryModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        updatedCategory.assertThat().isEqualTo((Object)createdSubcategory, new String[]{IGNORE_FIELD_NAME});
        updatedCategory.assertThat().field(IGNORE_FIELD_NAME).is((Object)categoryNewName);
    }

    @Test(groups={"rest-api"})
    public void testUpdateCategory_usingRecurringName() {
        Step.STEP((String)"Prepare as admin two categories under root category");
        RestCategoryModel createdCategory = this.prepareCategoryUnderRoot();
        RestCategoryModel secondCreatedCategory = this.prepareCategoryUnderRoot();
        Step.STEP((String)"Try to update as admin newly created category using name of already present, different category");
        String categoryNewName = secondCreatedCategory.getName();
        RestCategoryModel fixedCategoryModel = this.createCategoryModelWithName(categoryNewName);
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingCategory(createdCategory).updateCategory(fixedCategoryModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CONFLICT);
    }

    @Test(groups={"rest-api"})
    public void testUpdateCategory_asUserAndExpect403() {
        Step.STEP((String)"Prepare as admin a category under root category");
        RestCategoryModel createdCategory = this.prepareCategoryUnderRoot();
        Step.STEP((String)"Try to update as user newly created category");
        RestCategoryModel fixedCategoryModel = this.createCategoryModelWithName(RandomData.getRandomName((String)CATEGORY_NEW_NAME_PREFIX));
        this.restClient.authenticateUser(this.user).withCoreAPI().usingCategory(createdCategory).updateCategory(fixedCategoryModel);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
    }

    @Test(groups={"rest-api"})
    public void testUpdateCategory_usingNonExistingCategoryAndExpect404() {
        Step.STEP((String)"Create a fake parent category");
        RestCategoryModel nonExistingCategory = this.createCategoryModelWithIdAndName("non-existing-dummy-id", RandomData.getRandomName((String)"CategoryName"));
        Step.STEP((String)"Try to update as admin fake category");
        RestCategoryModel fixedCategoryModel = this.createCategoryModelWithName(RandomData.getRandomName((String)CATEGORY_NEW_NAME_PREFIX));
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingCategory(nonExistingCategory).updateCategory(fixedCategoryModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @Test(groups={"rest-api"})
    public void testUpdateCategory_usingFolderNodeAndExpect400() {
        Step.STEP((String)"Prepare a site and a folder inside it");
        UserModel user = this.dataUser.createRandomTestUser();
        SiteModel site = ((DataSite)this.dataSite.usingUser(user)).createPublicRandomSite();
        FolderModel folder = ((DataContent)this.dataContent.usingUser(user).usingSite(site)).createFolder();
        RestCategoryModel categoryWithFolderId = this.createCategoryModelWithIdAndName(folder.getNodeRef(), RandomData.getRandomName((String)"CategoryName"));
        Step.STEP((String)"Try to update as admin folder node as category");
        RestCategoryModel fixedCategoryModel = this.createCategoryModelWithName(RandomData.getRandomName((String)CATEGORY_NEW_NAME_PREFIX));
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingCategory(categoryWithFolderId).updateCategory(fixedCategoryModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @Test(groups={"rest-api"})
    public void testUpdateCategory_usingRootCategoryAndExpect400() {
        Step.STEP((String)"Create root category model");
        RestCategoryModel rootCategoryModel = this.createCategoryModelWithId("-root-");
        Step.STEP((String)"Try to update as admin root category");
        RestCategoryModel fixedCategoryModel = this.createCategoryModelWithName(RandomData.getRandomName((String)CATEGORY_NEW_NAME_PREFIX));
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingCategory(rootCategoryModel).updateCategory(fixedCategoryModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @Test(groups={"rest-api"})
    public void testUpdateCategory_withEmptyNameAndExpect400() {
        Step.STEP((String)"Prepare as admin a category under root category");
        RestCategoryModel createdCategory = this.prepareCategoryUnderRoot();
        Step.STEP((String)"Try to update as admin newly created category with a category without name");
        RestCategoryModel fixedCategoryModel = this.createCategoryModelWithName(null);
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingCategory(createdCategory).updateCategory(fixedCategoryModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @Test(groups={"rest-api"})
    public void testUpdateCategory_withIgnoredInvalidIdInBodyAndExpect200() {
        Step.STEP((String)"Prepare as admin a category under root category");
        RestCategoryModel createdCategory = this.prepareCategoryUnderRoot();
        Step.STEP((String)"Try to update as admin newly created category with a category with invalid ID and receive 200");
        String categoryNewName = RandomData.getRandomName((String)CATEGORY_NEW_NAME_PREFIX);
        RestCategoryModel fixedCategoryModel = this.createCategoryModelWithIdAndName("non-existing-dummy-id", categoryNewName);
        RestCategoryModel updatedCategory = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingCategory(createdCategory).updateCategory(fixedCategoryModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        updatedCategory.assertThat().field(IGNORE_FIELD_NAME).is((Object)categoryNewName);
    }

    @Test(groups={"rest-api"})
    public void testUpdateCategory_verifyIfCountInRequestIsIgnored() {
        Step.STEP((String)"Prepare a category under root category");
        RestCategoryModel createdCategory = this.prepareCategoryUnderRoot();
        Step.STEP((String)"Try to update newly created category providing new name and count number");
        RestCategoryModel fixedCategoryModel = this.createCategoryModelWithName(RandomData.getRandomName((String)CATEGORY_NEW_NAME_PREFIX));
        fixedCategoryModel.setCount(2L);
        RestCategoryModel updatedCategory = ((Categories)this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingCategory(createdCategory).include(new String[]{"count"})).updateCategory(fixedCategoryModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        updatedCategory.assertThat().field("id").is((Object)createdCategory.getId());
        updatedCategory.assertThat().field("count").is((Object)0);
    }
}

