/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.nodes;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestNodeAssociationModel;
import org.alfresco.rest.model.RestNodeAssociationModelCollection;
import org.alfresco.rest.model.RestNodeAssociationTypeModel;
import org.alfresco.rest.model.RestNodeBodyModel;
import org.alfresco.rest.model.RestNodeChildAssocModelCollection;
import org.alfresco.rest.model.RestNodeChildAssociationModel;
import org.alfresco.rest.model.RestNodeModel;
import org.alfresco.rest.model.RestNodeModelsCollection;
import org.alfresco.rest.model.builder.NodesBuilder;
import org.alfresco.utility.Utility;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.report.log.Step;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.Test;

public class NodesParentChildrenTests
extends RestTest {
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY}, description="Verify new folder node is created as children on -my- posting as JSON content type")
    @Test(groups={"rest-api", "nodes", "sanity"})
    public void createNewFolderNodeViaJason() throws Exception {
        this.restClient.authenticateUser(this.dataContent.getAdminUser());
        RestNodeBodyModel node = new RestNodeBodyModel();
        node.setName("My Folder");
        node.setNodeType("cm:folder");
        RestNodeModel newNode = this.restClient.withParams(new String[]{"autoRename=true"}).withCoreAPI().usingNode((RepoTestModel)ContentModel.my()).createNode(node);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestNodeModel)((RestNodeModel)((RestNodeModel)newNode.assertThat().field("aspectNames").contains("cm:auditable")).assertThat().field("isFolder").is((Object)true)).assertThat().field("isFile").is((Object)false)).assertThat().field("name").contains(node.getName());
    }

    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.REGRESSION}, description="Verify new folder node is created as children on -my- posting as MultiPart content type")
    @Test(groups={"rest-api", "nodes", "regression"})
    public void createNewFolderNodeWithMultiPartForms() throws Exception {
        this.restClient.authenticateUser(this.dataContent.getAdminUser()).configureRequestSpec().addMultiPart("filedata", Utility.getResourceTestDataFile((String)"restapi-resource")).addFormParam("renditions", new Object[]{"doclib"}).addFormParam("autoRename", new Object[]{true});
        RestNodeModel newNode = this.restClient.withCoreAPI().usingNode((RepoTestModel)ContentModel.my()).createNode();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestNodeModel)((RestNodeModel)((RestNodeModel)newNode.assertThat().field("aspectNames").contains("cm:auditable")).assertThat().field("isFolder").is((Object)false)).assertThat().field("isFile").is((Object)true)).assertThat().field("name").contains("restapi-resource");
    }

    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY}, description="Verify list children when listing with relativePath and pagination")
    @Test(groups={"rest-api", "nodes", "sanity"})
    public void checkRelativePathAndPaginationOnCreateChildrenNode() throws Exception {
        NodesBuilder nodesBuilder = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingNode((RepoTestModel)ContentModel.my()).defineNodes();
        nodesBuilder.folder("F1").folder("F2").folder("F3").file("f1").file("f2").file("f3");
        RestNodeModelsCollection returnedFiles = this.restClient.withParams(new String[]{"maxItems=2", "skipCount=1", String.format("relativePath=%s/%s", nodesBuilder.getNode("F2").getName(), nodesBuilder.getNode("F3").getName())}).withCoreAPI().usingNode((RepoTestModel)nodesBuilder.getNode("F1").toContentModel()).listChildren();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedFiles.assertThat().entriesListCountIs(2);
        ((RestNodeModel)returnedFiles.getEntries().get(0)).onModel().assertThat().field("id").is((Object)nodesBuilder.getNode("f2").getId());
        ((RestNodeModel)returnedFiles.getEntries().get(1)).onModel().assertThat().field("id").is((Object)nodesBuilder.getNode("f3").getId());
    }

    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY}, description="Check /secondary-children (create, list, delete) api calls")
    @Test(groups={"rest-api", "nodes", "sanity"})
    public void checkSecondaryChildrenApi() throws Exception {
        Step.STEP((String)"1. Create a folder hierarchy folder1/folder2, with folder2 containing 3 files: f1, f2, and f3");
        NodesBuilder nodesBuilder = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingNode((RepoTestModel)ContentModel.my()).defineNodes();
        nodesBuilder.folder("F1").folder("F2").file("f1").file("f2").file("f3");
        Step.STEP((String)"2. Create secondary child associations model objects");
        RestNodeChildAssociationModel childAssoc1 = new RestNodeChildAssociationModel(nodesBuilder.getNode("f1").getId(), "cm:contains");
        RestNodeChildAssociationModel childAssoc2 = new RestNodeChildAssociationModel(nodesBuilder.getNode("f2").getId(), "cm:contains");
        RestNodeChildAssociationModel childAssoc3 = new RestNodeChildAssociationModel(nodesBuilder.getNode("f3").getId(), "cm:preferenceImage");
        Step.STEP((String)"3. Create secondary child associations using POST /nodes/{nodeId}/secondary-children");
        RestNodeChildAssocModelCollection secondaryChildAssoc = this.restClient.withCoreAPI().usingNode((RepoTestModel)nodesBuilder.getNode("F1").toContentModel()).addSecondaryChildren(new RestNodeChildAssociationModel[]{childAssoc1, childAssoc2, childAssoc3});
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestNodeChildAssociationModel)secondaryChildAssoc.getEntryByIndex(0)).assertThat().field("childId").is((Object)childAssoc1.getChildId());
        ((RestNodeChildAssociationModel)secondaryChildAssoc.getEntryByIndex(1)).assertThat().field("childId").is((Object)childAssoc2.getChildId());
        ((RestNodeChildAssociationModel)secondaryChildAssoc.getEntryByIndex(2)).assertThat().field("childId").is((Object)childAssoc3.getChildId());
        Step.STEP((String)"4. Check using GET /nodes/{nodeId}/secondary-children that the secondary 'cm:contains' child associations were created");
        RestNodeAssociationModelCollection secondaryChildren = this.restClient.withParams(new String[]{"where=(assocType='cm:contains')"}).withCoreAPI().usingNode((RepoTestModel)nodesBuilder.getNode("F1").toContentModel()).getSecondaryChildren();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        secondaryChildren.assertThat().entriesListCountIs(2);
        Step.STEP((String)"5. Check using DELETE /nodes/{nodeId}/secondary-children/{childId} that a secondary child can be deleted");
        this.restClient.withCoreAPI().usingNode((RepoTestModel)nodesBuilder.getNode("F1").toContentModel()).removeSecondaryChild((RestNodeAssociationModel)secondaryChildren.getEntryByIndex(0));
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        Step.STEP((String)"6. Check using GET /nodes/{nodeId}/secondary-children that a secondary child association was deleted");
        secondaryChildren = this.restClient.withCoreAPI().usingNode((RepoTestModel)nodesBuilder.getNode("F1").toContentModel()).getSecondaryChildren();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        secondaryChildren.assertThat().entriesListCountIs(2);
        ((RestNodeAssociationTypeModel)((RestNodeAssociationModel)((RestNodeAssociationModel)((RestNodeAssociationModel)secondaryChildren.getEntryByIndex(0)).assertThat().field("id").is((Object)((RestNodeChildAssociationModel)secondaryChildAssoc.getEntryByIndex(1)).getChildId())).and().field("parentId").is((Object)nodesBuilder.getNode("F2").getId())).getAssociation().assertThat().field("isPrimary").is((Object)false)).and().field("assocType").is((Object)"cm:contains");
        ((RestNodeAssociationModel)((RestNodeAssociationModel)secondaryChildren.getEntryByIndex(1)).assertThat().field("id").is((Object)((RestNodeChildAssociationModel)secondaryChildAssoc.getEntryByIndex(2)).getChildId())).getAssociation().assertThat().field("assocType").is((Object)"cm:preferenceImage");
    }

    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY}, description="Check that GET /parents retrieves primary and secondary parents for a node")
    @Test(groups={"rest-api", "nodes", "sanity"})
    public void checkGetNodeParents() throws Exception {
        Step.STEP((String)"1. Create a folder hierarchy folder1/folder2, with folder2 containing file f1");
        NodesBuilder nodesBuilder = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingNode((RepoTestModel)ContentModel.my()).defineNodes();
        nodesBuilder.folder("F1").folder("F2").file("f1");
        Step.STEP((String)"2. Create secondary child associations using POST /nodes/{nodeId}/secondary-children");
        RestNodeChildAssociationModel childAssoc = new RestNodeChildAssociationModel(nodesBuilder.getNode("f1").getId(), "cm:contains");
        this.restClient.withCoreAPI().usingNode((RepoTestModel)nodesBuilder.getNode("F1").toContentModel()).addSecondaryChild(childAssoc);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"3. Get all parents for file 'f1' - both primary and secondary");
        RestNodeAssociationModelCollection parents = this.restClient.withCoreAPI().usingNode((RepoTestModel)nodesBuilder.getNode("f1").toContentModel()).getParents();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        parents.assertThat().entriesListCountIs(2);
        Step.STEP((String)"4. Check using GET /nodes/{nodeId}/parents that the parent (not primary) for f1 is found");
        parents = this.restClient.withParams(new String[]{"where=(isPrimary=false)"}).withCoreAPI().usingNode((RepoTestModel)nodesBuilder.getNode("f1").toContentModel()).getParents();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        parents.assertThat().entriesListCountIs(1);
        ((RestNodeAssociationTypeModel)((RestNodeAssociationModel)((RestNodeAssociationModel)((RestNodeAssociationModel)((RestNodeAssociationModel)parents.getEntryByIndex(0)).assertThat().field("isFolder").is((Object)"true")).and().field("isFile").is((Object)false)).and().field("name").is((Object)nodesBuilder.getNode("F1").getName())).getAssociation().assertThat().field("isPrimary").is((Object)false)).and().field("assocType").is((Object)"cm:contains");
    }
}

