/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.people;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetPeopleCoreTests
extends RestTest {
    UserModel userModel;
    SiteModel siteModel;
    UserModel searchedUser;
    UserModel adminUser;
    UserModel managerUser;
    UserModel inexistentUser;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userModel = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.searchedUser = this.dataUser.createRandomTestUser();
        this.managerUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(this.managerUser, this.siteModel, UserRole.SiteManager);
        this.inexistentUser = new UserModel("inexistentUser", "password");
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify inexistent user cannot get a person with Rest API and response is 401")
    public void inexistentUserIsUnauthorizedToGetPerson() throws Exception {
        this.restClient.authenticateUser(this.inexistentUser).withCoreAPI().usingUser(this.searchedUser).getPerson();
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user cannot get a person that doesn't exists with Rest API and response is 404")
    public void userCannotGetInexistentPerson() throws Exception {
        this.restClient.authenticateUser(this.managerUser).withCoreAPI().usingUser(this.inexistentUser).getPerson();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
        this.restClient.assertLastError().containsSummary(String.format(this.inexistentUser.getUsername(), RestErrorModel.ENTITY_NOT_FOUND));
    }
}

