/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.sites;

import java.util.List;
import org.alfresco.dataprep.SiteService;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestPaginationModel;
import org.alfresco.rest.model.RestSiteContainerModelsCollection;
import org.alfresco.rest.model.RestSiteMemberModel;
import org.alfresco.rest.model.RestSiteMemberModelsCollection;
import org.alfresco.rest.model.RestSiteModel;
import org.alfresco.rest.model.RestSiteModelsCollection;
import org.alfresco.utility.constants.ContainerName;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetSitesTests
extends RestTest {
    private UserModel adminUser;
    private UserModel lastPrivateSiteManager;
    private DataUser.ListUserWithRoles usersWithRoles;
    private SiteModel siteModel;
    private UserModel regularUser;
    private UserModel privateSiteManager;
    private UserModel privateSiteConsumer;
    private SiteModel firstPublicSite;
    private SiteModel firstPrivateSite;
    private SiteModel firstModeratedSite;
    private SiteModel deletedSite;
    private SiteModel lastPublicSite;
    private SiteModel lastPrivateSite;
    private SiteModel lastModeratedSite;
    private RestSiteModelsCollection sites;
    private String name;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.regularUser = this.dataUser.createRandomTestUser();
        this.lastPrivateSiteManager = this.dataUser.createRandomTestUser();
        this.privateSiteManager = this.dataUser.createRandomTestUser();
        this.privateSiteConsumer = this.dataUser.createRandomTestUser();
        this.siteModel = new SiteModel(RandomData.getRandomName((String)"0-PublicSite"));
        this.firstPublicSite = ((DataSite)this.dataSite.usingAdmin()).createSite(this.siteModel);
        this.siteModel = new SiteModel(RandomData.getRandomName((String)"0-PrivateSite"), SiteService.Visibility.PRIVATE);
        this.firstPrivateSite = ((DataSite)this.dataSite.usingAdmin()).createSite(this.siteModel);
        this.siteModel = new SiteModel(RandomData.getRandomName((String)"0-ModeratedSite"), SiteService.Visibility.MODERATED);
        this.firstModeratedSite = ((DataSite)this.dataSite.usingAdmin()).createSite(this.siteModel);
        this.dataUser.addUserToSite(this.privateSiteManager, this.firstPrivateSite, UserRole.SiteManager);
        this.dataUser.addUserToSite(this.privateSiteConsumer, this.firstPrivateSite, UserRole.SiteConsumer);
        this.deletedSite = ((DataSite)this.dataSite.usingAdmin()).createPublicRandomSite();
        this.name = RandomData.getRandomName((String)"ZZZZZZZZZ-PublicSite");
        this.lastPublicSite = ((DataSite)this.dataSite.usingAdmin()).createSite(new SiteModel(SiteService.Visibility.PUBLIC, "guid", this.name, this.name, this.name));
        this.lastPrivateSite = ((DataSite)this.dataSite.usingAdmin()).createSite(new SiteModel(RandomData.getRandomName((String)"ZZZZZZZZZ-PrivateSite"), SiteService.Visibility.PRIVATE));
        this.lastModeratedSite = ((DataSite)this.dataSite.usingAdmin()).createSite(new SiteModel(RandomData.getRandomName((String)"ZZZZZZZZZ-ModeratedSite"), SiteService.Visibility.MODERATED));
        this.adminUser = this.dataUser.getAdminUser();
        this.siteModel = ((DataSite)this.dataSite.usingAdmin()).createPublicRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.siteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        this.dataUser.addUserToSite(this.lastPrivateSiteManager, this.lastPrivateSite, UserRole.SiteManager);
    }

    @Test(groups={"rest-api", "sites", "sanity"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.SANITY}, description="Verify user with Manager role gets sites information and gets status code OK (200)")
    public void managerIsAbleToRetrieveSites() throws Exception {
        ((RestModels)((RestModels)this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withParams(new String[]{"maxItems=10000"}).withCoreAPI().getSites().assertThat().entriesListIsNotEmpty()).assertThat().entriesListContains("id", this.siteModel.getId())).and().paginationExist();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Collaborator role gets sites information and gets status code OK (200)")
    public void collaboratorIsAbleToRetrieveSites() throws Exception {
        ((RestModels)((RestModels)this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withParams(new String[]{"maxItems=10000"}).withCoreAPI().getSites().assertThat().entriesListIsNotEmpty()).assertThat().entriesListContains("id", this.siteModel.getId())).and().paginationExist();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Contributor role gets sites information and gets status code OK (200)")
    public void contributorIsAbleToRetrieveSites() throws Exception {
        ((RestModels)((RestModels)this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withParams(new String[]{"maxItems=10000"}).withCoreAPI().getSites().assertThat().entriesListIsNotEmpty()).assertThat().entriesListContains("id", this.siteModel.getId())).and().paginationExist();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Consumer role gets sites information and gets status code OK (200)")
    public void consumerIsAbleToRetrieveSites() throws Exception {
        ((RestModels)((RestModels)this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withParams(new String[]{"maxItems=10000"}).withCoreAPI().getSites().assertThat().entriesListIsNotEmpty()).assertThat().entriesListContains("id", this.siteModel.getId())).and().paginationExist();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Admin user gets sites information and gets status code OK (200)")
    public void adminUserIsAbleToRetrieveSites() throws Exception {
        ((RestModels)((RestModels)this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"maxItems=10000"}).withCoreAPI().getSites().assertThat().entriesListIsNotEmpty()).assertThat().entriesListContains("id", this.siteModel.getId())).and().paginationExist();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "sanity"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.SANITY}, description="Failed authentication get sites call returns status code 401")
    public void unauthenticatedUserIsNotAuthorizedToRetrieveSites() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        UserModel userModel = this.dataUser.createRandomTestUser();
        userModel.setPassword("user wrong password");
        this.dataUser.addUserToSite(userModel, this.siteModel, UserRole.SiteManager);
        this.restClient.authenticateUser(userModel).withParams(new String[]{"maxItems=1"}).withCoreAPI().getSites();
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if get sites request returns status code 400 when invalid maxItems parameter is used")
    public void getSitesWithInvalidMaxItems() throws Exception {
        this.restClient.authenticateUser(this.regularUser).withParams(new String[]{"maxItems=0=09"}).withCoreAPI().getSites();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_MAXITEMS, "0=09"));
        this.restClient.withParams(new String[]{"maxItems=A"}).withCoreAPI().getSites();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_MAXITEMS, "A"));
        this.restClient.withParams(new String[]{"maxItems=0"}).withCoreAPI().getSites();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if get sites request returns status code 400 when invalid skipCount parameter is used")
    public void getSitesWithInvalidSkipCount() throws Exception {
        this.restClient.authenticateUser(this.regularUser).withParams(new String[]{"skipCount=A"}).withCoreAPI().getSites();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_SKIPCOUNT, "A"));
        this.restClient.authenticateUser(this.regularUser).withParams(new String[]{"skipCount=-1"}).withCoreAPI().getSites();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.NEGATIVE_VALUES_SKIPCOUNT);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if User gets sites ordered by title ascending and status code is 200")
    public void getSitesOrderedByTitleASC() throws Exception {
        this.sites = this.restClient.authenticateUser(this.privateSiteManager).withParams(new String[]{"orderBy=title ASC"}).withCoreAPI().getSites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.sites.assertThat().entriesListIsNotEmpty();
        List sitesList = this.sites.getEntries();
        ((RestSiteModel)sitesList.get(0)).onModel().assertThat().field("title").is((Object)this.firstModeratedSite.getTitle());
        ((RestSiteModel)sitesList.get(1)).onModel().assertThat().field("title").is((Object)this.firstPrivateSite.getTitle());
        ((RestSiteModel)sitesList.get(2)).onModel().assertThat().field("title").is((Object)this.firstPublicSite.getTitle());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if a regular user gets all public and moderated sites and status code is 200")
    public void regularUserGetsOnlyPublicAndModeratedSites() throws Exception {
        this.sites = this.restClient.authenticateUser(this.regularUser).withParams(new String[]{"maxItems=5000"}).withCoreAPI().getSites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.sites.assertThat().entriesListContains("title", this.firstPublicSite.getTitle())).and().entriesListContains("title", this.firstModeratedSite.getTitle())).and().entriesListDoesNotContain("title", this.firstPrivateSite.getTitle());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if a member of a private site gets the private site, all public sites and all moderated sites. Verify if status code is 200")
    public void privateSiteMemberGetsSitesVisibleForHim() throws Exception {
        this.sites = this.restClient.authenticateUser(this.privateSiteConsumer).withParams(new String[]{"maxItems=5000"}).withCoreAPI().getSites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.sites.assertThat().entriesListContains("title", this.firstPublicSite.getTitle())).and().entriesListContains("title", this.firstModeratedSite.getTitle())).and().entriesListContains("title", this.firstPrivateSite.getTitle());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if a site is not retrieved anymore after deletion and status code is 200")
    public void checkDeletedSiteIsNotRetrieved() throws Exception {
        this.sites = this.restClient.authenticateUser(this.regularUser).withParams(new String[]{"maxItems=5000"}).withCoreAPI().getSites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.sites.assertThat().entriesListContains("title", this.deletedSite.getTitle());
        ((DataSite)this.dataSite.usingAdmin()).deleteSite(this.deletedSite);
        this.sites = this.restClient.withParams(new String[]{"maxItems=5000"}).withCoreAPI().getSites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.sites.assertThat().entriesListDoesNotContain("title", this.deletedSite.getTitle());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if User gets sites ordered by title descending and status code is 200")
    public void getSitesOrderedByTitleDESC() throws Exception {
        int totalItems = this.restClient.authenticateUser(this.lastPrivateSiteManager).withCoreAPI().getSites().getPagination().getTotalItems();
        this.sites = this.restClient.authenticateUser(this.lastPrivateSiteManager).withParams(new String[]{String.format("maxItems=%s&orderBy=title DESC", totalItems)}).withCoreAPI().getSites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.sites.assertThat().entriesListIsNotEmpty();
        List sitesList = this.sites.getEntries();
        ((RestSiteModel)sitesList.get(0)).onModel().assertThat().field("title").is((Object)this.lastPublicSite.getTitle());
        ((RestSiteModel)sitesList.get(1)).onModel().assertThat().field("title").is((Object)this.lastPrivateSite.getTitle());
        ((RestSiteModel)sitesList.get(2)).onModel().assertThat().field("title").is((Object)this.lastModeratedSite.getTitle());
        ((RestSiteModel)sitesList.get(sitesList.size() - 1)).onModel().assertThat().field("title").is((Object)this.firstModeratedSite.getTitle());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if User gets sites ordered by id ascending and status code is 200")
    public void getSitesOrderedByIdASC() throws Exception {
        int totalItems = this.restClient.authenticateUser(this.lastPrivateSiteManager).withCoreAPI().getSites().getPagination().getTotalItems();
        this.sites = this.restClient.authenticateUser(this.lastPrivateSiteManager).withParams(new String[]{String.format("maxItems=%s&orderBy=id ASC", totalItems)}).withCoreAPI().getSites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.sites.assertThat().entriesListIsNotEmpty();
        List sitesList = this.sites.getEntries();
        ((RestSiteModel)sitesList.get(sitesList.size() - 1)).onModel().assertThat().field("id").is((Object)this.lastPublicSite.getId());
        ((RestSiteModel)sitesList.get(sitesList.size() - 2)).onModel().assertThat().field("id").is((Object)this.lastPrivateSite.getId());
        ((RestSiteModel)sitesList.get(sitesList.size() - 3)).onModel().assertThat().field("id").is((Object)this.lastModeratedSite.getId());
        ((RestSiteModel)sitesList.get(0)).onModel().assertThat().field("id").is((Object)this.firstModeratedSite.getId());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify pagination")
    public void checkPagination() throws Exception {
        this.sites = this.restClient.authenticateUser(this.regularUser).withCoreAPI().getSites();
        ((RestPaginationModel)((RestPaginationModel)((RestPaginationModel)((RestPaginationModel)this.sites.getPagination().assertThat().field("totalItems").isNotEmpty()).and().field("maxItems").is((Object)"100")).and().field("hasMoreItems").is((Object)(this.sites.getPagination().getTotalItems() > this.sites.getPagination().getMaxItems() ? "true" : "false"))).and().field("skipCount").is((Object)"0")).and().field("count").is((Object)(this.sites.getPagination().isHasMoreItems() ? this.sites.getPagination().getMaxItems() : this.sites.getPagination().getTotalItems().intValue()));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user can get only first two sites and status code is 200")
    public void getFirstTwoSites() throws Exception {
        this.sites = this.restClient.authenticateUser(this.regularUser).withParams(new String[]{String.format("maxItems=%s&orderBy=title ASC", 2)}).withCoreAPI().getSites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestPaginationModel)this.sites.getPagination().assertThat().field("maxItems").is((Object)"2")).and().field("count").is((Object)"2");
        ((RestModels)this.sites.assertThat().entriesListCountIs(2)).and().entriesListDoesNotContain(this.firstPublicSite.getId());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user can get sites using high skipCount parameter and status code is 200")
    public void getSitesUsingHighSkipCount() throws Exception {
        RestSiteModelsCollection allSites = this.restClient.authenticateUser(this.regularUser).withCoreAPI().getSites();
        this.sites = this.restClient.withParams(new String[]{"skipCount=100"}).withCoreAPI().getSites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.sites.assertThat().paginationField("skipCount").is("100");
        if (allSites.getPagination().getTotalItems() > 100) {
            this.sites.assertThat().entriesListIsNotEmpty();
        } else {
            this.sites.assertThat().entriesListIsEmpty();
        }
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user can not get sites using zero maxItems parameter and status code is 400")
    public void userCanNotGetSitesUsingZeroMaxItems() throws Exception {
        this.sites = this.restClient.authenticateUser(this.regularUser).withParams(new String[]{"maxItems=0"}).withCoreAPI().getSites();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS).containsSummary(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that getSites request applies valid properties param and status code is 200")
    public void getSitesRequestWithValidPropertiesParam() throws Exception {
        this.sites = this.restClient.authenticateUser(this.regularUser).withParams(new String[]{"properties=id"}).withCoreAPI().getSites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)((RestModels)this.sites.assertThat().entriesListDoesNotContain("description")).assertThat().entriesListDoesNotContain("title")).assertThat().entriesListDoesNotContain("visibility")).assertThat().entriesListDoesNotContain("guid")).assertThat().entriesListContains("id");
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify pagination when skipCount and MaxItems are used")
    public void checkPaginationWithSkipCountAndMaxItems() throws Exception {
        this.sites = this.restClient.authenticateUser(this.regularUser).withParams(new String[]{"skipCount=10&maxItems=110"}).withCoreAPI().getSites();
        int expectedCount = this.sites.getPagination().isHasMoreItems() ? this.sites.getPagination().getMaxItems() : (this.sites.getPagination().getTotalItems() < this.sites.getPagination().getSkipCount() ? 0 : this.sites.getPagination().getTotalItems() - this.sites.getPagination().getSkipCount());
        ((RestPaginationModel)((RestPaginationModel)((RestPaginationModel)((RestPaginationModel)this.sites.getPagination().assertThat().field("totalItems").isNotEmpty()).and().field("maxItems").is((Object)"110")).and().field("hasMoreItems").is((Object)(this.sites.getPagination().getTotalItems() - this.sites.getPagination().getSkipCount() > this.sites.getPagination().getMaxItems() ? "true" : "false"))).and().field("skipCount").is((Object)"10")).and().field("count").is((Object)expectedCount);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if User gets sites ordered by id ascending and status code is 200")
    public void getSitesOrderedByTitleASCAndVisibilityASC() throws Exception {
        SiteModel secondPublicSite = ((DataSite)this.dataSite.usingAdmin()).createSite(new SiteModel(SiteService.Visibility.PUBLIC, "guid", this.name + "A", this.name + "A", this.name));
        SiteModel thirdPublicSite = ((DataSite)this.dataSite.usingAdmin()).createSite(new SiteModel(SiteService.Visibility.PUBLIC, "guid", this.name + "B", this.name + "B", this.name));
        int totalItems = this.restClient.authenticateUser(this.regularUser).withCoreAPI().getSites().getPagination().getTotalItems();
        this.sites = this.restClient.authenticateUser(this.regularUser).withParams(new String[]{String.format("maxItems=%s&orderBy=title ASC&orderBy=description ASC", totalItems)}).withCoreAPI().getSites();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.sites.assertThat().entriesListIsNotEmpty();
        List sitesList = this.sites.getEntries();
        ((RestSiteModel)sitesList.get(sitesList.size() - 1)).onModel().assertThat().field("title").is((Object)thirdPublicSite.getTitle());
        ((RestSiteModel)sitesList.get(sitesList.size() - 2)).onModel().assertThat().field("title").is((Object)secondPublicSite.getTitle());
        ((DataSite)this.dataSite.usingAdmin()).deleteSite(secondPublicSite);
        ((DataSite)this.dataSite.usingAdmin()).deleteSite(thirdPublicSite);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Check that relations parameter is applied for containers")
    public void checkThatRelationsParameterIsAppliedForContainers() throws Exception {
        List jsonObjects = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"relations=containers"}).withCoreAPI().usingSite(this.lastPublicSite).getSitesWithRelations();
        List siteObjects = (List)jsonObjects.get(0);
        for (int i = 0; i < siteObjects.size(); ++i) {
            RestSiteModel siteModel = (RestSiteModel)siteObjects.get(i);
            ((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)siteModel.assertThat().field("visibility").isNotEmpty()).and().field("id").isNotEmpty()).and().field("title").isNotEmpty()).and().field("preset").is((Object)"site-dashboard")).and().field("guid").isNotEmpty();
        }
        List containerObjects = (List)jsonObjects.get(1);
        for (int i = 0; i < containerObjects.size(); ++i) {
            RestSiteContainerModelsCollection containers = (RestSiteContainerModelsCollection)containerObjects.get(i);
            ((RestModels)containers.assertThat().entriesListIsNotEmpty()).and().entriesListContains("folderId", ContainerName.documentLibrary.toString());
        }
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Check that relations parameter is applied for members")
    public void checkThatRelationsParameterIsAppliedForMembers() throws Exception {
        List jsonObjects = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"relations=members"}).withCoreAPI().usingSite(this.lastPublicSite).getSitesWithRelations();
        List siteObjects = (List)jsonObjects.get(0);
        for (int i = 0; i < siteObjects.size(); ++i) {
            RestSiteModel siteModel = (RestSiteModel)siteObjects.get(i);
            ((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)siteModel.assertThat().field("visibility").isNotEmpty()).and().field("id").isNotEmpty()).and().field("title").isNotEmpty()).and().field("preset").is((Object)"site-dashboard")).and().field("guid").isNotEmpty();
        }
        List memberObjects = (List)jsonObjects.get(1);
        for (int i = 0; i < memberObjects.size(); ++i) {
            RestSiteMemberModelsCollection siteMembers = (RestSiteMemberModelsCollection)memberObjects.get(i);
            ((RestModels)((RestModels)siteMembers.assertThat().entriesListIsNotEmpty()).assertThat().entriesListContains("id")).assertThat().entriesListContains("role", UserRole.SiteManager.toString());
            ((RestSiteMemberModel)((RestSiteMemberModel)siteMembers.getOneRandomEntry()).onModel().assertThat().field("person.firstName").isNotEmpty()).and().field("person.id").isNotEmpty();
        }
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Check that relations parameter is applied for members and containers")
    public void checkThatRelationsParameterIsAppliedForMembersAndContainers() throws Exception {
        List jsonObjects = this.restClient.authenticateUser(this.adminUser).withParams(new String[]{"relations=containers,members"}).withCoreAPI().usingSite(this.lastPublicSite).getSitesWithRelations();
        List siteObjects = (List)jsonObjects.get(0);
        for (int i = 0; i < siteObjects.size(); ++i) {
            RestSiteModel siteModel = (RestSiteModel)siteObjects.get(i);
            ((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)siteModel.assertThat().field("visibility").isNotEmpty()).and().field("id").isNotEmpty()).and().field("title").isNotEmpty()).and().field("preset").is((Object)"site-dashboard")).and().field("guid").isNotEmpty();
        }
        List containerObjects = (List)jsonObjects.get(1);
        for (int i = 0; i < containerObjects.size(); ++i) {
            RestSiteContainerModelsCollection containers = (RestSiteContainerModelsCollection)containerObjects.get(i);
            ((RestModels)containers.assertThat().entriesListIsNotEmpty()).and().entriesListContains("folderId", ContainerName.documentLibrary.toString());
        }
        List memberObjects = (List)jsonObjects.get(2);
        for (int i = 0; i < memberObjects.size(); ++i) {
            RestSiteMemberModelsCollection siteMembers = (RestSiteMemberModelsCollection)memberObjects.get(i);
            ((RestModels)((RestModels)siteMembers.assertThat().entriesListIsNotEmpty()).assertThat().entriesListContains("id")).assertThat().entriesListContains("role", UserRole.SiteManager.toString());
            ((RestSiteMemberModel)((RestSiteMemberModel)siteMembers.getOneRandomEntry()).onModel().assertThat().field("person.firstName").isNotEmpty()).and().field("person.id").isNotEmpty();
        }
    }

    @AfterClass(alwaysRun=true)
    public void cleanup() throws Exception {
        ((DataSite)this.dataSite.usingAdmin()).deleteSite(this.firstModeratedSite);
        ((DataSite)this.dataSite.usingAdmin()).deleteSite(this.firstPrivateSite);
        ((DataSite)this.dataSite.usingAdmin()).deleteSite(this.firstPublicSite);
        ((DataSite)this.dataSite.usingAdmin()).deleteSite(this.lastPublicSite);
        ((DataSite)this.dataSite.usingAdmin()).deleteSite(this.lastPrivateSite);
        ((DataSite)this.dataSite.usingAdmin()).deleteSite(this.lastModeratedSite);
    }
}

