/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.tasks.variables;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestVariableModel;
import org.alfresco.rest.model.RestVariableModelsCollection;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TaskModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AddTaskVariablesTestsBulk3
extends RestTest {
    private UserModel userWhoStartsTask;
    private UserModel adminUser;
    private SiteModel siteModel;
    private FileModel fileModel;
    private UserModel assigneeUser;
    private TaskModel taskModel;
    private RestVariableModel restVariablemodel;
    private RestVariableModel variableModel;
    private RestVariableModel variableModel1;
    private RestVariableModelsCollection restVariableCollection;
    private String taskId;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userWhoStartsTask = this.dataUser.createRandomTestUser();
        this.assigneeUser = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.adminUser)).createPublicRandomSite();
        this.fileModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assigneeUser);
        this.taskId = this.taskModel.getId();
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Create task variable with name containing symbols")
    public void createTaskVariableWithSymbolsInName() throws Exception {
        UserModel adminUser = this.dataUser.getAdminUser();
        this.restClient.authenticateUser(adminUser);
        RestVariableModel variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        variableModel.setName("!@#$%^&*({}<>.,;'=_|");
        this.restVariablemodel = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestVariableModel)((RestVariableModel)((RestVariableModel)this.restVariablemodel.assertThat().field("scope").is((Object)variableModel.getScope())).and().field("name").is((Object)variableModel.getName())).and().field("value").is(variableModel.getValue())).and().field("type").is((Object)variableModel.getType());
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Create multiple task variable with name containing symbols")
    public void createMultipleTaskVariableWithSymbolsInName() throws Exception {
        UserModel adminUser = this.dataUser.getAdminUser();
        this.restClient.authenticateUser(adminUser);
        this.variableModel1 = RestVariableModel.getRandomTaskVariableModel((String)"global", (String)"d:text");
        this.variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.variableModel.setName("!@#$%^&*({}<>.,;'=_|");
        this.restVariableCollection = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariables(new RestVariableModel[]{this.variableModel, this.variableModel1});
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestVariableModel)((RestVariableModel)((RestVariableModel)((RestVariableModel)this.restVariableCollection.getEntries().get(0)).onModel().assertThat().field("scope").is((Object)this.variableModel.getScope())).and().field("name").is((Object)this.variableModel.getName())).and().field("value").is(this.variableModel.getValue())).and().field("type").is((Object)this.variableModel.getType());
        ((RestVariableModel)((RestVariableModel)((RestVariableModel)((RestVariableModel)this.restVariableCollection.getEntries().get(1)).onModel().assertThat().field("scope").is((Object)this.variableModel1.getScope())).and().field("name").is((Object)this.variableModel1.getName())).and().field("value").is(this.variableModel1.getValue())).and().field("type").is((Object)this.variableModel1.getType());
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Create task variable with empty name")
    public void createTaskVariableWithEmptyName() throws Exception {
        UserModel adminUser = this.dataUser.getAdminUser();
        this.restClient.authenticateUser(adminUser);
        RestVariableModel variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        variableModel.setName("");
        this.restVariablemodel = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(RestErrorModel.VARIABLE_NAME_REQUIRED).containsSummary(RestErrorModel.VARIABLE_NAME_REQUIRED).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Update task variable with invalid variable name")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void createTaskVariableWithInvalidVariableName() throws Exception {
        this.restClient.authenticateUser(this.adminUser).withWorkflowAPI();
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)"{\"scope\": \"local\",\"names\": \"varName\",\"value\": \"test\",\"type\": \"d:text\"}", (String)"tasks/{taskId}/variables", (String[])new String[]{this.taskId});
        this.restClient.processModel(RestVariableModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.NO_CONTENT, "Unrecognized field \"names\""));
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Create task variable with invalid name")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void createTaskVariableWithInvalidName() throws Exception {
        this.restClient.authenticateUser(this.adminUser).withWorkflowAPI();
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)"{\"scope\": \"local\",\"name\": ',\"value\": \"test\",\"type\": \"d:text\"}", (String)"tasks/{taskId}/variables", (String[])new String[]{this.taskId});
        this.restClient.processModel(RestVariableModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.NO_CONTENT, "Unexpected character ('''"));
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Create task variable with empty name")
    public void failedCreatingMultipleTaskVariableWithEmptyName() throws Exception {
        UserModel adminUser = this.dataUser.getAdminUser();
        this.restClient.authenticateUser(adminUser);
        this.variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.variableModel1 = RestVariableModel.getRandomTaskVariableModel((String)"global", (String)"d:text");
        this.variableModel.setName("");
        this.restVariableCollection = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariables(new RestVariableModel[]{this.variableModel, this.variableModel1});
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(RestErrorModel.VARIABLE_NAME_REQUIRED).containsSummary(RestErrorModel.VARIABLE_NAME_REQUIRED).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }
}

