/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.core;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.restassured.RestAssured;
import io.restassured.builder.RequestSpecBuilder;
import io.restassured.http.ContentType;
import io.restassured.http.Headers;
import io.restassured.parsing.Parser;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.alfresco.rest.core.RestAisAuthentication;
import org.alfresco.rest.core.RestProperties;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestResponse;
import org.alfresco.rest.exception.EmptyJsonResponseException;
import org.alfresco.rest.exception.JsonToModelConversionException;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestHtmlResponse;
import org.alfresco.rest.model.RestSiteContainerModelsCollection;
import org.alfresco.rest.model.RestSiteMemberModelsCollection;
import org.alfresco.rest.model.RestSiteModel;
import org.alfresco.rest.model.RestTextResponse;
import org.alfresco.rest.requests.AdminConsole;
import org.alfresco.rest.requests.Tenant;
import org.alfresco.rest.requests.aosAPI.RestAosAPI;
import org.alfresco.rest.requests.authAPI.RestAuthAPI;
import org.alfresco.rest.requests.cmisAPI.RestCmisAPI;
import org.alfresco.rest.requests.coreAPI.RestCoreAPI;
import org.alfresco.rest.requests.discoveryAPI.RestDiscoveryAPI;
import org.alfresco.rest.requests.modelAPI.RestModelAPI;
import org.alfresco.rest.requests.privateAPI.RestPrivateAPI;
import org.alfresco.rest.requests.search.SearchAPI;
import org.alfresco.rest.requests.search.SearchSQLAPI;
import org.alfresco.rest.requests.search.SearchSQLJDBC;
import org.alfresco.rest.requests.search.ShardInfoAPI;
import org.alfresco.rest.requests.search.SolrAPI;
import org.alfresco.rest.requests.search.SolrAdminAPI;
import org.alfresco.rest.requests.workflowAPI.RestWorkflowAPI;
import org.alfresco.utility.LogFactory;
import org.alfresco.utility.Utility;
import org.alfresco.utility.dsl.DSLWrapper;
import org.alfresco.utility.model.StatusModel;
import org.alfresco.utility.model.TestModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.testng.Assert;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

@Service
@Scope(value="prototype")
public class RestWrapper
extends DSLWrapper<RestWrapper> {
    private static final Integer IGNORE_CONTENT_LIMIT_BYTES = 0x400000;
    @Autowired
    protected RestProperties restProperties;
    private Logger LOG = LogFactory.getLogger();
    private RequestSpecification request;
    private RestErrorModel lastError;
    private StatusModel lastStatusModel;
    private Object lastException = "";
    private UserModel currentUser;
    private String statusCode;
    private String parameters = "";
    private ContentType defaultContentType = ContentType.JSON;
    private RequestSpecBuilder requestSpecBuilder = new RequestSpecBuilder();
    private Headers responseHeaders;
    private RestResponse response;
    private String serverURI;
    private int serverPort;
    @Autowired
    private RestAisAuthentication aisAuthentication;

    public void setServerURI(String serverURI) {
        this.serverURI = serverURI;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public void setResponseHeaders(Headers responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public Headers getResponseHeaders() {
        return this.responseHeaders;
    }

    public RestWrapper assertHeaderValueContains(String headerName, String expectedHeaderValue) {
        Step.STEP((String)String.format("REST API: Assert that header value contains %s", expectedHeaderValue));
        String actualHeaderValue = this.getResponseHeaders().getValue(headerName);
        Assert.assertTrue((boolean)this.getResponseHeaders().getValue(headerName).contains(expectedHeaderValue), (String)String.format("Header %s is %s", headerName, actualHeaderValue));
        return this;
    }

    @PostConstruct
    public void initializeRequestSpecBuilder() {
        this.serverURI = this.restProperties.envProperty().getTestServerUrl();
        this.serverPort = this.restProperties.envProperty().getPort();
        this.configureServerEndpoint();
    }

    public RestWrapper authenticateUser(UserModel userModel) {
        Step.STEP((String)String.format("REST API: Basic Authentication using user {%s}", userModel.toString()));
        this.currentUser = userModel;
        this.setTestUser(userModel);
        return this;
    }

    public RestWrapper noAuthentication() {
        Step.STEP((String)"REST API: No Authentication");
        this.currentUser = null;
        this.setTestUser(null);
        return this;
    }

    protected RequestSpecification onRequest() {
        if (this.currentUser != null) {
            if (this.aisAuthentication.isAisAuthenticationEnabled().booleanValue()) {
                this.configureRequestSpec().setAuth(RestAssured.oauth2((String)this.aisAuthentication.getAisAuthenticationToken(this.currentUser)));
            } else {
                this.configureRequestSpec().setAuth(RestAssured.basic((String)this.currentUser.getUsername(), (String)this.currentUser.getPassword()));
            }
        }
        this.request = RestAssured.given().spec(this.configureRequestSpec().build());
        this.usingContentType(ContentType.JSON);
        return this.request;
    }

    private RestErrorModel getLastError() {
        if (this.lastError == null) {
            return new RestErrorModel();
        }
        return this.lastError;
    }

    public void setLastError(RestErrorModel errorModel) {
        this.lastError = errorModel;
    }

    public RestErrorModel assertLastError() {
        return this.getLastError();
    }

    public StatusModel assertLastStatus() {
        return this.getLastStatus();
    }

    public RestWrapper assertLastExceptionContains(String exception) {
        if (!this.lastException.toString().contains(exception)) {
            Assert.fail((String)String.format("Expected exception {%s} but found {%s}", exception, this.lastException));
        }
        return this;
    }

    public <T> T processModels(Class<T> classz, RestRequest restRequest) throws EmptyJsonResponseException, JsonToModelConversionException {
        T models = this.callAPIAndCreateModel(classz, restRequest, "list");
        if (models == null) {
            try {
                return classz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return models;
    }

    public <T> T processModel(Class<T> classz, RestRequest restRequest) throws EmptyJsonResponseException, JsonToModelConversionException {
        T model = this.callAPIAndCreateModel(classz, restRequest, "entry");
        if (model == null) {
            try {
                return classz.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return model;
    }

    private <T> T callAPIAndCreateModel(Class<T> classz, RestRequest restRequest, String path) {
        Response returnedResponse = this.sendRequest(restRequest);
        this.setStatusCode(String.valueOf(returnedResponse.getStatusCode()));
        boolean responseHasErrors = this.checkForJsonError(returnedResponse);
        boolean responseHasExceptions = this.checkForJsonStatusException(returnedResponse);
        Object models = null;
        if (!responseHasExceptions && !responseHasErrors) {
            try {
                models = returnedResponse.jsonPath().getObject(path, classz);
                this.validateJsonModelSchema(classz, models);
            }
            catch (Exception processError) {
                processError.printStackTrace();
                throw new JsonToModelConversionException(classz, processError);
            }
        }
        return (T)models;
    }

    public JSONObject processJson(RestRequest restRequest) throws EmptyJsonResponseException, JsonToModelConversionException {
        Response returnedResponse = this.sendRequest(restRequest);
        this.setStatusCode(String.valueOf(returnedResponse.getStatusCode()));
        boolean responseHasErrors = this.checkForJsonError(returnedResponse);
        boolean responseHasExceptions = this.checkForJsonStatusException(returnedResponse);
        JSONObject response = null;
        try {
            if (!responseHasExceptions && !responseHasErrors) {
                JSONObject jsonObject = new JSONObject(returnedResponse.getBody().asString());
                response = jsonObject.getJSONObject("entry");
            }
        }
        catch (Exception processError) {
            throw new EmptyJsonResponseException(processError.getMessage());
        }
        return response;
    }

    public List<Object> processRelationsJson(RestRequest restRequest) {
        ArrayList<Object> jsonObjects = new ArrayList<Object>();
        Response returnedResponse = this.sendRequest(restRequest);
        this.setStatusCode(String.valueOf(returnedResponse.getStatusCode()));
        boolean responseHasErrors = this.checkForJsonError(returnedResponse);
        boolean responseHasExceptions = this.checkForJsonStatusException(returnedResponse);
        ObjectMapper mapper = new ObjectMapper();
        JSONObject response = null;
        try {
            if (!responseHasExceptions && !responseHasErrors) {
                JSONObject jsonObject = new JSONObject(returnedResponse.getBody().asString());
                response = jsonObject.getJSONObject("entry");
                RestSiteModel site = (RestSiteModel)mapper.readValue(response.toString(), RestSiteModel.class);
                jsonObjects.add(site);
                if (!jsonObject.getJSONObject("relations").isNull("containers")) {
                    response = jsonObject.getJSONObject("relations").getJSONObject("containers").getJSONObject("list");
                    RestSiteContainerModelsCollection containers = (RestSiteContainerModelsCollection)mapper.readValue(response.toString(), RestSiteContainerModelsCollection.class);
                    jsonObjects.add(containers);
                }
                if (!jsonObject.getJSONObject("relations").isNull("members")) {
                    response = jsonObject.getJSONObject("relations").getJSONObject("members").getJSONObject("list");
                    RestSiteMemberModelsCollection members = (RestSiteMemberModelsCollection)mapper.readValue(response.toString(), RestSiteMemberModelsCollection.class);
                    jsonObjects.add(members);
                }
            }
        }
        catch (Exception processError) {
            throw new EmptyJsonResponseException(processError.getMessage());
        }
        return jsonObjects;
    }

    public List<List<Object>> processSitesRelationsJson(RestRequest restRequest) {
        ArrayList<List<Object>> allObjects = new ArrayList<List<Object>>();
        ArrayList<RestSiteModel> sitesList = new ArrayList<RestSiteModel>();
        ArrayList<RestSiteContainerModelsCollection> containersList = new ArrayList<RestSiteContainerModelsCollection>();
        ArrayList<RestSiteMemberModelsCollection> membersList = new ArrayList<RestSiteMemberModelsCollection>();
        Response returnedResponse = this.sendRequest(restRequest);
        this.setStatusCode(String.valueOf(returnedResponse.getStatusCode()));
        boolean responseHasErrors = this.checkForJsonError(returnedResponse);
        boolean responseHasExceptions = this.checkForJsonStatusException(returnedResponse);
        ObjectMapper mapper = new ObjectMapper();
        JSONObject response = null;
        try {
            JSONObject jsonObject;
            if (!responseHasExceptions && !responseHasErrors && (jsonObject = new JSONObject(returnedResponse.getBody().asString())).getJSONObject("list").getJSONArray("entries").length() != 0) {
                int i;
                for (i = 0; i < jsonObject.getJSONObject("list").getJSONArray("entries").length(); ++i) {
                    response = jsonObject.getJSONObject("list").getJSONArray("entries").getJSONObject(i).getJSONObject("entry");
                    RestSiteModel site = (RestSiteModel)mapper.readValue(response.toString(), RestSiteModel.class);
                    sitesList.add(site);
                }
                allObjects.add(sitesList);
                if (jsonObject.toString().contains("containers")) {
                    for (i = 0; i < jsonObject.getJSONObject("list").getJSONArray("entries").length(); ++i) {
                        response = jsonObject.getJSONObject("list").getJSONArray("entries").getJSONObject(i).getJSONObject("relations").getJSONObject("containers").getJSONObject("list");
                        RestSiteContainerModelsCollection containers = (RestSiteContainerModelsCollection)mapper.readValue(response.toString(), RestSiteContainerModelsCollection.class);
                        containersList.add(containers);
                    }
                    allObjects.add(containersList);
                }
                if (jsonObject.toString().contains("members")) {
                    for (i = 0; i < jsonObject.getJSONObject("list").getJSONArray("entries").length(); ++i) {
                        response = jsonObject.getJSONObject("list").getJSONArray("entries").getJSONObject(i).getJSONObject("relations").getJSONObject("members").getJSONObject("list");
                        RestSiteMemberModelsCollection members = (RestSiteMemberModelsCollection)mapper.readValue(response.toString(), RestSiteMemberModelsCollection.class);
                        membersList.add(members);
                    }
                    allObjects.add(membersList);
                }
            }
        }
        catch (Exception processError) {
            throw new EmptyJsonResponseException(processError.getMessage());
        }
        return allObjects;
    }

    public RestHtmlResponse processHtmlResponse(RestRequest restRequest) throws EmptyJsonResponseException {
        Response returnedResponse = this.sendRequest(restRequest);
        this.setStatusCode(String.valueOf(returnedResponse.getStatusCode()));
        if (returnedResponse.contentType().contains("json")) {
            this.checkForJsonError(returnedResponse);
            this.checkForJsonStatusException(returnedResponse);
        }
        return new RestHtmlResponse(returnedResponse.getHeaders(), returnedResponse.getBody());
    }

    public RestResponse process(RestRequest restRequest) {
        Response returnedResponse = this.sendRequest(restRequest);
        this.setStatusCode(String.valueOf(returnedResponse.getStatusCode()));
        RestResponse response = new RestResponse(returnedResponse);
        this.setResponseHeaders(response.getResponse().getHeaders());
        return response;
    }

    public RestTextResponse processTextResponse(RestRequest restRequest) {
        Response returnedResponse = this.sendRequest(restRequest);
        this.setStatusCode(String.valueOf(returnedResponse.getStatusCode()));
        if (returnedResponse.contentType().contains("text/plain")) {
            RestAssured.registerParser((String)"text/plain", (Parser)Parser.TEXT);
            RestTextResponse testResponse = new RestTextResponse(returnedResponse);
            return testResponse;
        }
        RestResponse response = new RestResponse(returnedResponse);
        this.setResponseHeaders(response.getResponse().getHeaders());
        RestTextResponse testResponse = new RestTextResponse(returnedResponse);
        return testResponse;
    }

    public void processEmptyModel(RestRequest restRequest) throws EmptyJsonResponseException {
        Response returnedResponse = this.sendRequest(restRequest);
        this.setStatusCode(String.valueOf(returnedResponse.getStatusCode()));
        if (!returnedResponse.asString().isEmpty()) {
            this.checkForJsonError(returnedResponse);
            this.checkForJsonStatusException(returnedResponse);
        }
    }

    public StatusModel getLastStatus() {
        return this.lastStatusModel;
    }

    public void setLastStatus(StatusModel lastStatusModel) {
        this.lastStatusModel = lastStatusModel;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    protected Response sendRequest(RestRequest restRequest) {
        String parameters = this.getParameters();
        if (parameters != null && !parameters.isEmpty()) {
            restRequest.setPathParams(ArrayUtils.addAll((Object[])restRequest.getPathParams(), (Object[])new Object[]{parameters}));
        }
        Step.STEP((String)restRequest.toString());
        HttpMethod httpMethod = restRequest.getHttpMethod();
        Response returnedResponse = HttpMethod.GET.equals((Object)httpMethod) ? (Response)((Response)this.onRequest().get(restRequest.getPath(), restRequest.getPathParams())).andReturn() : (HttpMethod.DELETE.equals((Object)httpMethod) ? (Response)((Response)this.onRequest().delete(restRequest.getPath(), restRequest.getPathParams())).andReturn() : (HttpMethod.HEAD.equals((Object)httpMethod) ? (Response)((Response)this.onRequest().head(restRequest.getPath(), restRequest.getPathParams())).andReturn() : (HttpMethod.OPTIONS.equals((Object)httpMethod) ? (Response)((Response)this.onRequest().options(restRequest.getPath(), restRequest.getPathParams())).andReturn() : (HttpMethod.POST.equals((Object)httpMethod) ? (Response)((Response)this.onRequest().body(restRequest.getBody()).post(restRequest.getPath(), restRequest.getPathParams())).andReturn() : (HttpMethod.PUT.equals((Object)httpMethod) ? (Response)((Response)this.onRequest().body(restRequest.getBody()).contentType(ContentType.JSON.withCharset(restRequest.getContentType())).put(restRequest.getPath(), restRequest.getPathParams())).andReturn() : (HttpMethod.TRACE.equals((Object)httpMethod) ? (Response)((Response)this.onRequest().get(restRequest.getPath(), restRequest.getPathParams())).andReturn() : (Response)((Response)this.onRequest().get(restRequest.getPath(), restRequest.getPathParams())).andReturn()))))));
        this.logResponseInformation(restRequest, returnedResponse);
        this.configureServerEndpoint();
        this.response = new RestResponse(returnedResponse);
        return returnedResponse;
    }

    private void logResponseInformation(RestRequest restRequest, Response returnedResponse) {
        String responseSizeString = returnedResponse.getHeader("Content-Length");
        if (responseSizeString != null && Integer.valueOf(responseSizeString) > IGNORE_CONTENT_LIMIT_BYTES) {
            this.LOG.info("On {} {}, received a response size that was {} bytes.\nThis is bigger than the limit of {} bytes so its content will not be displayed: \n", new Object[]{restRequest.getHttpMethod(), restRequest.getPath(), Integer.valueOf(responseSizeString), IGNORE_CONTENT_LIMIT_BYTES});
        } else if (returnedResponse.asString().isEmpty()) {
            this.LOG.info("On {} {}, received the following response \n{}", new Object[]{restRequest.getHttpMethod(), restRequest.getPath(), returnedResponse.getStatusCode()});
        } else if (returnedResponse.getContentType().contains("image/png")) {
            this.LOG.info("On {} {}, received the response with an image and headers: \n{}", new Object[]{restRequest.getHttpMethod(), restRequest.getPath(), returnedResponse.getHeaders().toString()});
        } else if (returnedResponse.getContentType().contains("application/json")) {
            this.LOG.info("On {} {}, received the following response \n{}", new Object[]{restRequest.getHttpMethod(), restRequest.getPath(), Utility.prettyPrintJsonString((String)returnedResponse.asString())});
        } else if (returnedResponse.getContentType().contains("application/xml")) {
            String response = this.parseXML(returnedResponse);
            this.LOG.info("On {} {}, received the following response \n{}", new Object[]{restRequest.getHttpMethod(), restRequest.getPath(), response});
        } else {
            this.LOG.info("On {} {}, received the following response \n{}", new Object[]{restRequest.getHttpMethod(), restRequest.getPath(), ToStringBuilder.reflectionToString((Object)returnedResponse.asString(), (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE)});
        }
    }

    private String parseXML(Response returnedResponse) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Object result = "";
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(returnedResponse.asString()));
            Document document = db.parse(is);
            OutputFormat format = new OutputFormat(document);
            format.setLineWidth(65);
            format.setIndenting(true);
            format.setIndent(2);
            StringWriter out = new StringWriter();
            XMLSerializer serializer = new XMLSerializer((Writer)out, format);
            serializer.serialize(document);
            result = ((Object)out).toString();
        }
        catch (Exception e) {
            result = "Error Parsing XML file returned: " + e.getMessage();
            this.setStatusCode(String.valueOf(HttpStatus.INTERNAL_SERVER_ERROR.value()));
        }
        return result;
    }

    private boolean checkForJsonError(Response returnedResponse) throws EmptyJsonResponseException {
        this.setLastError(null);
        try {
            returnedResponse.jsonPath().get();
        }
        catch (Exception e) {
            throw new EmptyJsonResponseException(e.getMessage());
        }
        Object error = returnedResponse.jsonPath().get("error");
        if (error != null) {
            this.setLastError((RestErrorModel)returnedResponse.jsonPath().getObject("error", RestErrorModel.class));
            return true;
        }
        return false;
    }

    private boolean checkForJsonStatusException(Response returnedResponse) throws EmptyJsonResponseException {
        Object error;
        try {
            this.lastException = returnedResponse.jsonPath().get("exception");
        }
        catch (Exception e) {
            throw new EmptyJsonResponseException(e.getMessage());
        }
        if (this.lastException == null) {
            this.lastException = "";
        }
        if ((error = returnedResponse.jsonPath().get("status")) != null) {
            this.setLastStatus((StatusModel)returnedResponse.jsonPath().getObject("status", StatusModel.class));
            this.LOG.error("Exception thrown on response: {}", (Object)this.getLastStatus().toInfo());
            return true;
        }
        return false;
    }

    public RestWrapper assertStatusCodeIs(HttpStatus statusCode) {
        Step.STEP((String)String.format("REST API: Assert that status code is %s", statusCode.toString()));
        Assert.assertEquals((String)this.getStatusCode(), (String)String.valueOf(statusCode.value()), (String)"Status code is not as expected.");
        return this;
    }

    private List<Field> getAllDeclaredFields(List<Field> fields, Class<?> classz) {
        if (classz.isAssignableFrom(TestModel.class)) {
            return fields;
        }
        fields.addAll(Arrays.asList(classz.getDeclaredFields()));
        if (classz.getSuperclass() != null) {
            fields = this.getAllDeclaredFields(fields, classz.getSuperclass());
        }
        return fields;
    }

    public <T> void validateJsonModelSchema(Class<T> classz, Object classzInstance) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        List<Field> allFields = this.getAllDeclaredFields(new LinkedList<Field>(), classz);
        for (Field field : allFields) {
            if (!field.isAnnotationPresent(JsonProperty.class) || !field.getAnnotation(JsonProperty.class).required()) continue;
            field.setAccessible(true);
            Object fieldValue = field.get(classzInstance);
            String info = String.format("Checking required field [%s] from class %s - value: %s", field.getName(), classzInstance.getClass().getName(), fieldValue);
            this.LOG.info(info);
            Assert.assertNotNull((Object)fieldValue, (String)info);
            if (field.getType().isPrimitive()) continue;
            this.validateJsonModelSchema(fieldValue.getClass(), fieldValue);
        }
    }

    public String getParameters() {
        String localParam = this.parameters;
        this.clearParameters();
        return localParam;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public void clearParameters() {
        this.setParameters("");
    }

    public RestWrapper clearBasePath() {
        this.configureRequestSpec().setBasePath("");
        return this;
    }

    public RestWrapper withParams(String ... parameters) {
        String paramsStr = Arrays.stream(parameters).collect(Collectors.joining("&"));
        this.setParameters(paramsStr);
        return this;
    }

    public RestCoreAPI withCoreAPI() {
        return new RestCoreAPI(this);
    }

    public RestWorkflowAPI withWorkflowAPI() {
        return new RestWorkflowAPI(this);
    }

    public RestAuthAPI withAuthAPI() {
        return new RestAuthAPI(this);
    }

    public RestModelAPI withModelAPI() {
        return new RestModelAPI(this);
    }

    public SearchAPI withSearchAPI() {
        return new SearchAPI(this);
    }

    public SearchSQLAPI withSearchSqlAPI() {
        return new SearchSQLAPI(this);
    }

    public SearchSQLJDBC withSearchSqlViaJDBC() {
        return new SearchSQLJDBC(this);
    }

    public ShardInfoAPI withShardInfoAPI() {
        return new ShardInfoAPI(this);
    }

    public SolrAPI withSolrAPI() {
        return new SolrAPI(this);
    }

    public SolrAdminAPI withSolrAdminAPI() {
        return new SolrAdminAPI(this);
    }

    public RestDiscoveryAPI withDiscoveryAPI() {
        return new RestDiscoveryAPI(this);
    }

    public AdminConsole withAdminConsole() {
        return new AdminConsole(this);
    }

    public Tenant usingTenant() {
        return new Tenant(this, this.restProperties);
    }

    public RestWrapper where(String whereExpression) {
        String whereClause = "where=(%s)";
        return this.withParams(String.format(whereClause, whereExpression));
    }

    public ContentType getDefaultContentType() {
        return this.defaultContentType;
    }

    public RestWrapper usingContentType(ContentType defaultContentType) {
        this.defaultContentType = defaultContentType;
        return this;
    }

    public RequestSpecBuilder configureRequestSpec() {
        return this.requestSpecBuilder;
    }

    public RestCmisAPI withCMISApi() {
        return new RestCmisAPI(this);
    }

    public RestAosAPI withAosAPI() {
        return new RestAosAPI(this);
    }

    public RestPrivateAPI withPrivateAPI() {
        return new RestPrivateAPI(this);
    }

    public RestResponse onResponse() {
        if (this.response == null) {
            throw new UnsupportedOperationException("Cannot perform on a Response that wasn't yet received!");
        }
        return this.response;
    }

    public <T> T processModelWithoutEntryObject(Class<T> classz, RestRequest restRequest) throws EmptyJsonResponseException, JsonToModelConversionException {
        Response returnedResponse = this.sendRequest(restRequest);
        this.setStatusCode(String.valueOf(returnedResponse.getStatusCode()));
        boolean responseHasErrors = this.checkForJsonError(returnedResponse);
        Object model = null;
        try {
            if (!responseHasErrors) {
                model = returnedResponse.jsonPath().getObject("$", classz);
                this.validateJsonModelSchema(classz, model);
            }
        }
        catch (Exception processError) {
            throw new JsonToModelConversionException(classz, processError);
        }
        if (model == null) {
            try {
                return classz.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (T)model;
    }

    public void configureSyncServiceEndPoint() {
        this.serverURI = this.restProperties.envProperty().getSyncServerUrl();
        this.serverPort = this.restProperties.envProperty().getSyncPort();
        this.configureServerEndpoint();
    }

    public void configureSolrEndPoint() {
        this.serverURI = this.restProperties.envProperty().getSolrServerUrl();
        this.serverPort = this.restProperties.envProperty().getSolrPort();
        this.configureServerEndpoint();
        this.configureSecretHeader();
    }

    private void configureSecretHeader() {
        String solrSecret = this.restProperties.envProperty().getSolrSecret();
        if (!solrSecret.isEmpty()) {
            String solrSecretName = this.restProperties.envProperty().getSolrSecretName();
            this.configureRequestSpec().addHeader(solrSecretName, solrSecret);
        }
    }

    public void configureServerEndpoint() {
        this.requestSpecBuilder = new RequestSpecBuilder();
        RestAssured.baseURI = this.serverURI;
        RestAssured.port = this.serverPort;
        this.configureRequestSpec().setBaseUri(this.serverURI);
        this.configureRequestSpec().setPort(this.serverPort);
    }

    public void configureAlfrescoEndpoint() {
        this.serverURI = this.restProperties.envProperty().getTestServerUrl();
        this.serverPort = this.restProperties.envProperty().getPort();
        this.configureServerEndpoint();
    }
}

