/*-
 * #%L
 * alfresco-tas-restapi
 * %%
 * Copyright (C) 2005 - 2022 Alfresco Software Limited
 * %%
 * This file is part of the Alfresco software. 
 * If the software was purchased under a paid Alfresco license, the terms of 
 * the paid license agreement will prevail.  Otherwise, the software is 
 * provided under the following open source license terms:
 * 
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.alfresco.rest.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

import org.alfresco.rest.core.IRestModel;
import org.alfresco.utility.model.TestModel;

/**
 * Generated by 'msuzuki' on '2017-05-15 10:58' from 'Alfresco Search REST API' swagger file 
 * Generated from 'Alfresco Search REST API' swagger file
 * Base Path {@linkplain /alfresco/api/-default-/public/search/versions/1}
 */
public class RestRequestRangesModel extends TestModel implements IRestModel<RestRequestRangesModel>
{
    @JsonProperty(value = "entry")
    RestRequestRangesModel model;

    @Override
    public RestRequestRangesModel onModel()
    {
        return model;
    }

    /**
    The name of the field to perform range
    */	        

    private String field;	    
    /**
    The start of the range
    */	        

    private String start;	    
    /**
    The end of the range
    */	        

    private String end;	    
    /**
    Bucket size
    */	        

    private String gap;	    
    /**
    If true means that the last bucket will end at “end” even if it is less than “gap” wide.
    */	        

    private boolean hardend;	    
    /**
    before, after, between, non, all
    */	        

    private List<String> other;	    
    /**
    lower, upper, edge, outer, all
    */	        

    private List<String> include;	    
    /**
    Tags used exclude the filters from facet evaluation for multi-select facet support
    */	        

    private String label;
    /**
    Filter queries to exclude when calculating statistics
    */	        

    private List<String> excludeFilters;	    

    public String getField()
    {
        return this.field;
    }

    public void setField(String field)
    {
        this.field = field;
    }				

    public String getStart()
    {
        return this.start;
    }

    public void setStart(String start)
    {
        this.start = start;
    }				

    public String getEnd()
    {
        return this.end;
    }

    public void setEnd(String end)
    {
        this.end = end;
    }				

    public String getGap()
    {
        return this.gap;
    }

    public void setGap(String gap)
    {
        this.gap = gap;
    }				

    public boolean getHardend()
    {
        return this.hardend;
    }

    public void setHardend(boolean hardend)
    {
        this.hardend = hardend;
    }				

    public List<String> getOther()
    {
        return this.other;
    }

    public void setOther(List<String> other)
    {
        this.other = other;
    }				

    public List<String> getInclude()
    {
        return this.include;
    }

    public void setInclude(List<String> include)
    {
        this.include = include;
    }

    public String getLabel()
    {
        return label;
    }

    public void setLabel(String label)
    {
        this.label = label;
    }

    public List<String> getExcludeFilters()
    {
        return this.excludeFilters;
    }

    public void setExcludeFilters(List<String> excludeFilters)
    {
        this.excludeFilters = excludeFilters;
    }				
}
 
