/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.sites.membershipRequests;

import org.alfresco.dataprep.SiteService;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestSiteMembershipRequestModelsCollection;
import org.alfresco.rest.model.RestTaskModel;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DeleteSiteMembershipRequestTests
extends RestTest {
    UserModel siteCreator;
    UserModel adminUserModel;
    UserModel secondSiteCreator;
    UserModel siteMember;
    SiteModel moderatedSite;
    SiteModel secondModeratedSite;
    SiteModel publicSite;
    private DataUser.ListUserWithRoles usersWithRoles;
    RestSiteMembershipRequestModelsCollection siteMembershipRequests;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUserModel = this.dataUser.getAdminUser();
        this.siteCreator = this.dataUser.createRandomTestUser();
        this.secondSiteCreator = this.dataUser.createRandomTestUser();
        String siteId = RandomData.getRandomName((String)"site");
        this.moderatedSite = ((DataSite)this.dataSite.usingUser(this.siteCreator)).createSite(new SiteModel(SiteService.Visibility.MODERATED, siteId, siteId, siteId, siteId));
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.moderatedSite, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        this.dataUser.addUserToSite(this.adminUserModel, this.moderatedSite, UserRole.SiteManager);
        this.secondModeratedSite = ((DataSite)this.dataSite.usingUser(this.secondSiteCreator)).createModeratedRandomSite();
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.siteCreator)).createPublicRandomSite();
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify one user is able to delete his one site memebership request")
    public void userCanDeleteHisOwnSiteMembershipRequest() throws Exception {
        this.restClient.authenticateUser(this.secondSiteCreator).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withCoreAPI().usingUser(this.secondSiteCreator).deleteSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to delete site membership request")
    public void managerCanDeleteSiteMembershipRequest() throws Exception {
        this.siteMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(this.siteMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingUser(this.siteMember).deleteSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingUser(this.siteMember).getSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsErrorKey(RestErrorModel.RELATIONSHIP_NOT_FOUND_ERRORKEY).containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.siteMember.getUsername(), this.moderatedSite.getTitle())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user is able to delete site memebership request")
    public void adminUserCanDeleteSiteMembershipRequest() throws Exception {
        this.siteMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(this.siteMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.siteMember).deleteSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @Bug(id="REPO-1946")
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator user is not able to delete site memebership request")
    public void collaboratorCannotDeleteSiteMembershipRequest() throws Exception {
        this.siteMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(this.siteMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingUser(this.siteMember).deleteSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @Bug(id="REPO-1946")
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor user is not able to delete site memebership request")
    public void contributorCannotDeleteSiteMembershipRequest() throws Exception {
        this.siteMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(this.siteMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingUser(this.siteMember).deleteSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @Bug(id="REPO-1946")
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify consumer user is not able to delete site memebership request")
    public void consumerCannotDeleteSiteMembershipRequest() throws Exception {
        this.siteMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(this.siteMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingUser(this.siteMember).deleteSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @Bug(id="REPO-1946")
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify random user is not able to delete site memebership request")
    public void randomUserCanNotDeleteSiteMembershipRequest() throws Exception {
        this.siteMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(this.siteMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.authenticateUser(this.dataUser.createRandomTestUser()).withCoreAPI().usingUser(this.siteMember).deleteSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.SANITY}, description="Failed authentication get site member call returns status code 401")
    public void unauthenticatedUserIsNotAuthorizedToDeleteSiteMmebershipRequest() throws Exception {
        this.restClient.authenticateUser(this.dataUser.createRandomTestUser()).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        UserModel inexistentUser = new UserModel("inexistent user", "inexistent password");
        this.restClient.authenticateUser(inexistentUser).withCoreAPI().usingAuthUser().deleteSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user is able to remove his own site memebership request using '-me-' in place of personId and response is successful (204)")
    @Test(groups={"rest-api", "people", "regression"})
    public void userCanDeleteHisOwnSiteMembershipRequestUsingMeAsPersonId() throws Exception {
        this.restClient.authenticateUser(this.secondSiteCreator).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.withCoreAPI().usingMe().deleteSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to remove a site memebership request of an inexistent user and response is 404")
    @Test(groups={"rest-api", "people", "regression"})
    public void adminIsNotAbleToDeleteSiteMembershipRequestOfAnInexistentUser() throws Exception {
        UserModel inexistentUser = new UserModel("inexistenUser", "password");
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(inexistentUser).deleteSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, inexistentUser.getUsername()));
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to remove a site memebership request to an inexistent site and response is 404")
    @Test(groups={"rest-api", "people", "regression"})
    public void adminIsNotAbleToDeleteSiteMembershipRequestToAnInexistentSite() throws Exception {
        SiteModel inexistentSite = new SiteModel("inexistentSite");
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.adminUserModel).deleteSiteMembershipRequest(inexistentSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.adminUserModel.getUsername(), inexistentSite.getId()));
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to remove a site memebership request to an empty site id and response is 405")
    @Test(groups={"rest-api", "people", "regression"})
    public void adminIsNotAbleToDeleteSiteMembershipRequestWithEmptySiteId() throws Exception {
        SiteModel inexistentSite = new SiteModel("");
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.adminUserModel).deleteSiteMembershipRequest(inexistentSite);
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsSummary(RestErrorModel.DELETE_EMPTY_ARGUMENT);
    }

    @Bug(id="REPO-1946")
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor user is not able to remove a site memebership request of admin to a moderated site and response is 404")
    @Test(groups={"rest-api", "people", "regression"})
    public void contributorIsNotAbleToDeleteSiteMembershipRequestOfAdminToAModeratedSite() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingUser(this.adminUserModel).deleteSiteMembershipRequest(this.secondModeratedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify manager is able to remove a site memebership request of admin to a moderated site and response is 204")
    @Test(groups={"rest-api", "people", "regression"})
    public void managerUserIsAbleToDeleteSiteMembershipRequestOfAdminToAModeratedSite() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.secondModeratedSite);
        this.restClient.authenticateUser(this.secondSiteCreator).withCoreAPI().usingUser(this.adminUserModel).deleteSiteMembershipRequest(this.secondModeratedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify manager is not able to remove a site memebership request if it was already approved and response is 404")
    @Test(groups={"rest-api", "people", "regression"})
    public void managerUserIsNotAbleToDeleteASiteMembershipRequestIfItWasAlreadyApproved() throws Exception {
        this.siteMember.setUserRole(UserRole.SiteCollaborator);
        this.restClient.authenticateUser(this.siteMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.secondModeratedSite);
        RestTaskModel taskModel = this.restClient.authenticateUser(this.siteMember).withWorkflowAPI().getTasks().getTaskModelByDescription(this.secondModeratedSite);
        this.workflow.approveSiteMembershipRequest(this.secondSiteCreator.getUsername(), this.secondSiteCreator.getPassword(), taskModel.getId(), true, "Approve");
        this.restClient.authenticateUser(this.secondSiteCreator).withCoreAPI().usingUser(this.siteMember).deleteSiteMembershipRequest(this.secondModeratedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.siteMember.getUsername(), this.secondModeratedSite.getId()));
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify manager is not able to remove an inexitent site memebership request and response is 404")
    @Test(groups={"rest-api", "people", "regression"})
    public void managerUserIsNotAbleToDeleteAnInexistentSiteMembershipRequest() throws Exception {
        this.restClient.authenticateUser(this.secondSiteCreator).withCoreAPI().usingUser(this.adminUserModel).deleteSiteMembershipRequest(this.secondModeratedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.adminUserModel.getUsername(), this.secondModeratedSite.getId()));
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator user is not able to remove a site memebership request of admin to a public site and response is 404")
    @Test(groups={"rest-api", "people", "regression"})
    public void collaboratorIsNotAbleToDeleteSiteMembershipRequestOfAdminToAPublicSite() throws Exception {
        UserModel userCollaborator = this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator);
        this.restClient.authenticateUser(this.siteMember).withCoreAPI().usingSite(this.publicSite).addPerson(userCollaborator);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.publicSite);
        this.restClient.authenticateUser(userCollaborator).withCoreAPI().usingUser(this.adminUserModel).deleteSiteMembershipRequest(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsErrorKey(RestErrorModel.RELATIONSHIP_NOT_FOUND_ERRORKEY).containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.adminUserModel.getUsername(), this.publicSite.getId())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Delete a rejected site membership request.")
    public void deleteARejectedSiteMembershipRequest() throws Exception {
        UserModel userWithRejectedRequests = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(userWithRejectedRequests).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.secondModeratedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestTaskModel taskModel = this.restClient.authenticateUser(userWithRejectedRequests).withWorkflowAPI().getTasks().getTaskModelByDescription(this.secondModeratedSite);
        this.workflow.approveSiteMembershipRequest(this.secondSiteCreator.getUsername(), this.secondSiteCreator.getPassword(), taskModel.getId(), false, "Rejected");
        this.siteMembershipRequests = this.restClient.authenticateUser(userWithRejectedRequests).withCoreAPI().usingMe().getSiteMembershipRequests();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.siteMembershipRequests.assertThat().entriesListDoesNotContain("id", this.secondModeratedSite.getId());
        this.restClient.authenticateUser(this.secondSiteCreator).withCoreAPI().usingUser(userWithRejectedRequests).deleteSiteMembershipRequest(this.secondModeratedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsErrorKey(RestErrorModel.RELATIONSHIP_NOT_FOUND_ERRORKEY).containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, userWithRejectedRequests.getUsername(), this.secondModeratedSite.getId())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Bug(id="ACE-2413")
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to remove a site memebership request-  empty person id and response is 400")
    @Test(groups={"rest-api", "people", "regression"})
    public void adminIsNotAbleToDeleteSiteMembershipRequestEmptyPersonID() throws Exception {
        UserModel emptyPersonId = new UserModel("", "password");
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(emptyPersonId).deleteSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(RestErrorModel.API_DEFAULT_ERRORKEY).containsSummary(RestErrorModel.ENTITY_NOT_FOUND).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify manager removes/cancel twice same site memebership request and response is 404")
    @Test(groups={"rest-api", "people", "regression"})
    public void managerCancelsTwiceSiteMembershipRequestModeratedSite() throws Exception {
        this.siteMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(this.siteMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingUser(this.siteMember).deleteSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingUser(this.siteMember).deleteSiteMembershipRequest(this.moderatedSite);
        this.restClient.withCoreAPI().usingUser(this.siteMember).getSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsErrorKey(RestErrorModel.RELATIONSHIP_NOT_FOUND_ERRORKEY).containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.siteMember.getUsername(), this.moderatedSite.getTitle())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }
}

