/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes.variables;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.rest.model.RestProcessVariableCollection;
import org.alfresco.rest.model.RestProcessVariableModel;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AddProcessVariablesSanityTests
extends RestTest {
    private FileModel document;
    private SiteModel siteModel;
    private UserModel userWhoStartsProcess;
    private UserModel assignee;
    private UserModel adminUser;
    private RestProcessModel processModel;
    private RestProcessVariableModel variableModel;
    private RestProcessVariableModel variableModel1;
    private RestProcessVariableModel variableModel2;
    private RestProcessVariableModel processVariable;
    private RestProcessVariableCollection processVariableCollection;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userWhoStartsProcess = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userWhoStartsProcess)).createPublicRandomSite();
        this.document = ((DataContent)this.dataContent.usingUser(this.userWhoStartsProcess).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsProcess)).usingSite(this.siteModel)).usingResource((ContentModel)this.document)).createNewTaskAndAssignTo(this.assignee);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.SANITY}, description="Create non-existing variable")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void addProcessVariable() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.processVariable = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestProcessVariableModel)((RestProcessVariableModel)this.processVariable.assertThat().field("name").is((Object)this.variableModel.getName())).and().field("type").is((Object)this.variableModel.getType())).and().field("value").is((Object)this.variableModel.getValue());
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessVariables().assertThat().entriesListContains("name", this.variableModel.getName());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.SANITY}, description="Create non-existing variable")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void addMultipleProcessVariable() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.variableModel1 = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.variableModel2 = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.processVariableCollection = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessVariables(new RestProcessVariableModel[]{this.variableModel, this.variableModel1, this.variableModel2});
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestProcessVariableModel)((RestProcessVariableModel)((RestProcessVariableModel)this.processVariableCollection.getEntries().get(0)).onModel().assertThat().field("name").is((Object)this.variableModel.getName())).and().field("type").is((Object)this.variableModel.getType())).and().field("value").is((Object)this.variableModel.getValue());
        ((RestProcessVariableModel)((RestProcessVariableModel)((RestProcessVariableModel)this.processVariableCollection.getEntries().get(1)).onModel().assertThat().field("name").is((Object)this.variableModel1.getName())).and().field("type").is((Object)this.variableModel1.getType())).and().field("value").is((Object)this.variableModel1.getValue());
        ((RestProcessVariableModel)((RestProcessVariableModel)((RestProcessVariableModel)this.processVariableCollection.getEntries().get(2)).onModel().assertThat().field("name").is((Object)this.variableModel2.getName())).and().field("type").is((Object)this.variableModel2.getType())).and().field("value").is((Object)this.variableModel2.getValue());
        ((RestModels)((RestModels)this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessVariables().assertThat().entriesListContains("name", this.variableModel.getName())).assertThat().entriesListContains("name", this.variableModel1.getName())).assertThat().entriesListContains("name", this.variableModel2.getName());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.SANITY}, description="Update existing variables")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void updateExistingProcessVariable() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.processVariable = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestProcessVariableModel)((RestProcessVariableModel)this.processVariable.assertThat().field("name").is((Object)this.variableModel.getName())).and().field("type").is((Object)this.variableModel.getType())).and().field("value").is((Object)this.variableModel.getValue());
        String newValue = RandomData.getRandomName((String)"value");
        this.variableModel.setValue(newValue);
        this.processVariable = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.processVariable.assertThat().field("value").is((Object)newValue);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.SANITY}, description="Update existing variables")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void updateExistingMultipleProcessVariable() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.variableModel1 = RestProcessVariableModel.getRandomProcessVariableModel((String)"d:text");
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.processVariableCollection = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessVariables(new RestProcessVariableModel[]{this.variableModel, this.variableModel1});
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestProcessVariableModel)((RestProcessVariableModel)((RestProcessVariableModel)this.processVariableCollection.getEntries().get(0)).onModel().assertThat().field("name").is((Object)this.variableModel.getName())).and().field("type").is((Object)this.variableModel.getType())).and().field("value").is((Object)this.variableModel.getValue());
        ((RestProcessVariableModel)((RestProcessVariableModel)((RestProcessVariableModel)this.processVariableCollection.getEntries().get(1)).onModel().assertThat().field("name").is((Object)this.variableModel1.getName())).and().field("type").is((Object)this.variableModel1.getType())).and().field("value").is((Object)this.variableModel1.getValue());
        String newValueVar = RandomData.getRandomName((String)"valueVar");
        this.variableModel.setValue(newValueVar);
        String newValueVar1 = RandomData.getRandomName((String)"valueVar1");
        this.variableModel1.setValue(newValueVar1);
        this.processVariableCollection = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessVariables(new RestProcessVariableModel[]{this.variableModel, this.variableModel1});
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestProcessVariableModel)this.processVariableCollection.getEntries().get(0)).onModel().assertThat().field("value").is((Object)newValueVar);
        ((RestProcessVariableModel)this.processVariableCollection.getEntries().get(1)).onModel().assertThat().field("value").is((Object)newValueVar1);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.SANITY}, description="Adding process variables is falling in case invalid variableBody is provided")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void failedAddingProcessVariableIfInvalidBodyIsProvided() throws Exception {
        this.variableModel = RestProcessVariableModel.getRandomProcessVariableModel((String)"incorrect type");
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).addProcessVariable(this.variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Unsupported type of variable: 'incorrect type'.");
    }
}

