/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processDefinitions;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestProcessDefinitionModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetProcessDefinitionSanityTests
extends RestTest {
    private UserModel testUser;
    private RestProcessDefinitionModel randomProcessDefinition;
    private RestProcessDefinitionModel firstRandomProcessDefinition;
    private RestProcessDefinitionModel returnedProcessDefinition;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.testUser = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(this.dataUser.getAdminUser());
        this.randomProcessDefinition = ((RestProcessDefinitionModel)this.restClient.withWorkflowAPI().getAllProcessDefinitions().getOneRandomEntry()).onModel();
        this.firstRandomProcessDefinition = this.restClient.withWorkflowAPI().getAllProcessDefinitions().getProcessDefinitionByDeploymentId("1");
    }

    @TestRail(section={"rest-api", "workflow", "process-definitions"}, executionType={ExecutionType.SANITY}, description="Verify Admin user gets a specific process definition for non-network deployments using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "process-definitions", "sanity"})
    public void adminGetsProcessDefinition() throws Exception {
        this.returnedProcessDefinition = this.restClient.withWorkflowAPI().usingProcessDefinitions(this.randomProcessDefinition).getProcessDefinition();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.returnedProcessDefinition.assertThat().field("name").is((Object)this.randomProcessDefinition.getName());
    }

    @TestRail(section={"rest-api", "workflow", "process-definitions"}, executionType={ExecutionType.SANITY}, description="Verify Any user gets a specific process definition for non-network deployments using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "process-definitions", "sanity"})
    public void anyUserGetsProcessDefinition() throws Exception {
        this.restClient.authenticateUser(this.testUser);
        this.returnedProcessDefinition = this.restClient.withWorkflowAPI().usingProcessDefinitions(this.firstRandomProcessDefinition).getProcessDefinition();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestProcessDefinitionModel)((RestProcessDefinitionModel)((RestProcessDefinitionModel)((RestProcessDefinitionModel)((RestProcessDefinitionModel)((RestProcessDefinitionModel)((RestProcessDefinitionModel)((RestProcessDefinitionModel)((RestProcessDefinitionModel)this.returnedProcessDefinition.assertThat().field("name").is((Object)this.firstRandomProcessDefinition.getName())).and().field("deploymentId").is((Object)this.firstRandomProcessDefinition.getDeploymentId())).and().field("description").is((Object)this.firstRandomProcessDefinition.getDescription())).and().field("id").is((Object)this.firstRandomProcessDefinition.getId())).and().field("startFormResourceKey").is((Object)this.firstRandomProcessDefinition.getStartFormResourceKey())).and().field("category").is((Object)this.firstRandomProcessDefinition.getCategory())).and().field("title").is((Object)this.firstRandomProcessDefinition.getTitle())).and().field("version").is((Object)this.firstRandomProcessDefinition.getVersion())).and().field("graphicNotationDefined").is((Object)this.firstRandomProcessDefinition.getGraphicNotationDefined())).and().field("key").is((Object)this.firstRandomProcessDefinition.getKey());
    }
}

