/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.requests;

import io.restassured.http.ContentType;
import jakarta.json.JsonArrayBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Stream;
import org.alfresco.rest.core.JsonBodyGenerator;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestResponse;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestActionDefinitionModelsCollection;
import org.alfresco.rest.model.RestCategoryLinkBodyModel;
import org.alfresco.rest.model.RestCategoryModel;
import org.alfresco.rest.model.RestCategoryModelsCollection;
import org.alfresco.rest.model.RestCommentModel;
import org.alfresco.rest.model.RestCommentModelsCollection;
import org.alfresco.rest.model.RestNodeAssocTargetModel;
import org.alfresco.rest.model.RestNodeAssociationModel;
import org.alfresco.rest.model.RestNodeAssociationModelCollection;
import org.alfresco.rest.model.RestNodeAssociationTypeModel;
import org.alfresco.rest.model.RestNodeBodyModel;
import org.alfresco.rest.model.RestNodeBodyMoveCopyModel;
import org.alfresco.rest.model.RestNodeChildAssocModelCollection;
import org.alfresco.rest.model.RestNodeChildAssociationModel;
import org.alfresco.rest.model.RestNodeModel;
import org.alfresco.rest.model.RestNodeModelsCollection;
import org.alfresco.rest.model.RestRatingModel;
import org.alfresco.rest.model.RestRatingModelsCollection;
import org.alfresco.rest.model.RestRenditionInfoModel;
import org.alfresco.rest.model.RestRenditionInfoModelCollection;
import org.alfresco.rest.model.RestRuleExecutionModel;
import org.alfresco.rest.model.RestRuleSetLinkModel;
import org.alfresco.rest.model.RestRuleSetModel;
import org.alfresco.rest.model.RestRuleSetModelsCollection;
import org.alfresco.rest.model.RestSizeDetailsModel;
import org.alfresco.rest.model.RestTagModel;
import org.alfresco.rest.model.RestTagModelsCollection;
import org.alfresco.rest.model.RestVersionModel;
import org.alfresco.rest.model.RestVersionModelsCollection;
import org.alfresco.rest.model.body.RestNodeLockBodyModel;
import org.alfresco.rest.model.builder.NodesBuilder;
import org.alfresco.rest.requests.ContentStorageInformation;
import org.alfresco.rest.requests.FolderRules;
import org.alfresco.rest.requests.ModelRequest;
import org.alfresco.rest.requests.RuleSettings;
import org.alfresco.utility.Utility;
import org.alfresco.utility.model.RepoTestModel;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.reporters.Files;

public class Node
extends ModelRequest<Node> {
    private static final String RULE_SETS_URI = "nodes/{nodeId}/rule-sets";
    private static final String RULE_SET_BY_ID = "nodes/{nodeId}/rule-sets/{ruleSetId}";
    private RepoTestModel repoModel;

    public Node(RestWrapper restWrapper) {
        super(restWrapper);
    }

    public Node(RepoTestModel repoModel, RestWrapper restWrapper) {
        super(restWrapper);
        this.repoModel = repoModel;
        Utility.checkObjectIsInitialized((Object)this.repoModel.getNodeRef(), (String)"repoModel.getNodeRef()");
    }

    public RestNodeModel getNode() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "nodes/{nodeId}?{parameters}", this.repoModel.getNodeRef(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestNodeModel.class, request);
    }

    public RestCommentModelsCollection getNodeComments() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "nodes/{nodeId}/comments?{parameters}", this.repoModel.getNodeRef(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestCommentModelsCollection.class, request);
    }

    public RestCommentModel addComment(String commentContent) {
        String postBody = JsonBodyGenerator.keyValueJson("content", commentContent);
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, "nodes/{nodeId}/comments", this.repoModel.getNodeRef());
        return this.restWrapper.processModel(RestCommentModel.class, request);
    }

    public RestCommentModelsCollection addComments(String ... comments) {
        JsonArrayBuilder array = JsonBodyGenerator.defineJSONArray();
        for (String comment : comments) {
            array.add(JsonBodyGenerator.defineJSON().add("content", comment));
        }
        String postBody = array.build().toString();
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, "nodes/{nodeId}/comments", this.repoModel.getNodeRef());
        return this.restWrapper.processModels(RestCommentModelsCollection.class, request);
    }

    public RestCommentModel updateComment(RestCommentModel commentModel, String commentContent) {
        String postBody = JsonBodyGenerator.keyValueJson("content", commentContent);
        RestRequest request = RestRequest.requestWithBody(HttpMethod.PUT, postBody, "nodes/{nodeId}/comments/{commentId}?{parameters}", this.repoModel.getNodeRef(), commentModel.getId(), this.restWrapper.getParameters());
        request.setContentType("UTF-8");
        RestCommentModel response = this.restWrapper.processModel(RestCommentModel.class, request);
        return response;
    }

    public void deleteComment(RestCommentModel comment) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "nodes/{nodeId}/comments/{commentId}", this.repoModel.getNodeRef(), comment.getId());
        this.restWrapper.processEmptyModel(request);
    }

    public RestRatingModel likeDocument() {
        String postBody = JsonBodyGenerator.likeRating(true);
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, "nodes/{nodeId}/ratings", this.repoModel.getNodeRef());
        return this.restWrapper.processModel(RestRatingModel.class, request);
    }

    public RestRatingModel dislikeDocument() {
        String postBody = JsonBodyGenerator.likeRating(false);
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, "nodes/{nodeId}/ratings", this.repoModel.getNodeRef());
        return this.restWrapper.processModel(RestRatingModel.class, request);
    }

    public RestRatingModel addInvalidRating(String jsonBody) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, jsonBody, "nodes/{nodeId}/ratings", this.repoModel.getNodeRef());
        return this.restWrapper.processModel(RestRatingModel.class, request);
    }

    public RestRatingModel rateStarsToDocument(int stars) {
        String postBody = JsonBodyGenerator.fiveStarRating(stars);
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, "nodes/{nodeId}/ratings", this.repoModel.getNodeRef());
        return this.restWrapper.processModel(RestRatingModel.class, request);
    }

    public RestRatingModelsCollection getRatings() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "nodes/{nodeId}/ratings?{parameters}", this.repoModel.getNodeRef(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestRatingModelsCollection.class, request);
    }

    public void deleteLikeRating() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "nodes/{nodeId}/ratings/{ratingId}", this.repoModel.getNodeRef(), "likes");
        this.restWrapper.processEmptyModel(request);
    }

    public void deleteInvalidRating(String rating) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "nodes/{nodeId}/ratings/{ratingId}", this.repoModel.getNodeRef(), rating);
        this.restWrapper.processEmptyModel(request);
    }

    public RestRatingModel getLikeRating() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "nodes/{nodeId}/ratings/{ratingId}?{parameters}", this.repoModel.getNodeRef(), "likes", this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestRatingModel.class, request);
    }

    public void deleteFiveStarRating() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "nodes/{nodeId}/ratings/{ratingId}", this.repoModel.getNodeRef(), "fiveStar");
        this.restWrapper.processEmptyModel(request);
    }

    public RestRatingModel getFiveStarRating() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "nodes/{nodeId}/ratings/{ratingId}?{parameters}", this.repoModel.getNodeRef(), "fiveStar", this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestRatingModel.class, request);
    }

    public RestTagModel addTag(String tag) {
        String postBody = JsonBodyGenerator.keyValueJson("tag", tag);
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, "nodes/{nodeId}/tags", this.repoModel.getNodeRef());
        return this.restWrapper.processModel(RestTagModel.class, request);
    }

    public RestTagModelsCollection addTags(String ... tags) {
        Object postBody = "[";
        for (String tag : tags) {
            postBody = (String)postBody + JsonBodyGenerator.keyValueJson("tag", tag) + ",";
        }
        postBody = ((String)postBody).substring(0, ((String)postBody).length() - 1) + "]";
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, (String)postBody, "nodes/{nodeId}/tags", this.repoModel.getNodeRef());
        return this.restWrapper.processModels(RestTagModelsCollection.class, request);
    }

    public void deleteTag(RestTagModel tag) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "nodes/{nodeId}/tags/{tagId}", this.repoModel.getNodeRef(), tag.getId());
        this.restWrapper.processEmptyModel(request);
    }

    public RestTagModelsCollection getNodeTags() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "nodes/{nodeId}/tags?{parameters}", this.repoModel.getNodeRef(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestTagModelsCollection.class, request);
    }

    public RestNodeModel createNode(RestNodeBodyModel node) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, node.toJson(), "nodes/{nodeId}/children?{parameters}", this.repoModel.getNodeRef(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestNodeModel.class, request);
    }

    public RestNodeModel createNode() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.POST, "nodes/{nodeId}/children", this.repoModel.getNodeRef());
        return this.restWrapper.processModel(RestNodeModel.class, request);
    }

    public RestResponse getNodeContent() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "nodes/{nodeId}/content?{parameters}", this.repoModel.getNodeRef(), this.restWrapper.getParameters());
        return this.restWrapper.process(request);
    }

    public RestResponse getNodeContent(String nodeId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "nodes/{nodeId}/content?{parameters}", nodeId, this.restWrapper.getParameters());
        return this.restWrapper.process(request);
    }

    public void createNodeRendition(String renditionId) {
        String postBody = JsonBodyGenerator.keyValueJson("id", renditionId);
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, "nodes/{nodeId}/renditions", this.repoModel.getNodeRef());
        this.restWrapper.processEmptyModel(request);
    }

    public void createNodeVersionRendition(String renditionId, String versionId) {
        String postBody = JsonBodyGenerator.keyValueJson("id", renditionId);
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, "nodes/{nodeId}/versions/{versionId}/renditions", this.repoModel.getNodeRef(), versionId);
        this.restWrapper.processEmptyModel(request);
    }

    public void createNodeRenditionIfNotExists(String renditionId) {
        this.getNodeRendition(renditionId);
        if (Integer.valueOf(this.restWrapper.getStatusCode()).equals(HttpStatus.OK.value())) {
            String postBody = JsonBodyGenerator.keyValueJson("id", renditionId);
            RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, "nodes/{nodeId}/renditions", this.repoModel.getNodeRef());
            this.restWrapper.processEmptyModel(request);
        }
    }

    public RestRenditionInfoModel getNodeRendition(String renditionId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "nodes/{nodeId}/renditions/{renditionId}", this.repoModel.getNodeRef(), renditionId);
        return this.restWrapper.processModel(RestRenditionInfoModel.class, request);
    }

    public RestRenditionInfoModel getNodeVersionRendition(String renditionId, String versionId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "nodes/{nodeId}/versions/{versionId}/renditions/{renditionId}", this.repoModel.getNodeRef(), versionId, renditionId);
        return this.restWrapper.processModel(RestRenditionInfoModel.class, request);
    }

    public RestRenditionInfoModel getNodeRenditionUntilIsCreated(String renditionId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "nodes/{nodeId}/renditions/{renditionId}", this.repoModel.getNodeRef(), renditionId);
        RestRenditionInfoModel renditions = this.restWrapper.processModel(RestRenditionInfoModel.class, request);
        if (Integer.valueOf(this.restWrapper.getStatusCode()).equals(HttpStatus.OK.value())) {
            for (int retry = 0; renditions.getStatus().equals("NOT_CREATED") && retry < Utility.retryCountSeconds - 8; ++retry) {
                Utility.waitToLoopTime((int)1, (String[])new String[0]);
                renditions = this.restWrapper.processModel(RestRenditionInfoModel.class, request);
            }
        }
        return renditions;
    }

    public RestRenditionInfoModel getNodeVersionRenditionUntilIsCreated(String renditionId, String versionId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "nodes/{nodeId}/versions/{versionId}/renditions/{renditionId}", this.repoModel.getNodeRef(), versionId, renditionId);
        RestRenditionInfoModel renditions = this.restWrapper.processModel(RestRenditionInfoModel.class, request);
        if (Integer.valueOf(this.restWrapper.getStatusCode()).equals(HttpStatus.OK.value())) {
            for (int retry = 0; renditions.getStatus().equals("NOT_CREATED") && retry < Utility.retryCountSeconds - 8; ++retry) {
                Utility.waitToLoopTime((int)1, (String[])new String[0]);
                renditions = this.restWrapper.processModel(RestRenditionInfoModel.class, request);
            }
        }
        return renditions;
    }

    public RestResponse getNodeRenditionContentUntilIsCreated(String renditionId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "nodes/{nodeId}/renditions/{renditionId}/content", this.repoModel.getNodeRef(), renditionId);
        RestResponse response = this.restWrapper.process(request);
        for (int retry = 0; !Integer.valueOf(response.getStatusCode()).equals(HttpStatus.OK.value()) && retry < 8 * Utility.retryCountSeconds; ++retry) {
            Utility.waitToLoopTime((int)1, (String[])new String[0]);
            response = this.restWrapper.process(request);
        }
        return response;
    }

    public RestResponse getNodeVersionRenditionContentUntilIsCreated(String renditionId, String versionId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "nodes/{nodeId}/versions/{versionId}/renditions/{renditionId}/content", this.repoModel.getNodeRef(), versionId, renditionId);
        RestResponse response = this.restWrapper.process(request);
        for (int retry = 0; Integer.valueOf(response.getStatusCode()).equals(HttpStatus.NOT_FOUND.value()) && retry < Utility.retryCountSeconds; ++retry) {
            Utility.waitToLoopTime((int)1, (String[])new String[0]);
            response = this.restWrapper.process(request);
        }
        return response;
    }

    public RestResponse getNodeRenditionContent(String renditionId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "nodes/{nodeId}/renditions/{renditionId}/content", this.repoModel.getNodeRef(), renditionId);
        return this.restWrapper.process(request);
    }

    public RestResponse getNodeVersionRenditionContent(String renditionId, String versionId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "nodes/{nodeId}/versions/{versionId}/renditions/{renditionId}/content", this.repoModel.getNodeRef(), versionId, renditionId);
        return this.restWrapper.process(request);
    }

    public RestRenditionInfoModelCollection getNodeRenditionsInfo() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "nodes/{nodeId}/renditions?{parameters}", this.repoModel.getNodeRef(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestRenditionInfoModelCollection.class, request);
    }

    public RestRenditionInfoModelCollection getNodeVersionRenditionsInfo(String versionId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "nodes/{nodeId}/versions/{versionId}/renditions?{parameters}", this.repoModel.getNodeRef(), versionId, this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestRenditionInfoModelCollection.class, request);
    }

    public void deleteNodeRendition(String renditionId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "nodes/{nodeId}/renditions/{renditionId}", this.repoModel.getNodeRef(), renditionId);
        this.restWrapper.processEmptyModel(request);
    }

    public RestNodeModelsCollection listChildren() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "nodes/{nodeId}/children?{parameters}", this.repoModel.getNodeRef(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestNodeModelsCollection.class, request);
    }

    public RestNodeModel move(RestNodeBodyMoveCopyModel moveBody) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, moveBody.toJson(), "nodes/{nodeId}/move?{parameters}", this.repoModel.getNodeRef(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestNodeModel.class, request);
    }

    public RestNodeModel copy(RestNodeBodyMoveCopyModel copyBody) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, copyBody.toJson(), "nodes/{nodeId}/copy?{parameters}", this.repoModel.getNodeRef(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestNodeModel.class, request);
    }

    public RestNodeModel lockNode(RestNodeLockBodyModel lockBody) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, lockBody.toJson(), "nodes/{nodeId}/lock?{parameters}", this.repoModel.getNodeRef(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestNodeModel.class, request);
    }

    public RestNodeModel unlockNode() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.POST, "nodes/{nodeId}/unlock?{parameters}", this.repoModel.getNodeRef(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestNodeModel.class, request);
    }

    public NodesBuilder defineNodes() {
        return new NodesBuilder(this.restWrapper, this.repoModel);
    }

    public RestNodeModel updateNode(String putBody) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.PUT, putBody, "nodes/{nodeId}?{parameters}", this.repoModel.getNodeRef(), this.restWrapper.getParameters());
        request.setContentType("UTF-8");
        return this.restWrapper.processModel(RestNodeModel.class, request);
    }

    public RestNodeAssociationModelCollection getNodeTargets() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "nodes/{nodeId}/targets?{parameters}", this.repoModel.getNodeRef(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestNodeAssociationModelCollection.class, request);
    }

    public RestNodeAssocTargetModel createTargetForNode(RestNodeAssocTargetModel target) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, target.toJson(), "nodes/{nodeId}/targets?{parameters}", this.repoModel.getNodeRef(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestNodeAssocTargetModel.class, request);
    }

    public void deleteTarget(RestNodeAssocTargetModel target) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "nodes/{nodeId}/targets/{targetId}", this.repoModel.getNodeRef(), target.getTargetId());
        this.restWrapper.processEmptyModel(request);
    }

    public RestNodeAssociationModelCollection getNodeSources() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "/nodes/{nodeId}/sources?{parameters}", this.repoModel.getNodeRef(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestNodeAssociationModelCollection.class, request);
    }

    public RestNodeModel updateNodeContent(File nodeContent) {
        try {
            this.restWrapper.usingContentType(ContentType.BINARY);
            String body = Files.readFile((InputStream)new FileInputStream(nodeContent));
            RestRequest request = RestRequest.requestWithBody(HttpMethod.PUT, body, "nodes/{nodeId}/content?{parameters}", this.repoModel.getNodeRef(), this.restWrapper.getParameters());
            request.setContentType("UTF-8");
            this.restWrapper.usingContentType(ContentType.JSON);
            return this.restWrapper.processModel(RestNodeModel.class, request);
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected error when reading content file.", e);
        }
    }

    public RestNodeModel copyNode(String postBody) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, "nodes/{nodeId}/copy?{parameters}", this.repoModel.getNodeRef(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestNodeModel.class, request);
    }

    public RestNodeAssociationModelCollection getParents() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "nodes/{nodeId}/parents?{parameters}", this.repoModel.getNodeRef(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestNodeAssociationModelCollection.class, request);
    }

    public RestNodeAssociationModelCollection getSecondaryChildren() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "nodes/{nodeId}/secondary-children?{parameters}", this.repoModel.getNodeRef(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestNodeAssociationModelCollection.class, request);
    }

    public RestNodeChildAssociationModel addSecondaryChild(RepoTestModel secondaryChild) {
        return this.addSecondaryChild("cm:contains", secondaryChild);
    }

    public RestNodeChildAssociationModel addSecondaryChild(String associationType, RepoTestModel secondaryChild) {
        return this.addSecondaryChild(new RestNodeChildAssociationModel(secondaryChild.getNodeRef(), associationType));
    }

    public RestNodeChildAssociationModel addSecondaryChild(RestNodeChildAssociationModel secondaryChildAssociation) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, secondaryChildAssociation.toJson(), "nodes/{nodeId}/secondary-children?{parameters}", this.repoModel.getNodeRef(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestNodeChildAssociationModel.class, request);
    }

    public RestNodeChildAssocModelCollection addSecondaryChildren(RepoTestModel ... secondaryChildren) {
        return this.addSecondaryChildren("cm:contains", secondaryChildren);
    }

    public RestNodeChildAssocModelCollection addSecondaryChildren(String associationType, RepoTestModel ... secondaryChildren) {
        return this.addSecondaryChildren((RestNodeChildAssociationModel[])Stream.of(secondaryChildren).map(child -> new RestNodeChildAssociationModel(child.getNodeRef(), associationType)).toArray(RestNodeChildAssociationModel[]::new));
    }

    public RestNodeChildAssocModelCollection addSecondaryChildren(RestNodeChildAssociationModel ... secondaryChildrenAssociations) {
        String requestBody = JsonBodyGenerator.arrayToJson(Stream.of(secondaryChildrenAssociations).toList());
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, requestBody, "nodes/{nodeId}/secondary-children?{parameters}", this.repoModel.getNodeRef(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestNodeChildAssocModelCollection.class, request);
    }

    public void removeSecondaryChild(RepoTestModel secondaryChild) {
        this.removeSecondaryChild(null, secondaryChild);
    }

    public void removeSecondaryChild(String associationType, RepoTestModel secondaryChild) {
        RestNodeAssociationModel associationModel = new RestNodeAssociationModel();
        RestNodeAssociationTypeModel associationTypeModel = new RestNodeAssociationTypeModel();
        if (associationType != null) {
            associationTypeModel.setAssocType(associationType);
        }
        associationModel.setAssociation(associationTypeModel);
        associationModel.setId(secondaryChild.getNodeRef());
        this.removeSecondaryChild(associationModel);
    }

    public void removeSecondaryChild(RestNodeAssociationModel secondaryChildAssociation) {
        String parameters = StringUtils.isNotEmpty((CharSequence)secondaryChildAssociation.getAssociation().getAssocType()) ? "assocType=" + secondaryChildAssociation.getAssociation().getAssocType() + "&" + this.restWrapper.getParameters() : this.restWrapper.getParameters();
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "nodes/{nodeId}/secondary-children/{childId}?{parameters}", this.repoModel.getNodeRef(), secondaryChildAssociation.getId(), parameters);
        this.restWrapper.processEmptyModel(request);
    }

    public RestVersionModelsCollection listVersionHistory() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "nodes/{nodeId}/versions?{parameters}", this.repoModel.getNodeRef(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestVersionModelsCollection.class, request);
    }

    public void deleteNodeVersion(String versionId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "nodes/{nodeId}/versions/{versionId}", this.repoModel.getNodeRef(), versionId);
        this.restWrapper.processEmptyModel(request);
    }

    public RestVersionModel getVersionInformation(String versionId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "nodes/{nodeId}/versions/{versionId}", this.repoModel.getNodeRef(), versionId);
        return this.restWrapper.processModel(RestVersionModel.class, request);
    }

    public RestResponse getVersionContent(String versionId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "nodes/{nodeId}/versions/{versionId}/content?{parameters}", this.repoModel.getNodeRef(), versionId, this.restWrapper.getParameters());
        return this.restWrapper.process(request);
    }

    public RestVersionModel revertVersion(String versionId, String postBody) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, "nodes/{nodeId}/versions/{versionId}/revert?{parameters}", this.repoModel.getNodeRef(), versionId, this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestVersionModel.class, request);
    }

    public void deleteNode(RestNodeModel nodeModel) {
        this.deleteNode(nodeModel.getId());
    }

    public void deleteNode(String nodeId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "nodes/{nodeId}", nodeId);
        this.restWrapper.processEmptyModel(request);
    }

    public RestActionDefinitionModelsCollection getActionDefinitions() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "nodes/{nodeId}/action-definitions?{parameters}", this.repoModel.getNodeRef(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestActionDefinitionModelsCollection.class, request);
    }

    public RestResponse createDirectAccessURL(String postBody) {
        RestRequest request = postBody == null ? RestRequest.simpleRequest(HttpMethod.POST, "nodes/{nodeId}/request-direct-access-url", this.repoModel.getNodeRef()) : RestRequest.requestWithBody(HttpMethod.POST, postBody, "nodes/{nodeId}/request-direct-access-url", this.repoModel.getNodeRef());
        return this.restWrapper.process(request);
    }

    public RestResponse createDirectAccessURLforRendition(String renditionId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.POST, "nodes/{nodeId}/renditions/{renditionId}/request-direct-access-url", this.repoModel.getNodeRef(), renditionId);
        return this.restWrapper.process(request);
    }

    public RestResponse createDirectAccessURLforVersion(String versionId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.POST, "nodes/{nodeId}/versions/{versionId}/request-direct-access-url", this.repoModel.getNodeRef(), versionId);
        return this.restWrapper.process(request);
    }

    public RestResponse createDirectAccessURLforVersionAndRendition(String versionId, String renditionId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.POST, "nodes/{nodeId}/versions/{versionId}/renditions/{renditionId}/request-direct-access-url", this.repoModel.getNodeRef(), versionId, renditionId);
        return this.restWrapper.process(request);
    }

    public ContentStorageInformation usingStorageInfo(String contentPropName) {
        return new ContentStorageInformation(this.restWrapper).withNodeId(this.repoModel.getNodeRef()).withContentPropName(contentPropName);
    }

    public ContentStorageInformation usingVersionStorageInfo(String contentPropName, String versionId) {
        return new ContentStorageInformation(this.restWrapper).withNodeId(this.repoModel.getNodeRef()).withContentPropName(contentPropName).withVersionId(versionId);
    }

    public FolderRules usingDefaultRuleSet() {
        return this.usingRuleSet("-default-");
    }

    public FolderRules usingRuleSet(String ruleSetId) {
        return new FolderRules(this.restWrapper).withNodeId(this.repoModel.getNodeRef()).withRuleSetId(ruleSetId);
    }

    public RestRuleSetModelsCollection getListOfRuleSets() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, RULE_SETS_URI, this.repoModel.getNodeRef());
        return this.restWrapper.processModels(RestRuleSetModelsCollection.class, request);
    }

    public RestRuleSetModel getRuleSet(String ruleSetId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, RULE_SET_BY_ID, this.repoModel.getNodeRef(), ruleSetId);
        return this.restWrapper.processModel(RestRuleSetModel.class, request);
    }

    public RestRuleSetModel updateRuleSet(RestRuleSetModel ruleSet) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.PUT, ruleSet.toJson(), RULE_SET_BY_ID, this.repoModel.getNodeRef(), ruleSet.getId());
        return this.restWrapper.processModel(RestRuleSetModel.class, request);
    }

    public RestRuleSetModel getDefaultRuleSet() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, RULE_SET_BY_ID, this.repoModel.getNodeRef(), "-default-");
        return this.restWrapper.processModel(RestRuleSetModel.class, request);
    }

    public RuleSettings usingRuleSetting(String ruleSettingKey) {
        return new RuleSettings(this.restWrapper).withNodeId(this.repoModel.getNodeRef()).withRuleSettingKey(ruleSettingKey);
    }

    public RuleSettings usingIsInheritanceEnabledRuleSetting() {
        return this.usingRuleSetting("-isInheritanceEnabled-");
    }

    public RestRuleSetLinkModel createRuleLink(RestRuleSetLinkModel body) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, body.toJson(), "nodes/{nodeId}/rule-set-links", this.repoModel.getNodeRef());
        return this.restWrapper.processModel(RestRuleSetLinkModel.class, request);
    }

    public void unlinkRuleSet(String ruleSetId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "nodes/{nodeId}/rule-set-links/{ruleSetId}", this.repoModel.getNodeRef(), ruleSetId);
        this.restWrapper.processEmptyModel(request);
    }

    public RestRuleExecutionModel executeRules(RestRuleExecutionModel body) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, body.toJson(), "nodes/{nodeId}/rule-executions", this.repoModel.getNodeRef());
        return this.restWrapper.processModel(RestRuleExecutionModel.class, request);
    }

    public RestCategoryModelsCollection getLinkedCategories() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "nodes/{nodeId}/category-links", this.repoModel.getNodeRef());
        return this.restWrapper.processModels(RestCategoryModelsCollection.class, request);
    }

    public RestCategoryModel linkToCategory(RestCategoryLinkBodyModel categoryLink) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, categoryLink.toJson(), "nodes/{nodeId}/category-links", this.repoModel.getNodeRef());
        return this.restWrapper.processModel(RestCategoryModel.class, request);
    }

    public RestCategoryModelsCollection linkToCategories(List<RestCategoryLinkBodyModel> categoryLinks) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, JsonBodyGenerator.arrayToJson(categoryLinks), "nodes/{nodeId}/category-links", this.repoModel.getNodeRef());
        return this.restWrapper.processModels(RestCategoryModelsCollection.class, request);
    }

    public void unlinkFromCategory(String categoryId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "nodes/{nodeId}/category-links/{categoryId}", this.repoModel.getNodeRef(), categoryId);
        this.restWrapper.processEmptyModel(request);
    }

    public RestSizeDetailsModel executeSizeDetails() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.POST, "nodes/{nodeId}/size-details", this.repoModel.getNodeRef());
        return this.restWrapper.processModel(RestSizeDetailsModel.class, request);
    }

    public RestSizeDetailsModel getSizeDetails(String jobId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "nodes/{nodeId}/size-details/{jobId}", this.repoModel.getNodeRef(), jobId);
        return this.restWrapper.processModel(RestSizeDetailsModel.class, request);
    }
}

