/*-
 * #%L
 * alfresco-tas-restapi
 * %%
 * Copyright (C) 2005 - 2022 Alfresco Software Limited
 * %%
 * This file is part of the Alfresco software. 
 * If the software was purchased under a paid Alfresco license, the terms of 
 * the paid license agreement will prevail.  Otherwise, the software is 
 * provided under the following open source license terms:
 * 
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
/*
 * Copyright 2021 Alfresco Software, Ltd. All rights reserved.
 * License rights for this program may be obtained from Alfresco Software, Ltd.
 * pursuant to a written agreement and any use of this program without such an
 * agreement is prohibited.
 */
package org.alfresco.rest.model;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;

import org.alfresco.rest.core.IRestModel;
import org.alfresco.utility.model.TestModel;

/**
 * Generated by 'dedwards' on '2021-12-16 08:32' from 'Alfresco Content Services REST API' swagger file 
 * Generated from 'Alfresco Content Services REST API' swagger file
 * Base Path {@linkplain /alfresco/api/-default-/public/alfresco/versions/1}
 */
public class RestContentStorageInfoModel extends TestModel implements IRestModel<RestContentStorageInfoModel>
{
    @JsonProperty(value = "entry")
    RestContentStorageInfoModel model;

    @Override
    public RestContentStorageInfoModel onModel()
    {
        return model;
    }

    /**
    Content type property identifier (e.g. cm:content). Inside this object only colon (':') delimiter for namespace-prefix will be used.

    */	        

    @JsonProperty(required = true)    
    private String id;	    
    /**
    A map (String-String) of storage properties for given content.

    */	        

    private Map<String, String> storageProperties;	    

    public String getId()
    {
        return this.id;
    }

    public void setId(String id)
    {
        this.id = id;
    }				

    public Map<String, String> getStorageProperties()
    {
        return this.storageProperties;
    }

    public void setStorageProperties(Map<String, String> storageProperties)
    {
        this.storageProperties = storageProperties;
    }				
}
 
