/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.people;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestSiteEntry;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetSiteMembershipCoreTests
extends RestTest {
    UserModel regularUser;
    UserModel publicSiteManager;
    UserModel privateSiteManager;
    UserModel moderatedSiteManager;
    UserModel adminUser;
    SiteModel publicSite;
    SiteModel privateSite;
    SiteModel moderatedSite;
    private DataUser.ListUserWithRoles publicSiteUsers;
    private RestSiteEntry restSiteEntry;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.regularUser = this.dataUser.createRandomTestUser();
        this.privateSiteManager = this.dataUser.createRandomTestUser();
        this.moderatedSiteManager = this.dataUser.createRandomTestUser();
        this.publicSite = ((DataSite)this.dataSite.usingAdmin()).createPublicRandomSite();
        this.privateSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        this.moderatedSite = ((DataSite)this.dataSite.usingAdmin()).createModeratedRandomSite();
        this.publicSiteUsers = this.dataUser.addUsersWithRolesToSite(this.publicSite, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        this.publicSiteManager = this.publicSiteUsers.getOneUserWithRole(UserRole.SiteManager);
        ((DataUser)this.dataUser.usingAdmin()).addUserToSite(this.privateSiteManager, this.privateSite, UserRole.SiteManager);
        ((DataUser)this.dataUser.usingAdmin()).addUserToSite(this.moderatedSiteManager, this.moderatedSite, UserRole.SiteManager);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify get site membership for a site returns status 404 when personId does not exist.")
    public void getSiteMembershipUsingNonExistentPersonId() throws Exception {
        UserModel someUser = new UserModel("someUser", DataUser.PASSWORD);
        this.restClient.authenticateUser(this.regularUser).withCoreAPI().usingUser(someUser).getSiteMembership(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "someUser"));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify get site membership for a site returns status 404 when siteId does not exist.")
    public void getSiteMembershipUsingNonExistentSiteId() throws Exception {
        SiteModel someSite = new SiteModel("someSite");
        this.restClient.authenticateUser(this.regularUser).withCoreAPI().usingAuthUser().getSiteMembership(someSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.regularUser.getUsername(), "someSite"));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify get site membership for a site returns status 404 when personId is not a site member.")
    public void getSiteMembershipForPersonThatIsNotSiteMember() throws Exception {
        this.restClient.authenticateUser(this.publicSiteManager).withCoreAPI().usingUser(this.regularUser).getSiteMembership(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.regularUser.getUsername(), this.publicSite.getTitle()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify regular user is not able to retrieve site membership information of a private site member.")
    public void regularUserIsNotAbleToRetrieveSiteMembershipForPrivateSiteManager() throws Exception {
        this.restClient.authenticateUser(this.regularUser).withCoreAPI().usingUser(this.privateSiteManager).getSiteMembership(this.privateSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.privateSiteManager.getUsername(), this.privateSite.getTitle()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify regular user is able to retrieve site membership information of a moderated site member.")
    public void regularUserGetsSiteMembershipForModeratedSiteMember() throws Exception {
        this.restSiteEntry = this.restClient.authenticateUser(this.regularUser).withCoreAPI().usingUser(this.moderatedSiteManager).getSiteMembership(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteEntry)((RestSiteEntry)this.restSiteEntry.assertThat().field("role").is((Object)UserRole.SiteManager)).and().field("id").is((Object)this.moderatedSite.getId())).and().field("site").isNotEmpty();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify if Admin user is able to retrieve site membership information of him.")
    public void adminGetsSiteMembershipForHim() throws Exception {
        this.restSiteEntry = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingUser(this.adminUser).getSiteMembership(this.privateSite);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteEntry)((RestSiteEntry)this.restSiteEntry.assertThat().field("role").is((Object)UserRole.SiteManager)).and().field("id").is((Object)this.privateSite.getId())).and().field("site").isNotEmpty();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify if Admin user is able to retrieve site membership information of him.")
    public void getSiteMembershipAfterRemovingASiteMember() throws Exception {
        UserModel publicSiteConsumer = this.publicSiteUsers.getOneUserWithRole(UserRole.SiteConsumer);
        this.restClient.authenticateUser(this.publicSiteManager).withCoreAPI().usingSite(this.publicSite).deleteSiteMember(publicSiteConsumer);
        this.restClient.authenticateUser(this.publicSiteManager).withCoreAPI().usingUser(publicSiteConsumer).getSiteMembership(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, publicSiteConsumer.getUsername(), this.publicSite.getTitle()));
    }
}

