/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.comments;

import java.util.List;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.JsonBodyGenerator;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.exception.JsonToModelConversionException;
import org.alfresco.rest.model.RestCommentModel;
import org.alfresco.rest.model.RestCommentModelsCollection;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataLink;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.LinkModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddCommentsTests
extends RestTest {
    private UserModel adminUserModel;
    private UserModel networkUserModel;
    private FileModel document;
    private SiteModel siteModel;
    private DataUser.ListUserWithRoles usersWithRoles;
    private RestCommentModelsCollection comments;
    private String comment1;
    private String comment2;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUserModel = this.dataUser.getAdminUser();
        this.networkUserModel = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(this.adminUserModel);
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createPublicRandomSite();
        this.document = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.siteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
    }

    @BeforeMethod(alwaysRun=true)
    public void generateRandomComments() {
        this.comment1 = RandomData.getRandomName((String)"comment1");
        this.comment2 = RandomData.getRandomName((String)"comment2");
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.SANITY}, description="Verify admin user adds multiple comments with Rest API and status code is 201")
    @Test(groups={"rest-api", "comments", "sanity"})
    public void adminIsAbleToAddComments() throws JsonToModelConversionException, Exception {
        ((RestModels)((RestModels)this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)this.document).addComments(new String[]{this.comment1, this.comment2}).assertThat().entriesListIsNotEmpty()).and().entriesListContains("content", this.comment1)).and().entriesListContains("content", this.comment2);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.SANITY}, description="Verify unauthenticated user gets status code 401 on post multiple comments call")
    @Test(groups={"rest-api", "comments", "sanity"})
    public void unauthenticatedUserIsNotAbleToAddComments() throws JsonToModelConversionException, Exception {
        this.restClient.noAuthentication().withCoreAPI().usingResource((RepoTestModel)this.document).addComments(new String[]{this.comment1, this.comment2});
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Manager user adds multiple comments with Rest API and status code is 201")
    @Test(groups={"rest-api", "comments", "regression"})
    public void managerIsAbleToAddComments() throws JsonToModelConversionException, Exception {
        ((RestModels)((RestModels)this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)this.document).addComments(new String[]{this.comment1, this.comment2}).assertThat().entriesListIsNotEmpty()).and().entriesListContains("content", this.comment1)).and().entriesListContains("content", this.comment2);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Contributor user adds multiple comments with Rest API and status code is 201")
    @Test(groups={"rest-api", "comments", "regression"})
    public void contributorIsAbleToAddComments() throws JsonToModelConversionException, Exception {
        ((RestModels)((RestModels)this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingResource((RepoTestModel)this.document).addComments(new String[]{this.comment1, this.comment2}).assertThat().entriesListIsNotEmpty()).and().entriesListContains("content", this.comment1)).and().entriesListContains("content", this.comment2);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator user adds multiple comments with Rest API and status code is 201")
    @Test(groups={"rest-api", "comments", "regression"})
    public void collaboratorIsAbleToAddComments() throws JsonToModelConversionException, Exception {
        ((RestModels)((RestModels)((RestModels)this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingResource((RepoTestModel)this.document).addComments(new String[]{this.comment1, this.comment2}).assertThat().paginationExist()).and().entriesListIsNotEmpty()).and().entriesListContains("content", this.comment1)).and().entriesListContains("content", this.comment2);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Consumer user adds multiple comments with Rest API and status code is 201")
    @Test(groups={"rest-api", "comments", "regression"})
    public void consumerIsAbleToAddComments() throws JsonToModelConversionException, Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingResource((RepoTestModel)this.document).addComments(new String[]{this.comment1, this.comment2});
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify User can not add comments to a not joined private site. Status code returned is 403")
    @Test(groups={"rest-api", "comments", "regression"})
    public void userCanNotAddCommentsToANotJoinedPrivateSite() throws Exception {
        SiteModel sitePrivateNotJoined = this.dataSite.createPrivateRandomSite();
        FileModel file = ((DataContent)this.dataContent.usingSite(sitePrivateNotJoined)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)file).addComments(new String[]{this.comment1, this.comment2});
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify User can't add comments to a node with ID that does not exist and status code is 404")
    @Test(groups={"rest-api", "comments", "regression"})
    public void userCanNotAddCommentsOnNonexistentFile() throws Exception {
        FileModel nonexistentFile = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        nonexistentFile.setNodeRef("ABC");
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)nonexistentFile).addComments(new String[]{this.comment1, this.comment2});
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, nonexistentFile.getNodeRef()));
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify User can't add comments to a node that exists but is not a document or a folder and status code is 405")
    @Test(groups={"rest-api", "comments", "regression"})
    @Bug(id="MNT-16904")
    public void userCanNotAddCommentsOnLink() throws Exception {
        LinkModel link = ((DataLink)((DataLink)this.dataLink.usingAdmin()).usingSite(this.siteModel)).createRandomLink();
        FileModel fileWithNodeRefFromLink = FileModel.getRandomFileModel((FileType)FileType.TEXT_PLAIN);
        fileWithNodeRefFromLink.setNodeRef(link.getNodeRef());
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)fileWithNodeRefFromLink).addComments(new String[]{this.comment1, this.comment2});
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.UNABLE_TO_LOCATE);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify User can add comments with the same content as one existing comment")
    @Test(groups={"rest-api", "comments", "regression"})
    public void userCanAddCommentWithTheSameContentAsExistingOne() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        String sameComment = this.comment1;
        ((RestModels)((RestModels)((RestModels)this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)file).addComments(new String[]{this.comment1, sameComment}).assertThat().paginationExist()).and().entriesListIsNotEmpty()).and().entriesListContains("content", this.comment1)).and().entriesListContains("content", sameComment);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.comments = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)file).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.comments.assertThat().entriesListIsNotEmpty();
        List commentsList = this.comments.getEntries();
        ((RestCommentModel)commentsList.get(0)).onModel().assertThat().field("content").is((Object)this.comment1);
        ((RestCommentModel)commentsList.get(1)).onModel().assertThat().field("content").is((Object)sameComment);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify add comments from node with invalid network id returns status code 401")
    @Test(groups={"rest-api", "comments", "regression"})
    public void addCommentsWithInvalidNetworkId() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.networkUserModel.setDomain("invalidNetwork");
        this.restClient.authenticateUser(this.networkUserModel).withCoreAPI().usingResource((RepoTestModel)file).addComments(new String[]{this.comment1, this.comment2});
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify add comments from node with empty network id returns status code 401")
    @Test(groups={"rest-api", "comments", "regression"})
    public void addCommentsWithEmptyNetworkId() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.networkUserModel.setDomain("");
        this.restClient.authenticateUser(this.networkUserModel).withCoreAPI().usingResource((RepoTestModel)file).addComments(new String[]{this.comment1, this.comment2});
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify that comments cannot be added to another comment")
    @Test(groups={"rest-api", "comments", "regression"})
    public void addCommentsToAComment() throws JsonToModelConversionException, Exception {
        FileModel file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        RestCommentModel commentEntry = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).addComment(this.comment1);
        file.setNodeRef(commentEntry.getId());
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).addComments(new String[]{this.comment1, this.comment2});
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsSummary(RestErrorModel.CANNOT_COMMENT);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Using Manager user verify that you can provide a large string for one comment")
    @Test(groups={"rest-api", "comments", "regression"})
    public void addLongCommentsWithManagerAndCheckThatCommentIsReturned() throws Exception {
        this.document = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        String longString = RandomStringUtils.randomAlphanumeric((int)10000);
        String longString1 = RandomStringUtils.randomAlphanumeric((int)90000);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)this.document).addComments(new String[]{longString, longString1});
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.comments = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)this.document).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.comments.assertThat().entriesListContains("content", longString);
        this.comments.assertThat().entriesListContains("content", longString1);
        this.comments.assertThat().paginationField("totalItems").is("2");
        this.comments.assertThat().paginationField("count").is("2");
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Using Manager user verify that you can provide a short string for one comment")
    @Test(groups={"rest-api", "comments", "regression"})
    public void addShortCommentsWithManagerAndCheckThatCommentIsReturned() throws Exception {
        this.document = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        String shortString = RandomStringUtils.randomAlphanumeric((int)2);
        String shortString1 = RandomStringUtils.randomAlphanumeric((int)1);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)this.document).addComments(new String[]{shortString, shortString1});
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.comments = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)this.document).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.comments.assertThat().entriesListContains("content", shortString);
        this.comments.assertThat().entriesListContains("content", shortString1);
        this.comments.assertThat().paginationField("totalItems").is("2");
        this.comments.assertThat().paginationField("count").is("2");
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Using Collaborator user verify that you can provide a string with special characters for one comment")
    @Test(groups={"rest-api", "comments", "regression"})
    public void addCommentsWithSpecialCharsWithCollaboratorCheckCommentIsReturned() throws Exception {
        this.document = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        String specialCharsString = "!@#$%^&*()'\".,<>-_+=|\\";
        String shortString = RandomStringUtils.randomAlphanumeric((int)2);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingResource((RepoTestModel)this.document).addComments(new String[]{specialCharsString, shortString});
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.comments = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)this.document).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.comments.assertThat().entriesListContains("content", specialCharsString);
        this.comments.assertThat().entriesListContains("content", shortString);
        this.comments.assertThat().paginationField("totalItems").is("2");
        this.comments.assertThat().paginationField("count").is("2");
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Using Manager user verify that you can not provide an empty string for one comment")
    @Test(groups={"rest-api", "comments", "regression"})
    public void addEmptyStringCommentsWithManagerCheckCommentIsReturned() throws Exception {
        this.document = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        String emptyString = "";
        String spaceString = " ";
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)this.document).addComments(new String[]{emptyString, spaceString});
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.NON_NULL_COMMENT);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Using Collaborator user verify that you can provide several comments in one request")
    @Test(groups={"rest-api", "comments", "regression"})
    public void addSeveralCommentsWithCollaboratorCheckCommentsAreReturned() throws Exception {
        this.document = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        String charString = RandomStringUtils.randomAlphanumeric((int)10);
        String charString1 = RandomStringUtils.randomAlphanumeric((int)10);
        String charString2 = RandomStringUtils.randomAlphanumeric((int)10);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingResource((RepoTestModel)this.document).addComments(new String[]{this.comment1, this.comment2, charString, charString1, charString2});
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.comments = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)this.document).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.comments.assertThat().entriesListContains("content", this.comment1);
        this.comments.assertThat().paginationField("totalItems").is("5");
        this.comments.assertThat().paginationField("count").is("5");
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Provide invalid request body parameter and check default error model schema")
    @Test(groups={"rest-api", "comments", "regression"})
    public void invalidRequestBodyParameterCheckErrorModelSchema() throws Exception {
        this.document = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI();
        String postBody = JsonBodyGenerator.keyValueJson((String)"content2", (String)this.comment1);
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)postBody, (String)"nodes/{nodeId}/comments", (String[])new String[]{this.document.getNodeRef()});
        this.restClient.processModel(RestCommentModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsErrorKey(String.format(RestErrorModel.UNRECOGNIZED_FIELD, "content2"));
        this.restClient.assertLastError().containsSummary(String.format(RestErrorModel.UNRECOGNIZED_FIELD, "content2"));
        this.restClient.assertLastError().descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
        this.restClient.assertLastError().stackTraceIs(RestErrorModel.STACKTRACE);
    }
}

