/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.repo.resource.content;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.alfresco.rest.repo.resource.content.RepoFolderCreator;
import org.alfresco.rest.repo.resource.general.Creator;
import org.alfresco.rest.repo.resource.general.MultiCreator;
import org.alfresco.rest.repo.resource.general.MultipleContentsCreator;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.model.FolderModel;

public class SerialFoldersCreator
extends MultipleContentsCreator<FolderModel, MultiCreator.FoldersCreator>
implements MultiCreator.FoldersCreator {
    private final DataContent dataContent;
    private final Map<String, FolderModel> foldersCache;

    public SerialFoldersCreator(DataContent dataContent, Map<String, FolderModel> foldersCache) {
        this.dataContent = dataContent;
        this.foldersCache = foldersCache;
    }

    @Override
    protected SerialFoldersCreator self() {
        return this;
    }

    @Override
    public List<FolderModel> create() {
        this.verifyDataConsistency();
        return this.createRawFoldersUnder(this.parent, this.names);
    }

    @Override
    protected String generateRandomName() {
        return this.generateRandomNameWith("");
    }

    @Override
    protected String generateRandomNameWith(String prefix) {
        return super.generateRandomNameWith("folder" + prefix + "_");
    }

    protected FolderModel createFolder(String folderName, String title, String description, FolderModel parent, String alias) {
        return (FolderModel)((Creator.FolderCreator)((Creator.FolderCreator)((Creator.FolderCreator)((Creator.FolderCreator)((Creator.FolderCreator)((Creator.FolderCreator)((Creator.FolderCreator)new RepoFolderCreator(this.dataContent, this.foldersCache).withAlias(alias)).withName(folderName)).withTitle(title)).withDescription(description)).underFolder(parent)).withinSite(this.site)).asUser(this.user)).create();
    }

    private List<FolderModel> createRawFoldersUnder(FolderModel parent, List<String> folderNames) {
        ArrayList<FolderModel> createdFolders = new ArrayList<FolderModel>();
        AtomicInteger i = new AtomicInteger();
        folderNames.forEach(folderName -> {
            FolderModel createdFolder = this.createFolder((String)folderName, (String)this.getOrNull(this.titles, i.get()), (String)this.getOrNull(this.descriptions, i.get()), parent, (String)this.getOrNull(this.aliases, i.get()));
            createdFolders.add(createdFolder);
            i.getAndIncrement();
        });
        return createdFolders;
    }
}

