/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.requests;

import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import org.alfresco.rest.core.JsonBodyGenerator;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestCandidateModelsCollection;
import org.alfresco.rest.model.RestFormModelsCollection;
import org.alfresco.rest.model.RestItemModel;
import org.alfresco.rest.model.RestItemModelsCollection;
import org.alfresco.rest.model.RestTaskModel;
import org.alfresco.rest.model.RestTaskModelsCollection;
import org.alfresco.rest.model.RestVariableModel;
import org.alfresco.rest.model.RestVariableModelsCollection;
import org.alfresco.rest.requests.ModelRequest;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.TaskModel;
import org.springframework.http.HttpMethod;

public class Task
extends ModelRequest<Task> {
    private TaskModel task;

    public Task(RestWrapper restWrapper) {
        super(restWrapper);
    }

    public Task(RestWrapper restWrapper, TaskModel task) {
        super(restWrapper);
        this.task = task;
    }

    public RestTaskModelsCollection getTasks() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "tasks?{parameters}", this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestTaskModelsCollection.class, request);
    }

    public RestTaskModel getTask() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "tasks/{taskId}?{parameters}", this.task.getId(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestTaskModel.class, request);
    }

    public RestTaskModel updateTask(String newStateValue) {
        return this.updateTask(JsonBodyGenerator.defineJSON().add("state", newStateValue).build());
    }

    public RestTaskModel updateTask(JsonObject inputJson) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.PUT, inputJson.toString(), "tasks/{taskId}?{parameters}", this.task.getId(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestTaskModel.class, request);
    }

    public RestVariableModelsCollection getTaskVariables() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "tasks/{taskId}/variables?{parameters}", this.task.getId(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestVariableModelsCollection.class, request);
    }

    public RestVariableModel updateTaskVariable(RestVariableModel variableModel) {
        String postBody = JsonBodyGenerator.taskVariable(variableModel);
        RestRequest request = RestRequest.requestWithBody(HttpMethod.PUT, postBody, "tasks/{taskId}/variables/{variableName}", this.task.getId(), variableModel.getName());
        return this.restWrapper.processModel(RestVariableModel.class, request);
    }

    public RestVariableModel addTaskVariable(RestVariableModel variableModel) {
        String postBody = JsonBodyGenerator.taskVariable(variableModel);
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, "tasks/{taskId}/variables", this.task.getId());
        return this.restWrapper.processModel(RestVariableModel.class, request);
    }

    public RestVariableModelsCollection addTaskVariables(RestVariableModel ... taskVariablesModel) {
        JsonArrayBuilder array = JsonBodyGenerator.defineJSONArray();
        for (RestVariableModel taskVariableModel : taskVariablesModel) {
            array.add(JsonBodyGenerator.defineJSON().add("scope", taskVariableModel.getScope()).add("name", taskVariableModel.getName()).add("type", taskVariableModel.getType()).add("value", taskVariableModel.getValue().toString()));
        }
        String postBody = array.build().toString();
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, "tasks/{taskId}/variables", this.task.getId());
        return this.restWrapper.processModels(RestVariableModelsCollection.class, request);
    }

    public void deleteTaskVariable(RestVariableModel variableModel) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "tasks/{taskId}/variables/{variableName} ", this.task.getId(), variableModel.getName());
        this.restWrapper.processEmptyModel(request);
    }

    public RestItemModel addTaskItem(FileModel fileModel) {
        String postBody = JsonBodyGenerator.keyValueJson("id", fileModel.getNodeRef().split(";")[0]);
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, "tasks/{taskId}/items", this.task.getId());
        return this.restWrapper.processModel(RestItemModel.class, request);
    }

    public RestItemModelsCollection addTaskItems(FileModel ... fileModels) {
        JsonArrayBuilder array = JsonBodyGenerator.defineJSONArray();
        for (FileModel fileModel : fileModels) {
            array.add(JsonBodyGenerator.defineJSON().add("id", fileModel.getNodeRef().split(";")[0]));
        }
        String postBody = array.build().toString();
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, "tasks/{taskId}/items", this.task.getId());
        return this.restWrapper.processModels(RestItemModelsCollection.class, request);
    }

    public RestItemModelsCollection getTaskItems() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "tasks/{taskId}/items?{parameters}", this.task.getId(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestItemModelsCollection.class, request);
    }

    public RestFormModelsCollection getTaskFormModel() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "tasks/{taskId}/task-form-model?{parameters}", this.task.getId(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestFormModelsCollection.class, request);
    }

    public void deleteTaskItem(RestItemModel itemModel) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "tasks/{taskId}/items/{itemId}", this.task.getId(), itemModel.getId());
        this.restWrapper.processEmptyModel(request);
    }

    public RestCandidateModelsCollection getTaskCandidates() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "tasks/{taskId}/candidates?{parameters}", this.task.getId(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestCandidateModelsCollection.class, request);
    }
}

