/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rules;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestRuleModel;
import org.alfresco.rest.model.RestRuleModelsCollection;
import org.alfresco.rest.model.RestRuleSetLinkModel;
import org.alfresco.rest.model.RestRuleSetModel;
import org.alfresco.rest.model.RestRuleSetModelsCollection;
import org.alfresco.rest.model.RestRuleSettingsModel;
import org.alfresco.rest.requests.Node;
import org.alfresco.rest.rules.RulesRestTest;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"rules"})
public class GetInheritedRulesTests
extends RulesRestTest {
    private UserModel user;
    private SiteModel site;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() {
        Step.STEP((String)"Create a user and site");
        this.user = this.dataUser.createRandomTestUser();
        this.site = ((DataSite)this.dataSite.usingUser(this.user)).createPublicRandomSite();
    }

    @Test(groups={"rest-api", "rules", "sanity"})
    public void getInheritedRules() {
        Step.STEP((String)"Create a parent and child folder, each with inheriting rules");
        FolderModel parent = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        FolderModel child = ((DataContent)this.dataContent.usingUser(this.user).usingResource((ContentModel)parent)).createFolder();
        RestRuleModel parentRule = this.rulesUtils.createInheritableRuleModel();
        parentRule = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)parent).usingDefaultRuleSet().createSingleRule(parentRule);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestRuleSettingsModel enabled = new RestRuleSettingsModel();
        enabled.setValue((Object)true);
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)child).usingRuleSetting("-isInheritanceEnabled-").updateSetting(enabled);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        RestRuleModel childRule = this.rulesUtils.createRuleModelWithDefaultValues();
        childRule = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)child).usingDefaultRuleSet().createSingleRule(childRule);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"Get the rules in the default rule set for the child folder");
        RestRuleModelsCollection rules = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)child).usingDefaultRuleSet().getListOfRules();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)rules.assertThat().entriesListContains("id", childRule.getId())).and().entriesListCountIs(1);
        Step.STEP((String)"Get the rules in the inherited rule set for the child folder");
        RestRuleSetModelsCollection ruleSets = ((Node)this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)child).include(new String[]{"inclusionType"})).getListOfRuleSets();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        String inheritedRuleSetId = ruleSets.getEntries().stream().filter(ruleSet -> ruleSet.onModel().getInclusionType().equals("inherited")).findFirst().get().onModel().getId();
        RestRuleModelsCollection inheritedRules = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)child).usingRuleSet(inheritedRuleSetId).getListOfRules();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)inheritedRules.assertThat().entriesListContains("id", parentRule.getId())).and().entriesListCountIs(1);
    }

    @Test(groups={"rest-api", "rules", "sanity"})
    public void getInheritedRules_childFolderInheritanceDisabled() {
        Step.STEP((String)"Create a parent and child folder, with inheritable parent rule");
        FolderModel parent = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        FolderModel child = ((DataContent)this.dataContent.usingUser(this.user).usingResource((ContentModel)parent)).createFolder();
        RestRuleModel parentRule = this.rulesUtils.createInheritableRuleModel();
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)parent).usingDefaultRuleSet().createSingleRule(parentRule);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"Disable inheritance in the child folder");
        RestRuleSettingsModel enabledInheritance = new RestRuleSettingsModel();
        enabledInheritance.setValue((Object)false);
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)child).usingRuleSetting("-isInheritanceEnabled-").updateSetting(enabledInheritance);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"The child folder should have no rule sets");
        RestRuleSetModelsCollection ruleSets = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)child).getListOfRuleSets();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ruleSets.assertThat().entriesListIsEmpty();
    }

    @Test(groups={"rest-api", "rules", "sanity"})
    public void inheritance_test() {
        Step.STEP((String)"Create a parent and child folder, with an inheritable and a non-inheritable parent rule");
        FolderModel parent = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        FolderModel child = ((DataContent)this.dataContent.usingUser(this.user).usingResource((ContentModel)parent)).createFolder();
        RestRuleModel inheritableRule = this.rulesUtils.createInheritableRuleModel();
        inheritableRule = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)parent).usingDefaultRuleSet().createSingleRule(inheritableRule);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestRuleModel nonInheritableRule = this.rulesUtils.createRuleModelWithDefaultValues();
        nonInheritableRule = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)parent).usingDefaultRuleSet().createSingleRule(nonInheritableRule);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"The inherited rule set for the child folder should only return the inheritable rule");
        RestRuleSetModelsCollection ruleSets = ((Node)this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)child).include(new String[]{"inclusionType"})).getListOfRuleSets();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        String inheritedRuleSetId = ruleSets.getEntries().stream().filter(ruleSet -> ruleSet.onModel().getInclusionType().equals("inherited")).findFirst().get().onModel().getId();
        RestRuleModelsCollection inheritedRules = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)child).usingRuleSet(inheritedRuleSetId).getListOfRules();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)inheritedRules.assertThat().entriesListContains("id", inheritableRule.getId())).and().entriesListDoesNotContain("id", nonInheritableRule.getId())).and().entriesListCountIs(1);
    }

    @Test(groups={"rest-api", "rules", "sanity"})
    public void rulesReturnedAreUnique() {
        Step.STEP((String)"Create four folders with rules");
        FolderModel folderA = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        FolderModel folderB = ((DataContent)this.dataContent.usingUser(this.user).usingResource((ContentModel)folderA)).createFolder();
        FolderModel folderC = ((DataContent)this.dataContent.usingUser(this.user).usingResource((ContentModel)folderB)).createFolder();
        FolderModel folderD = ((DataContent)this.dataContent.usingUser(this.user).usingResource((ContentModel)folderC)).createFolder();
        RestRuleModel ruleB = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folderB).usingDefaultRuleSet().createSingleRule(this.rulesUtils.createInheritableRuleModel());
        RestRuleModel ruleC = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folderC).usingDefaultRuleSet().createSingleRule(this.rulesUtils.createInheritableRuleModel());
        RestRuleModel ruleD = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folderD).usingDefaultRuleSet().createSingleRule(this.rulesUtils.createRuleModelWithDefaultValues());
        RestRuleSettingsModel enabled = new RestRuleSettingsModel();
        enabled.setValue((Object)true);
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folderC).usingRuleSetting("-isInheritanceEnabled-").updateSetting(enabled);
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folderD).usingRuleSetting("-isInheritanceEnabled-").updateSetting(enabled);
        Step.STEP((String)"Link folderA to ruleSetD");
        RestRuleSetLinkModel linkModel = new RestRuleSetLinkModel();
        linkModel.setId(folderD.getNodeRef());
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folderA).createRuleLink(linkModel);
        Step.STEP((String)"Get the rule sets for the folderD");
        List ruleSets = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folderD).getListOfRuleSets().getEntries();
        Step.STEP((String)"Check the rules for each rule set are as expected");
        List<RestRuleModel> expectedRuleIds = List.of(ruleD, ruleB, ruleC);
        IntStream.range(0, 2).forEach(index -> {
            String ruleSetId = ((RestRuleSetModel)ruleSets.get(index)).onModel().getId();
            List rules = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)folderD).usingRuleSet(ruleSetId).getListOfRules().getEntries().stream().map(RestRuleModel::onModel).collect(Collectors.toList());
            Assert.assertEquals(rules, List.of((RestRuleModel)expectedRuleIds.get(index)), (String)("Unexpected rules found for rule set " + ruleSetId));
        });
        Assert.assertEquals((int)ruleSets.size(), (int)3, (String)("Expected three unique rule sets to be returned but got " + String.valueOf(ruleSets)));
    }
}

