/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.sites;

import java.util.List;
import org.alfresco.dataprep.SiteService;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestResponse;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestSiteContainerModelsCollection;
import org.alfresco.rest.model.RestSiteMemberModel;
import org.alfresco.rest.model.RestSiteMemberModelsCollection;
import org.alfresco.rest.model.RestSiteModel;
import org.alfresco.rest.model.RestSiteModelsCollection;
import org.alfresco.utility.constants.ContainerName;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.hamcrest.CoreMatchers;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetSiteTests
extends RestTest {
    private UserModel adminUserModel;
    private DataUser.ListUserWithRoles usersWithRoles;
    private UserModel userModel;
    private UserModel privateSiteConsumer;
    private SiteModel publicSite;
    private SiteModel privateSite;
    private SiteModel moderatedSite;
    private RestSiteModel restSiteModel;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws DataPreparationException {
        this.adminUserModel = this.dataUser.getAdminUser();
        this.restClient.authenticateUser(this.adminUserModel);
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createPublicRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.publicSite, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        this.userModel = this.dataUser.createRandomTestUser();
        this.privateSiteConsumer = this.dataUser.createRandomTestUser();
        this.privateSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        this.moderatedSite = ((DataSite)this.dataSite.usingAdmin()).createModeratedRandomSite();
        this.dataUser.addUserToSite(this.privateSiteConsumer, this.privateSite, UserRole.SiteConsumer);
    }

    @Test(groups={"rest-api", "sites", "sanity"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.SANITY}, description="Verify user with Manager role gets site information and gets status code OK (200)")
    public void getSiteWithManagerRole() throws Exception {
        ((RestSiteModel)this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingSite(this.publicSite).getSite().and().field("id").is((Object)this.publicSite.getId())).and().field("title").is((Object)this.publicSite.getTitle());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Collaborator role gets site information and gets status code OK (200)")
    public void getSiteWithCollaboratorRole() throws Exception {
        ((RestSiteModel)this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingSite(this.publicSite).getSite().and().field("id").is((Object)this.publicSite.getId())).and().field("title").is((Object)this.publicSite.getTitle());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Contributor role gets site information and gets status code OK (200)")
    public void getSiteWithContributorRole() throws Exception {
        ((RestSiteModel)this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingSite(this.publicSite).getSite().and().field("id").is((Object)this.publicSite.getId())).and().field("title").is((Object)this.publicSite.getTitle());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Consumer role gets site information and gets status code OK (200)")
    public void getSiteWithConsumerRole() throws Exception {
        ((RestSiteModel)this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingSite(this.publicSite).getSite().and().field("id").is((Object)this.publicSite.getId())).and().field("title").is((Object)this.publicSite.getTitle());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with admin role gets site information and gets status code OK (200)")
    public void getSiteWithAdminRole() throws Exception {
        ((RestSiteModel)this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.publicSite).getSite().and().field("id").is((Object)this.publicSite.getId())).and().field("title").is((Object)this.publicSite.getTitle());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "sanity"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.SANITY}, description="Failed authentication get site call returns status code 401")
    public void unauthenticatedUserIsNotAuthorizedToRetrieveSite() throws Exception {
        UserModel unauthenticatedManager = this.dataUser.createRandomTestUser();
        unauthenticatedManager.setPassword("user wrong password");
        this.dataUser.addUserToSite(unauthenticatedManager, this.publicSite, UserRole.SiteManager);
        this.restClient.authenticateUser(unauthenticatedManager).withParams(new String[]{"maxItems=10000"}).withCoreAPI().getSites();
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify invalid request returns status code 404 if siteId does not exist")
    public void checkStatusCodeForNonExistentSiteId() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite("NonExistentSiteId").getSite();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "NonExistentSiteId")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets all public and moderated sites if an empty siteId is provided")
    public void checkStatusCodeForEmptySiteId() throws Exception {
        this.restClient.authenticateUser(this.userModel).withCoreAPI();
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)"sites/{siteId}", (String[])new String[]{""});
        RestSiteModelsCollection sites = (RestSiteModelsCollection)this.restClient.processModels(RestSiteModelsCollection.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        sites.assertThat().entriesListIsNotEmpty();
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if any user gets public site details and status code is 200")
    public void getPublicSiteByNotASiteMember() throws Exception {
        this.restSiteModel = this.restClient.authenticateUser(this.userModel).withCoreAPI().usingSite(this.publicSite).getSite();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)this.restSiteModel.assertThat().field("visibility").is((Object)this.publicSite.getVisibility())).and().field("id").is((Object)this.publicSite.getId())).and().field("description").is((Object)this.publicSite.getDescription())).and().field("title").is((Object)this.publicSite.getTitle())).and().field("guid").isNotEmpty();
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if any user gets moderated site details and status code is 200")
    public void getModeratedSiteByNotASiteMember() throws Exception {
        this.restSiteModel = this.restClient.authenticateUser(this.userModel).withCoreAPI().usingSite(this.moderatedSite).getSite();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)this.restSiteModel.assertThat().field("visibility").is((Object)this.moderatedSite.getVisibility())).and().field("id").is((Object)this.moderatedSite.getId())).and().field("description").is((Object)this.moderatedSite.getDescription())).and().field("title").is((Object)this.moderatedSite.getTitle())).and().field("guid").isNotEmpty();
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if member of a private site gets that site details and status code is 200")
    public void getPrivateSiteBySiteMember() throws Exception {
        this.restSiteModel = this.restClient.authenticateUser(this.privateSiteConsumer).withCoreAPI().usingSite(this.privateSite).getSite();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)this.restSiteModel.assertThat().field("visibility").is((Object)this.privateSite.getVisibility())).and().field("id").is((Object)this.privateSite.getId())).and().field("description").is((Object)this.privateSite.getDescription())).and().field("title").is((Object)this.privateSite.getTitle())).and().field("guid").isNotEmpty();
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if user that is not member of a private site does not get that site details and status code is 200")
    public void getPrivateSiteByNotASiteMember() throws Exception {
        this.restSiteModel = this.restClient.authenticateUser(this.userModel).withCoreAPI().usingSite(this.privateSite).getSite();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.privateSite.getTitle())).containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "sites", "regression"}, expectedExceptions={AssertionError.class})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Check that properties parameter is applied (guid field is mandatory, thus assertion error is expected)")
    public void checkThatPropertiesParameterIsApplied() throws Exception {
        this.restSiteModel = this.restClient.authenticateUser(this.adminUserModel).withParams(new String[]{"properties=id, visibility"}).withCoreAPI().usingSite(this.publicSite).getSite();
        ((RestSiteModel)this.restSiteModel.assertThat().field("id").is((Object)this.publicSite.getId())).and().field("visibility").is((Object)SiteService.Visibility.PUBLIC.toString());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Check that properties parameter is applied")
    public void checkThatPropertiesParameterIsAppliedPositiveTest() throws Exception {
        this.restSiteModel = this.restClient.authenticateUser(this.adminUserModel).withParams(new String[]{"properties=id,guid,title,visibility"}).withCoreAPI().usingSite(this.publicSite).getSite();
        ((RestSiteModel)((RestSiteModel)((RestSiteModel)this.restSiteModel.assertThat().field("id").is((Object)this.publicSite.getId())).and().field("visibility").is((Object)SiteService.Visibility.PUBLIC.toString())).and().field("description").isNull()).and().field("role").isNull();
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Delete site then get site details")
    public void deleteSiteThenGetSiteDetails() throws Exception {
        SiteModel newSite = ((DataSite)this.dataSite.usingAdmin()).createPublicRandomSite();
        this.dataSite.deleteSite(newSite);
        this.restSiteModel = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(newSite).getSite();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, newSite.getId())).containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Delete site then get site details")
    public void updateSiteVisibilityToPrivateThenGetSite() throws Exception {
        SiteModel newSite = ((DataSite)this.dataSite.usingAdmin()).createPublicRandomSite();
        this.restSiteModel = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(newSite).getSite();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.dataSite.updateSiteVisibility(newSite, SiteService.Visibility.PRIVATE);
        this.restSiteModel = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(newSite).getSite();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteModel)this.restSiteModel.assertThat().field("id").is((Object)newSite.getId())).and().field("visibility").is((Object)SiteService.Visibility.PRIVATE.toString());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Check that relations parameter is applied for containers")
    public void checkThatRelationsParameterIsAppliedForContainers() throws Exception {
        List jsonObjects = this.restClient.authenticateUser(this.adminUserModel).withParams(new String[]{"relations=containers"}).withCoreAPI().usingSite(this.publicSite).getSiteWithRelations();
        RestSiteModel siteModel = (RestSiteModel)jsonObjects.get(0);
        RestSiteContainerModelsCollection containers = (RestSiteContainerModelsCollection)jsonObjects.get(1);
        ((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)siteModel.assertThat().field("visibility").is((Object)this.publicSite.getVisibility())).and().field("id").is((Object)this.publicSite.getId())).and().field("description").is((Object)this.publicSite.getDescription())).and().field("title").is((Object)this.publicSite.getTitle())).and().field("preset").is((Object)"site-dashboard")).and().field("guid").isNotEmpty();
        ((RestModels)containers.assertThat().entriesListCountIs(1)).and().entriesListContains("folderId", ContainerName.documentLibrary.toString());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Check that relations parameter is applied for members")
    public void checkThatRelationsParameterIsAppliedForMembers() throws Exception {
        SiteModel publicRandomSite = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createPublicRandomSite();
        List jsonObjects = this.restClient.authenticateUser(this.adminUserModel).withParams(new String[]{"relations=members"}).withCoreAPI().usingSite(publicRandomSite).getSiteWithRelations();
        RestSiteModel siteModel = (RestSiteModel)jsonObjects.get(0);
        RestSiteMemberModelsCollection siteMembers = (RestSiteMemberModelsCollection)jsonObjects.get(1);
        ((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)siteModel.assertThat().field("visibility").is((Object)publicRandomSite.getVisibility())).and().field("id").is((Object)publicRandomSite.getId())).and().field("description").is((Object)publicRandomSite.getDescription())).and().field("title").is((Object)publicRandomSite.getTitle())).and().field("preset").is((Object)"site-dashboard")).and().field("guid").isNotEmpty();
        ((RestModels)((RestModels)siteMembers.assertThat().entriesListCountIs(1)).assertThat().entriesListContains("id", this.adminUserModel.getUsername())).assertThat().entriesListContains("role", UserRole.SiteManager.toString());
        ((RestSiteMemberModel)((RestSiteMemberModel)siteMembers.getOneRandomEntry()).onModel().assertThat().field("person.firstName").is((Object)"Administrator")).and().field("person.id").is((Object)"admin");
    }

    @Test(groups={"demo"})
    public void checkThatRelationsParameterIsAppliedForMembersCustom() {
        this.restClient.withCoreAPI();
        RestRequest request = RestRequest.simpleRequest((HttpMethod)HttpMethod.GET, (String)"sites/{siteId}?{parameters}", (String[])new String[]{this.publicSite.getId(), "relations=members"});
        RestResponse response = this.restClient.authenticateUser(this.adminUserModel).process(request);
        response.assertThat().body("entry.id", CoreMatchers.equalTo((Object)this.publicSite.getId()), new Object[0]);
        response.assertThat().body("relations.members.list.entries.entry[0].role", CoreMatchers.equalTo((Object)"SiteManager"), new Object[0]);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Check that relations parameter is applied for containers and members")
    public void checkThatRelationsParameterIsAppliedForContainersAndMembers() throws Exception {
        SiteModel publicRandomSite = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createPublicRandomSite();
        List jsonObjects = this.restClient.authenticateUser(this.adminUserModel).withParams(new String[]{"relations=containers,members"}).withCoreAPI().usingSite(publicRandomSite).getSiteWithRelations();
        RestSiteModel siteModel = (RestSiteModel)jsonObjects.get(0);
        RestSiteContainerModelsCollection containers = (RestSiteContainerModelsCollection)jsonObjects.get(1);
        RestSiteMemberModelsCollection siteMembers = (RestSiteMemberModelsCollection)jsonObjects.get(2);
        ((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestSiteModel)siteModel.assertThat().field("visibility").is((Object)publicRandomSite.getVisibility())).and().field("id").is((Object)publicRandomSite.getId())).and().field("description").is((Object)publicRandomSite.getDescription())).and().field("title").is((Object)publicRandomSite.getTitle())).and().field("preset").is((Object)"site-dashboard")).and().field("guid").isNotEmpty();
        ((RestModels)containers.assertThat().entriesListCountIs(1)).and().entriesListContains("folderId", ContainerName.documentLibrary.toString());
        ((RestModels)((RestModels)siteMembers.assertThat().entriesListCountIs(1)).assertThat().entriesListContains("id", this.adminUserModel.getUsername())).assertThat().entriesListContains("role", UserRole.SiteManager.toString());
        ((RestSiteMemberModel)((RestSiteMemberModel)siteMembers.getOneRandomEntry()).onModel().assertThat().field("person.firstName").is((Object)"Administrator")).and().field("person.id").is((Object)"admin");
    }
}

