/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes.items;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestItemModel;
import org.alfresco.rest.model.RestItemModelsCollection;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DeleteProcessItemCoreTests
extends RestTest {
    private FileModel document;
    private FileModel secondDoc;
    private SiteModel siteModel;
    private UserModel userWhoStartsTask;
    private UserModel assignee;
    private RestProcessModel restProcessModel;
    private ProcessModel processModel;
    private RestItemModelsCollection items;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userWhoStartsTask = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userWhoStartsTask)).createPublicRandomSite();
        this.document = ((DataContent)this.dataContent.usingUser(this.userWhoStartsTask).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.processModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.document)).createSingleReviewerTaskAndAssignTo(this.assignee);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Delete process item with invalid id")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void deleteProcessItemWithInvalidItemId() throws Exception {
        this.restProcessModel = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().getProcesses().getProcessModelByProcessDefId(this.processModel.getId());
        this.secondDoc = ((DataContent)this.dataContent.usingUser(this.userWhoStartsTask).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.MSWORD);
        RestItemModel processItem = this.restClient.withWorkflowAPI().usingProcess(this.processModel).addProcessItem(this.secondDoc);
        processItem.setId("invalid-id");
        this.restClient.withWorkflowAPI().usingProcess(this.processModel).deleteProcessItem(processItem);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.PROCESS_ENTITY_NOT_FOUND, "invalid-id"));
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Delete process item with empty id")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void deleteProcessItemWithEmptyItemId() throws Exception {
        this.restProcessModel = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().getProcesses().getProcessModelByProcessDefId(this.processModel.getId());
        this.secondDoc = ((DataContent)this.dataContent.usingUser(this.userWhoStartsTask).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.MSWORD);
        RestItemModel processItem = this.restClient.withWorkflowAPI().usingProcess(this.processModel).addProcessItem(this.secondDoc);
        processItem.setId("");
        this.restClient.withWorkflowAPI().usingProcess(this.processModel).deleteProcessItem(processItem);
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsSummary(String.format(RestErrorModel.DELETE_EMPTY_ARGUMENT, new Object[0]));
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Delete process item twice")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void deleteProcessItemTwice() throws Exception {
        this.restProcessModel = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().getProcesses().getProcessModelByProcessDefId(this.processModel.getId());
        this.items = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.restProcessModel).getProcessItems();
        RestItemModel processItem = (RestItemModel)this.items.getEntries().get(0);
        this.restClient.withWorkflowAPI().usingProcess(this.processModel).deleteProcessItem(processItem.onModel());
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withWorkflowAPI().usingProcess(this.processModel).deleteProcessItem(processItem.onModel());
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.PROCESS_ENTITY_NOT_FOUND, processItem.onModel().getId()));
    }
}

