/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.repo.resource;

import java.util.Map;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.repo.resource.Files;
import org.alfresco.rest.repo.resource.ResourceManager;
import org.alfresco.rest.repo.resource.cache.MultiKeyResourceMap;
import org.alfresco.rest.repo.resource.content.RepoFolderCreator;
import org.alfresco.rest.repo.resource.content.RepoFolderModifier;
import org.alfresco.rest.repo.resource.general.Creator;
import org.alfresco.rest.repo.resource.general.Modifier;
import org.alfresco.rest.repo.resource.general.Specifier;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class Folders
implements ResourceManager<FolderModel, Specifier.FolderSpecifier, Modifier.FolderModifier> {
    public static final String FOLDER_NAME_PREFIX = "folder";
    private final DataContent dataContent;
    private final RestWrapper restClient;
    private final SiteModel site;
    private final UserModel user;
    private final Files files;
    private final Map<String, FolderModel> foldersCache = new MultiKeyResourceMap<FolderModel>(RepoTestModel::getNodeRef, ContentModel::getName);

    public Folders(DataContent dataContent, RestWrapper restClient, UserModel user, SiteModel site, Files files) {
        this.dataContent = dataContent;
        this.restClient = restClient;
        this.site = site;
        this.user = user;
        this.files = files;
    }

    public Folders(DataContent dataContent, RestWrapper restClient, UserModel user, SiteModel site) {
        this(dataContent, restClient, user, site, new Files(dataContent, restClient, user, site));
    }

    public Folders(DataContent dataContent, RestWrapper restClient, DataUser dataUser) {
        this(dataContent, restClient, dataUser.getAdminUser(), null);
    }

    @Autowired
    public Folders(DataContent dataContent, RestWrapper restClient, DataUser dataUser, DataSite dataSite) {
        this(dataContent, restClient, dataUser.getAdminUser(), ((DataSite)dataSite.usingUser(dataUser.getAdminUser())).createPrivateRandomSite());
    }

    @Override
    public Specifier.FolderSpecifier add() {
        return (Specifier.FolderSpecifier)((Creator.FolderCreator)new RepoFolderCreator(this.dataContent, this.foldersCache).withinSite(this.site)).asUser(this.user);
    }

    @Override
    public FolderModel get(String key) {
        return this.foldersCache.get(key);
    }

    @Override
    public Modifier.FolderModifier modify(FolderModel folder) {
        return (Modifier.FolderModifier)((Modifier.FolderModifier)new RepoFolderModifier(this.dataContent, this.restClient, folder, this.files, this.foldersCache).withinSite(this.site)).asUser(this.user);
    }

    @Override
    public void delete(FolderModel folder) {
        ((Modifier.FolderModifier)((Modifier.FolderModifier)new RepoFolderModifier(this.dataContent, this.restClient, folder, this.files, this.foldersCache).withinSite(this.site)).asUser(this.user)).delete();
    }
}

