/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.repo.resource.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.alfresco.utility.model.TestModel;
import org.apache.commons.lang3.StringUtils;

public class MultiKeyResourceMap<RESOURCE extends TestModel>
extends HashMap<String, RESOURCE> {
    private static final String UUID_PATTERN = "[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$";
    private final Map<String, String> keys = new HashMap<String, String>();
    private final Function<RESOURCE, String> idSupplier;
    private final Function<RESOURCE, String> nameSupplier;

    public MultiKeyResourceMap(Function<RESOURCE, String> idSupplier, Function<RESOURCE, String> nameSupplier) {
        this.idSupplier = idSupplier;
        this.nameSupplier = nameSupplier;
    }

    @Override
    public RESOURCE put(String alias, RESOURCE resource) {
        String id = this.idSupplier.apply(resource);
        String name = this.nameSupplier.apply(resource);
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new IllegalArgumentException("ID of entity with name: " + name + " and alias: " + alias + " cannot be empty!");
        }
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("Name of entity with ID: " + id + " and alias: " + alias + " cannot be empty!");
        }
        if (StringUtils.isNotEmpty((CharSequence)alias)) {
            if (this.keys.containsKey(alias)) {
                throw new IllegalStateException("Entity with alias: " + alias + " already exists in cache!");
            }
            this.keys.put(alias, id);
        }
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            this.keys.put(name, id);
        }
        return (RESOURCE)((TestModel)super.put(id, resource));
    }

    @Override
    public RESOURCE get(Object key) {
        return (RESOURCE)((TestModel)super.get(this.findKey(key)));
    }

    @Override
    public RESOURCE remove(Object key) {
        RESOURCE resource = this.get(key);
        if (resource == null) {
            return null;
        }
        String id = this.idSupplier.apply(resource);
        this.findKeysFor(id).forEach(this.keys::remove);
        return (RESOURCE)((TestModel)super.remove(id));
    }

    private Object findKey(Object key) {
        Object realKey = key;
        if (key instanceof String) {
            String k = (String)key;
            if (!Pattern.compile(UUID_PATTERN).matcher(k).matches() || !super.containsKey(k)) {
                realKey = this.keys.getOrDefault(k, k);
            }
        }
        return realKey;
    }

    public Set<String> findKeysFor(Object id) {
        return this.keys.entrySet().stream().filter(entry -> id.equals(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }
}

