/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.requests;

import jakarta.json.JsonArrayBuilder;
import java.util.HashMap;
import org.alfresco.rest.core.JsonBodyGenerator;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestResponse;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestRenditionInfoModel;
import org.alfresco.rest.model.RestRenditionInfoModelCollection;
import org.alfresco.rest.model.RestSharedLinksModel;
import org.alfresco.rest.model.RestSharedLinksModelCollection;
import org.alfresco.rest.requests.ModelRequest;
import org.alfresco.utility.model.FileModel;
import org.springframework.http.HttpMethod;

public class SharedLinks
extends ModelRequest<SharedLinks> {
    public SharedLinks(RestWrapper restWrapper) {
        super(restWrapper);
    }

    public RestSharedLinksModelCollection getSharedLinks() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "shared-links?{parameters}", this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestSharedLinksModelCollection.class, request);
    }

    public RestSharedLinksModel getSharedLink(RestSharedLinksModel sharedLinksModel) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "shared-links/{sharedLinkId}?{parameters}", sharedLinksModel.getId(), this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestSharedLinksModel.class, request);
    }

    public RestResponse getSharedLinkContent(RestSharedLinksModel sharedLinksModel) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "shared-links/{sharedLinkId}/content?{parameters}", sharedLinksModel.getId(), this.restWrapper.getParameters());
        return this.restWrapper.process(request);
    }

    public RestResponse sendSharedLinkEmail(RestSharedLinksModel sharedLinksModel, String postBody) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, "shared-links/{sharedLinkId}/email?{parameters}", sharedLinksModel.getId(), this.restWrapper.getParameters());
        return this.restWrapper.process(request);
    }

    public RestRenditionInfoModelCollection getSharedLinkRenditions(RestSharedLinksModel sharedLinksModel) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "shared-links/{sharedLinkId}/renditions?{parameters}", sharedLinksModel.getId(), this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestRenditionInfoModelCollection.class, request);
    }

    public RestRenditionInfoModel getSharedLinkRendition(RestSharedLinksModel sharedLinksModel, String renditionId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "shared-links/{sharedLinkId}/renditions/{renditionId}?{parameters}", sharedLinksModel.getId(), renditionId, this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestRenditionInfoModel.class, request);
    }

    public RestResponse getSharedLinkRenditionContent(RestSharedLinksModel sharedLinksModel, String renditionId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "shared-links/{sharedLinkId}/renditions/{renditionId}/content?{parameters}", sharedLinksModel.getId(), renditionId, this.restWrapper.getParameters());
        return this.restWrapper.process(request);
    }

    public void deleteSharedLink(RestSharedLinksModel sharedLinksModel) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "shared-links/{sharedLinkId}", sharedLinksModel.getId());
        this.restWrapper.processEmptyModel(request);
    }

    public RestSharedLinksModel createSharedLink(FileModel file) {
        String postBody = JsonBodyGenerator.keyValueJson("nodeId", file.getNodeRefWithoutVersion());
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, "shared-links?{parameters}", this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestSharedLinksModel.class, request);
    }

    public RestSharedLinksModelCollection createSharedLinks(FileModel ... files) {
        JsonArrayBuilder array = JsonBodyGenerator.defineJSONArray();
        for (FileModel file : files) {
            array.add(JsonBodyGenerator.defineJSON().add("nodeId", file.getNodeRefWithoutVersion()));
        }
        String postBody = array.build().toString();
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, "shared-links?{parameters}", this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestSharedLinksModelCollection.class, request);
    }

    public RestSharedLinksModel createSharedLinkWithExpiryDate(FileModel file, String expiryDate) {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("nodeId", file.getNodeRefWithoutVersion());
        body.put("expiresAt", expiryDate);
        String postBody = JsonBodyGenerator.keyValueJson(body);
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, postBody, "shared-links?{parameters}", this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestSharedLinksModel.class, request);
    }
}

