/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.requests.privateAPI;

import io.restassured.RestAssured;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestCustomTypeModel;
import org.alfresco.rest.model.RestSubscriberModel;
import org.alfresco.rest.model.RestSyncNodeSubscriptionModel;
import org.alfresco.rest.requests.CustomAspectModelManager;
import org.alfresco.rest.requests.CustomModelManager;
import org.alfresco.rest.requests.CustomTypeManager;
import org.alfresco.rest.requests.ModelRequest;
import org.alfresco.rest.requests.Node;
import org.alfresco.rest.requests.syncServiceAPI.Healthcheck;
import org.alfresco.rest.requests.syncServiceAPI.Subscribers;
import org.alfresco.rest.requests.syncServiceAPI.Subscriptions;
import org.alfresco.rest.requests.syncServiceAPI.Sync;
import org.alfresco.utility.model.CustomAspectModel;
import org.alfresco.utility.model.CustomContentModel;
import org.alfresco.utility.model.RepoTestModel;

public class RestPrivateAPI
extends ModelRequest<RestPrivateAPI> {
    public RestPrivateAPI(RestWrapper restWrapper) {
        super(restWrapper);
        RestAssured.basePath = "alfresco/api/-default-/private/alfresco/versions/1";
        restWrapper.configureRequestSpec().setBasePath(RestAssured.basePath);
    }

    public CustomModelManager usingCustomModel(CustomContentModel customContentModel) {
        return new CustomModelManager(customContentModel, this.restWrapper);
    }

    public CustomModelManager usingCustomModel() {
        return new CustomModelManager(this.restWrapper);
    }

    public CustomAspectModelManager usingAspect(CustomContentModel customContentModel, CustomAspectModel aspectModel) {
        return new CustomAspectModelManager(customContentModel, aspectModel, this.restWrapper);
    }

    public CustomTypeManager usingCustomType(CustomContentModel customContentModel, RestCustomTypeModel customType) {
        return new CustomTypeManager(customContentModel, customType, this.restWrapper);
    }

    public Subscribers withSubscribers() {
        return new Subscribers(this.restWrapper);
    }

    public Subscriptions withSubscriber(RestSubscriberModel subscriber) {
        return new Subscriptions(subscriber, this.restWrapper);
    }

    public Subscriptions withSubscriber(String subscriberID) {
        RestSubscriberModel s = new RestSubscriberModel();
        s.setId(subscriberID);
        return new Subscriptions(s, this.restWrapper);
    }

    public Sync withSubscription(RestSyncNodeSubscriptionModel nodeSubscription) {
        RestSubscriberModel s = new RestSubscriberModel();
        s.setId(nodeSubscription.getDeviceSubscriptionId());
        return new Sync(nodeSubscription, this.restWrapper);
    }

    public Healthcheck doHealthCheck() {
        return new Healthcheck(this.restWrapper);
    }

    public Node usingNode(RepoTestModel node) {
        return new Node(node, this.restWrapper);
    }
}

