/*-
 * #%L
 * alfresco-tas-restapi
 * %%
 * Copyright (C) 2005 - 2022 Alfresco Software Limited
 * %%
 * This file is part of the Alfresco software. 
 * If the software was purchased under a paid Alfresco license, the terms of 
 * the paid license agreement will prevail.  Otherwise, the software is 
 * provided under the following open source license terms:
 * 
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.alfresco.rest.model;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

import org.alfresco.rest.core.IRestModel;
import org.alfresco.utility.model.TestModel;

/**
 * Generated by 'Kristian.Dimitrov@hyland.com' on '2022-07-14 13:22' from 'Alfresco Content Services REST API' swagger file 
 * Generated from 'Alfresco Content Services REST API' swagger file
 * Base Path {@linkplain /alfresco/api/-default-/public/alfresco/versions/1}
 */
public class RestActionBodyExecTemplateModel extends TestModel implements IRestModel<RestActionBodyExecTemplateModel>
{
    @JsonProperty(value = "entry")
    RestActionBodyExecTemplateModel model;

    @Override
    public RestActionBodyExecTemplateModel onModel()
    {
        return model;
    }


    @JsonProperty(required = true)    
    private String actionDefinitionId;	    

    private Map<String, Serializable> params;

    public String getActionDefinitionId()
    {
        return this.actionDefinitionId;
    }

    public void setActionDefinitionId(String actionDefinitionId)
    {
        this.actionDefinitionId = actionDefinitionId;
    }				

    public Map<String, Serializable> getParams()
    {
        return this.params;
    }

    public void setParams(Map<String, Serializable> params)
    {
        this.params = params;
    }

    @Override
    public String toString()
    {
        return "RestActionBodyExecTemplateModel{" + "actionDefinitionId='" + actionDefinitionId + '\'' + ", params=" + params + '}';
    }

    @Override
    public boolean equals(Object o)
    {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        RestActionBodyExecTemplateModel that = (RestActionBodyExecTemplateModel) o;
        return Objects.equals(actionDefinitionId, that.actionDefinitionId) && Objects.equals(params, that.params);
    }

    @Override
    public int hashCode()
    {
        return Objects.hash(actionDefinitionId, params);
    }
}
 
