/*-
 * #%L
 * alfresco-tas-restapi
 * %%
 * Copyright (C) 2005 - 2022 Alfresco Software Limited
 * %%
 * This file is part of the Alfresco software. 
 * If the software was purchased under a paid Alfresco license, the terms of 
 * the paid license agreement will prevail.  Otherwise, the software is 
 * provided under the following open source license terms:
 * 
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.alfresco.rest.search;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import org.alfresco.rest.core.IRestModel;
import org.alfresco.utility.model.TestModel;

/**
 * Generated by 'gethin' on '2017-05-05 09:54' from 'Alfresco Content Services REST API' swagger file 
 * Generated from 'Alfresco Content Services REST API' swagger file
 * Base Path {@linkplain /alfresco/api/-default-/public/search/versions/1}
 */

/*
 From Jackson 2.8 this annotation is required to make sure that defaults are read from the actual field values,
 as opposing to field type defaults. For example, the default for boolean primitive is "false",
 but the default for the "min" field in this class is "true".
 This configuration does not affect the product and is only related to test framework and how it serializes the request into JSON.
 See org.alfresco.utility.model.TestModel#toJson
 Note: This change was required for org.alfresco.test.search.functional.searchServices.search.StatsSearchTest
 */
@JsonInclude(JsonInclude.Include.NON_DEFAULT)
public class RestRequestStatsModel extends TestModel implements IRestModel<RestRequestStatsModel>
{
    @JsonProperty(value = "entry")
    RestRequestStatsModel model;

    @Override
    public RestRequestStatsModel onModel()
    {
        return model;
    }

    /**
    The stats field
    */	        

    private String field;	    
    /**
    A label to include for reference the stats field
    */	        

    private String label;	    
    /**
    The minimum value of the field
    */	        

    private boolean min = true;
    /**
    The maximum value of the field
    */	        

    private boolean max = true;
    /**
    The sum of all values of the field
    */	        

    private boolean sum = true;
    /**
    The Number of values found
    */	        

    private boolean countValues = true;
    /**
    The Number which do not have a value for this field
    */	        

    private boolean missing = true;
    /**
    The average
    */	        

    private boolean mean = true;
    /**
    Standard deviation
    */	        

    private boolean stddev = true;
    /**
    Sum of all values squared
    */	        

    private boolean sumOfSquares = true;
    /**
    The set of all distinct values for the field (This can be very expensive to calculate)
    */	        

    private boolean distinctValues;	    
    /**
    The Number of distinct values  (This can be very expensive to calculate)
    */	        

    private boolean countDistinct;	    
    /**
    A statistical approximation of the Number of distinct values
    */	        

    private boolean cardinality;	    
    /**
    Number between 0.0 and 1.0 indicating how aggressively the algorithm should try to be accurate. Used with boolean cardinality flag.
    */	        

    private Number cardinalityAccuracy;	    
    /**
    A list of filters to exclude
    */	        

    private List<String> excludeFilters;	    
    /**
    A list of percentile values, e.g. "1,99,99.9"
    */	        

    private List<Number> percentiles;	    

    public String getField()
    {
        return this.field;
    }

    public void setField(String field)
    {
        this.field = field;
    }				

    public String getLabel()
    {
        return this.label;
    }

    public void setLabel(String label)
    {
        this.label = label;
    }				

    public boolean getMin()
    {
        return this.min;
    }

    public void setMin(boolean min)
    {
        this.min = min;
    }				

    public boolean getMax()
    {
        return this.max;
    }

    public void setMax(boolean max)
    {
        this.max = max;
    }				

    public boolean getSum()
    {
        return this.sum;
    }

    public void setSum(boolean sum)
    {
        this.sum = sum;
    }				

    public boolean getCountValues()
    {
        return this.countValues;
    }

    public void setCountValues(boolean countValues)
    {
        this.countValues = countValues;
    }				

    public boolean getMissing()
    {
        return this.missing;
    }

    public void setMissing(boolean missing)
    {
        this.missing = missing;
    }				

    public boolean getMean()
    {
        return this.mean;
    }

    public void setMean(boolean mean)
    {
        this.mean = mean;
    }				

    public boolean getStddev()
    {
        return this.stddev;
    }

    public void setStddev(boolean stddev)
    {
        this.stddev = stddev;
    }				

    public boolean getSumOfSquares()
    {
        return this.sumOfSquares;
    }

    public void setSumOfSquares(boolean sumOfSquares)
    {
        this.sumOfSquares = sumOfSquares;
    }				

    public boolean getDistinctValues()
    {
        return this.distinctValues;
    }

    public void setDistinctValues(boolean distinctValues)
    {
        this.distinctValues = distinctValues;
    }				

    public boolean getCountDistinct()
    {
        return this.countDistinct;
    }

    public void setCountDistinct(boolean countDistinct)
    {
        this.countDistinct = countDistinct;
    }				

    public boolean getCardinality()
    {
        return this.cardinality;
    }

    public void setCardinality(boolean cardinality)
    {
        this.cardinality = cardinality;
    }				

    public Number getCardinalityAccuracy()
    {
        return this.cardinalityAccuracy;
    }

    public void setCardinalityAccuracy(Number cardinalityAccuracy)
    {
        this.cardinalityAccuracy = cardinalityAccuracy;
    }				

    public List<String> getExcludeFilters()
    {
        return this.excludeFilters;
    }

    public void setExcludeFilters(List<String> excludeFilters)
    {
        this.excludeFilters = excludeFilters;
    }				

    public List<Number> getPercentiles()
    {
        return this.percentiles;
    }

    public void setPercentiles(List<Number> percentiles)
    {
        this.percentiles = percentiles;
    }				
}
 
