/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.models.aspects;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestAbstractClassModel;
import org.alfresco.rest.model.RestAspectModel;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetAspectTests
extends RestTest {
    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.restClient.authenticateUser(this.dataUser.createRandomTestUser());
    }

    @Test(groups={"rest-api", "model", "regression"})
    @TestRail(section={"rest-api", "model"}, executionType={ExecutionType.REGRESSION}, description="Verify inexistent aspect and status code is Not Found (404)")
    public void getInexistentAspect() throws Exception {
        String unknownAspect = "unknown:aspect";
        this.restClient.withModelAPI().getAspect(unknownAspect);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_WAS_NOT_FOUND, unknownAspect));
    }

    @Test(groups={"rest-api", "model", "regression"})
    @TestRail(section={"rest-api", "model"}, executionType={ExecutionType.REGRESSION}, description="Verify Aspect Info and status code is OK (200)")
    public void getAspect() throws Exception {
        RestAspectModel aspect = this.restClient.withModelAPI().getAspect("cm:titled");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestAbstractClassModel)((RestAbstractClassModel)((RestAbstractClassModel)((RestAbstractClassModel)((RestAbstractClassModel)((RestAbstractClassModel)((RestAbstractClassModel)((RestAbstractClassModel)((RestAbstractClassModel)((RestAbstractClassModel)((RestAbstractClassModel)((RestAbstractClassModel)aspect.assertThat().field("associations").isEmpty()).and().field("mandatoryAspects").isEmpty()).and().field("properties").isNotEmpty()).and().field("includedInSupertypeQuery").is((Object)true)).and().field("isContainer").is((Object)false)).and().field("id").is((Object)"cm:titled")).and().field("description").is((Object)"Titled")).and().field("title").is((Object)"Titled")).and().field("model.id").is((Object)"cm:contentmodel")).and().field("model.author").is((Object)"Alfresco")).and().field("model.description").is((Object)"Alfresco Content Domain Model")).and().field("model.namespaceUri").is((Object)"http://www.alfresco.org/model/content/1.0")).and().field("model.namespacePrefix").is((Object)"cm");
    }
}

