/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.tasks.variables;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestVariableModel;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TaskModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AddTaskVariablesTestsBulk2
extends RestTest {
    private UserModel userWhoStartsTask;
    private UserModel adminUser;
    private SiteModel siteModel;
    private FileModel fileModel;
    private UserModel assigneeUser;
    private TaskModel taskModel;
    private RestVariableModel invalidVariableModel;
    private RestVariableModel variableModel;
    private RestVariableModel variableModel1;
    private String taskId;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userWhoStartsTask = this.dataUser.createRandomTestUser();
        this.assigneeUser = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.adminUser)).createPublicRandomSite();
        this.fileModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assigneeUser);
        this.taskId = this.taskModel.getId();
        this.restClient.authenticateUser(this.adminUser);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Adding task variable is falling in case invalid variableBody is provided")
    public void failedAddingTaskVariableIfInvalidBodyIsProvided() throws Exception {
        this.invalidVariableModel = RestVariableModel.getRandomTaskVariableModel((String)"instance", (String)"d:char");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(this.invalidVariableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Illegal value for variable scope: 'instance'.");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Adding multiple task variable is falling in case invalid variableBody is provided")
    public void failedAddingMultipleTaskVariableIfInvalidBodyIsProvided() throws Exception {
        this.variableModel = RestVariableModel.getRandomTaskVariableModel((String)"instance", (String)"d:char");
        this.variableModel1 = RestVariableModel.getRandomTaskVariableModel((String)"global", (String)"d:text");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariables(new RestVariableModel[]{this.variableModel, this.variableModel1});
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Illegal value for variable scope: 'instance'.");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Adding task variable is falling in case empty body type is provided")
    public void failedAddingTaskVariableIfEmptyBodyIsProvided() throws Exception {
        RestVariableModel invalidVariableModel = RestVariableModel.getRandomTaskVariableModel((String)"", (String)"");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(invalidVariableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Variable scope is required and can only be 'local' or 'global'.");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Adding multiple task variable is falling in case empty body type is provided")
    public void failedAddingMultipleTaskVariableIfEmptyBodyIsProvided() throws Exception {
        RestVariableModel invalidVariableModel = RestVariableModel.getRandomTaskVariableModel((String)"", (String)"");
        this.variableModel1 = RestVariableModel.getRandomTaskVariableModel((String)"global", (String)"d:text");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariables(new RestVariableModel[]{invalidVariableModel, this.variableModel1});
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Variable scope is required and can only be 'local' or 'global'.");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Adding task variable is falling in case incomplete body type is provided")
    public void failedAddingTaskVariableIfIncompleteBodyIsProvided() throws Exception {
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)"{\"name\": \"missingVariableScope\",\"value\": \"test\",\"type\": \"d:text\"}", (String)"tasks/{taskId}/variables", (String[])new String[]{this.taskId});
        this.restClient.processModel(RestVariableModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Variable scope is required and can only be 'local' or 'global'.");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Adding task variable is falling in case incomplete body - missing required: name type is provided")
    public void failedAddingTaskVariableIfIncompleteRequiredBodyIsProvided() throws Exception {
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)"{\"scope\": \"local\",\"value\": \"missingVariableName\",\"type\": \"d:text\"}", (String)"tasks/{taskId}/variables", (String[])new String[]{this.taskId});
        this.restClient.processModel(RestVariableModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Variable name is required.");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Adding task variable is falling in case invalid type is provided")
    public void failedAddingTaskVariableIfInvalidTypeIsProvided() throws Exception {
        RestVariableModel invalidVariableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:char");
        this.taskModel.setId(this.taskId);
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(invalidVariableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Unsupported type of variable: 'd:char'.");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Adding multiple task variable is falling in case invalid type is provided")
    public void failedAddingMultipleTaskVariableIfInvalidTypeIsProvided() throws Exception {
        RestVariableModel invalidVariableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:char");
        this.taskModel.setId(this.taskId);
        this.variableModel1 = RestVariableModel.getRandomTaskVariableModel((String)"global", (String)"d:text");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariables(new RestVariableModel[]{invalidVariableModel, this.variableModel1});
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Unsupported type of variable: 'd:char'.");
    }

    @Bug(id="ACE-5674")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Adding task variable is falling in case invalid type prefix is provided")
    public void failedAddingTaskVariableIfInvalidTypePrefixIsProvided() throws Exception {
        RestVariableModel invalidVariableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"ddm:text");
        this.taskModel.setId(this.taskId);
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(invalidVariableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Namespace prefix ddm is not mapped to a namespace URI");
    }

    @Bug(id="ACE-5674")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Adding multiple task variable is falling in case invalid type prefix is provided")
    public void failedAddingMultipleTaskVariableIfInvalidTypePrefixIsProvided() throws Exception {
        RestVariableModel invalidVariableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"ddm:text");
        this.taskModel.setId(this.taskId);
        this.variableModel1 = RestVariableModel.getRandomTaskVariableModel((String)"global", (String)"d:text");
        this.variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariables(new RestVariableModel[]{invalidVariableModel, this.variableModel1, this.variableModel});
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Namespace prefix ddm is not mapped to a namespace URI");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Adding task variable is falling in case invalid scope is provided")
    public void failedAddingTaskVariableIfInvalidScopeIsProvided() throws Exception {
        RestVariableModel invalidVariableModel = RestVariableModel.getRandomTaskVariableModel((String)"instance", (String)"d:text");
        this.taskModel.setId(this.taskId);
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(invalidVariableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Illegal value for variable scope: 'instance'.");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Adding multiple task variable is falling in case invalid scope is provided")
    public void failedAddingMultipleTaskVariableIfInvalidScopeIsProvided() throws Exception {
        RestVariableModel invalidVariableModel = RestVariableModel.getRandomTaskVariableModel((String)"instance", (String)"d:text");
        this.taskModel.setId(this.taskId);
        this.variableModel1 = RestVariableModel.getRandomTaskVariableModel((String)"global", (String)"d:text");
        this.variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariables(new RestVariableModel[]{invalidVariableModel, this.variableModel, this.variableModel1});
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Illegal value for variable scope: 'instance'.");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Adding task variable is falling in case invalid task id is provided")
    public void failedAddingTaskVariableIfInvalidTaskIdIsProvided() throws Exception {
        RestVariableModel variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.taskModel.setId(this.taskModel.getId() + "TEST");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.taskModel.getId()));
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Adding multiple task variable is falling in case invalid task id is provided")
    public void failedAddingMultipleTaskVariableIfInvalidTaskIdIsProvided() throws Exception {
        this.variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.taskModel.setId(this.taskModel.getId() + "TEST");
        this.variableModel1 = RestVariableModel.getRandomTaskVariableModel((String)"global", (String)"d:text");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariables(new RestVariableModel[]{this.variableModel, this.variableModel1});
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.taskModel.getId()));
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Adding task variable is falling in case invalid task id is provided")
    public void failedAddingTaskVariableIfInvalidValueIsProvided() throws Exception {
        RestVariableModel variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:int");
        variableModel.setValue((Object)"invalidValue");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("For input string: \"invalidValue\"");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Adding multiple task variable is falling in case invalid task id is provided")
    public void failedAddingMultipleTaskVariableIfInvalidValueIsProvided() throws Exception {
        this.variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:int");
        this.variableModel.setValue((Object)"invalidValue");
        this.variableModel1 = RestVariableModel.getRandomTaskVariableModel((String)"global", (String)"d:text");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariables(new RestVariableModel[]{this.variableModel, this.variableModel1});
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("For input string: \"invalidValue\"");
    }
}

