/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.model;

import java.util.List;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestTaskModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;

public class RestTaskModelsCollection
extends RestModels<RestTaskModel, RestTaskModelsCollection> {
    public RestTaskModel getTaskModelByAssignee(UserModel assigneeName) {
        List tasksList = this.getEntries();
        for (RestTaskModel taskModel : tasksList) {
            if (!taskModel.onModel().getAssignee().equals(assigneeName.getUsername())) continue;
            Step.STEP((String)String.format("REST API: Get task with assignee '%s'", assigneeName.getUsername()));
            return taskModel.onModel();
        }
        return null;
    }

    public RestTaskModel getTaskModelByDescription(SiteModel siteModel) {
        List tasksList = this.getEntries();
        for (RestTaskModel taskModel : tasksList) {
            if (!taskModel.onModel().getDescription().equals(String.format("Request to join %s site", siteModel.getId()))) continue;
            Step.STEP((String)String.format("REST API: Get task with site name '%s'", siteModel.getId()));
            return taskModel.onModel();
        }
        return null;
    }

    public RestTaskModel getTaskModelByProcess(ProcessModel process) {
        List tasksList = this.getEntries();
        for (RestTaskModel taskModel : tasksList) {
            if (!taskModel.onModel().getProcessId().equals(process.getId())) continue;
            Step.STEP((String)String.format("REST API: Get task with processId '%s'", process.getId()));
            return taskModel.onModel();
        }
        return null;
    }
}

