/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.tasks.items;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestItemModel;
import org.alfresco.rest.model.RestItemModelsCollection;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.rest.model.RestTaskModel;
import org.alfresco.rest.requests.workflowAPI.RestWorkflowAPI;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TaskModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetTaskItemsRegressionTests
extends RestTest {
    private UserModel userWhoStartsTask;
    private UserModel assignee;
    private UserModel adminUser;
    private SiteModel siteModel;
    private FileModel fileModel;
    private TaskModel taskModel;
    private RestItemModelsCollection itemModels;
    private RestProcessModel addedProcess;
    private RestTaskModel addedTask;
    private RestItemModel taskItem;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userWhoStartsTask = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userWhoStartsTask)).createPublicRandomSite();
        this.fileModel = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify if get task items call return status code 404 when invalid taskId is provided")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void getTaskItemsUsingInvalidTaskId() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assignee);
        this.taskModel.setId("invalidId");
        this.restClient.authenticateUser(this.assignee).withWorkflowAPI().usingTask(this.taskModel).getTaskItems();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "invalidId"));
        this.taskModel.setId("");
        this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().usingTask(this.taskModel).getTaskItems();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, ""));
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify if get task items request returns status code 200 after the task is finished.")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void getTaskItemsAfterFinishingTask() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assignee);
        ((DataWorkflow)this.dataWorkflow.usingUser(this.assignee)).taskDone(this.taskModel);
        this.restClient.authenticateUser(this.userWhoStartsTask);
        this.itemModels = this.restClient.withWorkflowAPI().usingTask(this.taskModel).getTaskItems();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.itemModels.assertThat().entriesListIsNotEmpty()).and().entriesListContains("name", this.fileModel.getName());
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify if get task items request returns status code 200 after the process is deleted (Task state is now completed.)")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void getTaskItemsAfterDeletingProcess() throws Exception {
        this.addedProcess = this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.addedTask = this.restClient.withWorkflowAPI().getTasks().getTaskModelByProcess((ProcessModel)this.addedProcess);
        this.restClient.withWorkflowAPI().usingTask((TaskModel)this.addedTask).addTaskItem(this.fileModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.addedProcess).deleteProcess();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.itemModels = this.restClient.withWorkflowAPI().usingTask((TaskModel)this.addedTask).getTaskItems();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.itemModels.assertThat().entriesListIsNotEmpty()).and().entriesListContains("name", this.fileModel.getName());
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Check default error model schema for get task items api call")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void getTaskItemsUsingCheckErrorModel() throws Exception {
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assignee);
        this.taskModel.setId("invalidId");
        this.restClient.authenticateUser(this.assignee).withWorkflowAPI().usingTask(this.taskModel).getTaskItems();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "invalidId")).containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).stackTraceIs(RestErrorModel.STACKTRACE).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that admin user can get task items")
    public void getTaskItemsByAdminUser() throws Exception {
        this.restClient.authenticateUser(this.userWhoStartsTask);
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assignee);
        this.taskItem = (RestItemModel)this.restClient.withWorkflowAPI().usingTask(this.taskModel).getTaskItems().getOneRandomEntry();
        this.itemModels = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withWorkflowAPI().usingTask(this.taskModel).getTaskItems();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestModels)((RestModels)((RestModels)this.itemModels.assertThat().entriesListIsNotEmpty()).and().entriesListContains("id", this.taskItem.onModel().getId())).and().entriesListContains("name", this.taskItem.onModel().getName())).getEntries().get(0)).onModel().assertThat().field("createdAt").isNotNull()).assertThat().field("size").isNotNull()).assertThat().field("createdBy").contains(this.dataUser.getAdminUser().getUsername())).assertThat().field("modifiedAt").isNotNull()).assertThat().field("name").contains(this.fileModel.getName())).assertThat().field("modifiedBy").contains(this.userWhoStartsTask.getUsername())).assertThat().field("id").contains(this.fileModel.getNodeRef().split(";")[0])).assertThat().field("mimeType").contains(this.fileModel.getFileType().mimeType);
    }

    @Bug(id="MNT-17438")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that user who started the process can get task items with skip count parameter")
    public void getTaskItemsWithSkipCount() throws Exception {
        this.restClient.authenticateUser(this.userWhoStartsTask);
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assignee);
        FileModel document1 = ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.XML);
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskItem(document1);
        this.itemModels = ((RestWorkflowAPI)this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().usingParams(new String[]{"skipCount=1"})).usingTask(this.taskModel).getTaskItems();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.itemModels.assertThat().entriesListIsNotEmpty()).and().paginationField("count").is("1");
    }

    @Bug(id="MNT-17438")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that user who started the process can get task items with max items parameter")
    public void getTaskItemsWithMaxItems() throws Exception {
        this.restClient.authenticateUser(this.userWhoStartsTask);
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assignee);
        FileModel document1 = ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.XML);
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskItem(document1);
        this.itemModels = ((RestWorkflowAPI)this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().usingParams(new String[]{"maxItems=1"})).usingTask(this.taskModel).getTaskItems();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.itemModels.assertThat().entriesListIsNotEmpty()).and().paginationField("count").is("1");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that user who started the process can get task items with valid properties")
    public void getTaskItemsWithValidProperties() throws Exception {
        this.restClient.authenticateUser(this.userWhoStartsTask);
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assignee);
        this.taskItem = (RestItemModel)this.restClient.withWorkflowAPI().usingTask(this.taskModel).getTaskItems().getOneRandomEntry();
        this.itemModels = ((RestWorkflowAPI)this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().usingParams(new String[]{"properties=createdAt,createdBy,id,size"})).usingTask(this.taskModel).getTaskItems();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)this.itemModels.getOneRandomEntry()).onModel().assertThat().fieldsCount().is((Object)4)).and().field("createdAt").isNotNull()).and().field("size").isNotNull()).and().field("createdBy").isNotNull()).and().field("modifiedAt").isNull()).and().field("name").isNull()).and().field("modifiedBy").isNull()).and().field("id").isNotNull()).and().field("mimeType").isNull();
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that user who started the process can get task items with an invalid property")
    public void getTaskItemsWithInvalidProperties() throws Exception {
        this.restClient.authenticateUser(this.userWhoStartsTask);
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assignee);
        this.taskItem = (RestItemModel)this.restClient.withWorkflowAPI().usingTask(this.taskModel).getTaskItems().getOneRandomEntry();
        this.itemModels = ((RestWorkflowAPI)this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().usingParams(new String[]{"properties=size,fake-prop"})).usingTask(this.taskModel).getTaskItems();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)((RestItemModel)this.itemModels.getOneRandomEntry()).onModel().assertThat().fieldsCount().is((Object)1)).and().field("createdAt").isNull()).and().field("size").isNotNull()).and().field("createdBy").isNull()).and().field("modifiedAt").isNull()).and().field("name").isNull()).and().field("modifiedBy").isNull()).and().field("id").isNull()).and().field("mimeType").isNull();
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that involved user in process that was deleted cannot get task items")
    public void getTaskItemsByDeletedUserInvolvedInProcess() throws Exception {
        UserModel assigneeDeleted = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(this.userWhoStartsTask);
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(assigneeDeleted);
        ((DataUser)this.dataUser.usingAdmin()).deleteUser(assigneeDeleted);
        this.itemModels = this.restClient.authenticateUser(assigneeDeleted).withWorkflowAPI().usingTask(this.taskModel).getTaskItems();
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Verify that involved user in process that was disabled cannot get task items")
    public void getTaskItemsByDisabledUserInvolvedInProcess() throws Exception {
        UserModel assigneeDisabled = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(this.userWhoStartsTask);
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(assigneeDisabled);
        ((DataUser)this.dataUser.usingAdmin()).disableUser(assigneeDisabled);
        this.itemModels = this.restClient.authenticateUser(assigneeDisabled).withWorkflowAPI().usingTask(this.taskModel).getTaskItems();
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }
}

