/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.sites.members;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.utility.Utility;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class RemoveSiteMemberTests
extends RestTest {
    private SiteModel publicSiteModel;
    private SiteModel moderatedSiteModel;
    private SiteModel privateSiteModel;
    private UserModel adminUserModel;
    private UserModel siteCreator;
    private DataUser.ListUserWithRoles usersWithRoles;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws DataPreparationException {
        this.adminUserModel = this.dataUser.getAdminUser();
        this.siteCreator = this.dataUser.createRandomTestUser();
        this.publicSiteModel = ((DataSite)this.dataSite.usingUser(this.siteCreator)).createPublicRandomSite();
        this.moderatedSiteModel = ((DataSite)this.dataSite.usingUser(this.siteCreator)).createModeratedRandomSite();
        this.privateSiteModel = ((DataSite)this.dataSite.usingUser(this.siteCreator)).createPrivateRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.publicSiteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
    }

    @Test(groups={"rest-api", "sites", "sanity"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.SANITY}, description="Verify that site manager can delete site member and gets status code 204, 'No Content'")
    public void siteManagerIsAbleToDeleteSiteMemberWithConsumerRole() throws Exception {
        UserModel testUserModel = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(testUserModel, this.publicSiteModel, UserRole.SiteConsumer);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).deleteSiteMember(testUserModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        Utility.sleep((int)300, (int)30000, () -> this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteMembers().assertThat().entriesListDoesNotContain("id", testUserModel.getUsername()));
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that site collaborator cannot delete site member and gets status code 403, 'Forbidden'")
    public void siteCollaboratorIsNotAbleToDeleteSiteMemberWithConsumerRole() throws Exception {
        UserModel testUserModel = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(testUserModel, this.publicSiteModel, UserRole.SiteConsumer);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator));
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).deleteSiteMember(testUserModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY);
        Utility.sleep((int)300, (int)30000, () -> this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteMembers().assertThat().entriesListContains("id", testUserModel.getUsername()));
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that site contributor cannot delete site member and gets status code 403, 'Forbidden'")
    public void siteContributorIsNotAbleToDeleteSiteMemberWithConsumerRole() throws Exception {
        UserModel testUserModel = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(testUserModel, this.publicSiteModel, UserRole.SiteConsumer);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor));
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).deleteSiteMember(testUserModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY);
        Utility.sleep((int)300, (int)30000, () -> this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteMembers().assertThat().entriesListContains("id", testUserModel.getUsername()));
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that site consumer cannot delete site member and gets status code 403, 'Forbidden'")
    public void siteConsumerIsNotAbleToDeleteSiteMemberWithConsumerRole() throws Exception {
        UserModel testUserModel = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(testUserModel, this.publicSiteModel, UserRole.SiteConsumer);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingSite(this.publicSiteModel).deleteSiteMember(testUserModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY);
        Utility.sleep((int)300, (int)30000, () -> this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteMembers().assertThat().entriesListContains("id", testUserModel.getUsername()));
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "sanity"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.SANITY}, description="Verify that unauthenticated user is not able to delete site member")
    public void unauthenticatedUserIsNotAuthorizedToDeleteSiteMember() throws Exception {
        UserModel testUserModel = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(testUserModel, this.publicSiteModel, UserRole.SiteConsumer);
        UserModel inexistentUser = new UserModel("inexistent user", "inexistent password");
        this.restClient.authenticateUser(inexistentUser).withCoreAPI().usingSite(this.publicSiteModel).deleteSiteMember(testUserModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that manager can NOT delete site member for an inexistent user and gets status code 404, 'Not Found'")
    @Test(groups={"rest-api", "sites", "regression"})
    public void managerIsNotAbleToDeleteInexistentSiteMember() throws Exception {
        UserModel inexistentUser = new UserModel("inexistentUser", "password");
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).deleteSiteMember(inexistentUser);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, inexistentUser.getUsername()));
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that manager can NOT delete site member for a non site member and gets status code 400, 'Bad Request'")
    @Test(groups={"rest-api", "sites", "regression"})
    public void managerIsNotAbleToDeleteNotSiteMember() throws Exception {
        UserModel nonMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).deleteSiteMember(nonMember);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_ARGUMENT, "argument"));
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that manager can NOT delete site member for an invalid site and gets status code 404, 'Not Found'")
    @Test(groups={"rest-api", "sites", "regression"})
    public void managerIsNotAbleToDeleteSiteMemberOfInvalidSite() throws Exception {
        SiteModel invalidSite = new SiteModel("invalidSite");
        UserModel testUserModel = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(testUserModel, this.publicSiteModel, UserRole.SiteConsumer);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingSite(invalidSite).deleteSiteMember(testUserModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, testUserModel.getUsername(), invalidSite.getId()));
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that manager can delete a site member with manager role")
    @Test(groups={"rest-api", "sites", "regression"})
    public void siteManagerIsAbleToDeleteSiteMemberWithManagerRole() throws Exception {
        UserModel anothermanager = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(anothermanager, this.publicSiteModel, UserRole.SiteManager);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingSite(this.publicSiteModel).deleteSiteMember(anothermanager);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        Utility.sleep((int)300, (int)30000, () -> this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteMembers().assertThat().entriesListDoesNotContain("id", anothermanager.getUsername()));
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that manager can delete site member using \"-me-\" in place of personId")
    @Test(groups={"rest-api", "sites", "regression"})
    public void managerIsAbleToDeleteSiteMemberUsingMe() throws Exception {
        UserModel manager = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(manager, this.publicSiteModel, UserRole.SiteManager);
        UserModel meUser = new UserModel("-me-", "password");
        this.restClient.authenticateUser(manager);
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).deleteSiteMember(meUser);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        Utility.sleep((int)300, (int)30000, () -> this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteMembers().assertThat().entriesListDoesNotContain("id", manager.getUsername()));
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that site collaborator cannot delete a site member with Manager role and gets status code 422")
    @Test(groups={"rest-api", "sites", "regression"})
    public void siteCollaboratorIsNotAbleToDeleteSiteMemberWithManagerRole() throws Exception {
        UserModel managerForDelete = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(managerForDelete, this.publicSiteModel, UserRole.SiteManager);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator));
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).deleteSiteMember(managerForDelete);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsSummary(String.format(RestErrorModel.NOT_SUFFICIENT_PERMISSIONS, this.publicSiteModel.getId()));
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that site contributor cannot delete site member with Manager role and gets status code 422")
    @Test(groups={"rest-api", "sites", "regression"})
    public void siteContributorIsNotAbleToDeleteSiteMemberWithManagerRole() throws Exception {
        UserModel managerForDelete = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(managerForDelete, this.publicSiteModel, UserRole.SiteManager);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor));
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).deleteSiteMember(managerForDelete);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsSummary(String.format(RestErrorModel.NOT_SUFFICIENT_PERMISSIONS, this.publicSiteModel.getId()));
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that site consumer cannot delete site member with Manager role and gets status code 422")
    @Test(groups={"rest-api", "sites", "regression"})
    public void siteConsumerIsNotAbleToDeleteSiteMemberWithManagerRole() throws Exception {
        UserModel managerForDelete = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(managerForDelete, this.publicSiteModel, UserRole.SiteManager);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer));
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).deleteSiteMember(managerForDelete);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsSummary(String.format(RestErrorModel.NOT_SUFFICIENT_PERMISSIONS, this.publicSiteModel.getId()));
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that site collaborator cannot delete a site member with Contributor role and gets status code 422")
    @Test(groups={"rest-api", "sites", "regression"})
    public void siteCollaboratorIsNotAbleToDeleteSiteMemberWithContributorRole() throws Exception {
        UserModel contributorForDelete = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(contributorForDelete, this.publicSiteModel, UserRole.SiteContributor);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator));
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).deleteSiteMember(contributorForDelete);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsSummary(String.format(RestErrorModel.NOT_SUFFICIENT_PERMISSIONS, this.publicSiteModel.getId()));
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that site contributor cannot delete site member with Contributor role and gets status code 422")
    @Test(groups={"rest-api", "sites", "regression"})
    public void siteContributorIsNotAbleToDeleteSiteMemberWithContributorRole() throws Exception {
        UserModel contributorForDelete = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(contributorForDelete, this.publicSiteModel, UserRole.SiteContributor);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor));
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).deleteSiteMember(contributorForDelete);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsSummary(String.format(RestErrorModel.NOT_SUFFICIENT_PERMISSIONS, this.publicSiteModel.getId()));
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that site consumer cannot delete site member with Contributor role and gets status code 422")
    @Test(groups={"rest-api", "sites", "regression"})
    public void siteConsumerIsNotAbleToDeleteSiteMemberWithContributorRole() throws Exception {
        UserModel contributorForDelete = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(contributorForDelete, this.publicSiteModel, UserRole.SiteContributor);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer));
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).deleteSiteMember(contributorForDelete);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsSummary(String.format(RestErrorModel.NOT_SUFFICIENT_PERMISSIONS, this.publicSiteModel.getId()));
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that manager can delete a site member with Contributor role")
    @Test(groups={"rest-api", "sites", "regression"})
    public void siteManagerIsAbleToDeleteSiteMemberWithContributorRole() throws Exception {
        UserModel contributorForDelete = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(contributorForDelete, this.publicSiteModel, UserRole.SiteContributor);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingSite(this.publicSiteModel).deleteSiteMember(contributorForDelete);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        Utility.sleep((int)300, (int)30000, () -> this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteMembers().assertThat().entriesListDoesNotContain("id", contributorForDelete.getUsername()));
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that site collaborator cannot delete a site member with Collaborator role and gets status code 422")
    @Test(groups={"rest-api", "sites", "regression"})
    public void siteCollaboratorIsNotAbleToDeleteSiteMemberWithCollaboratorRole() throws Exception {
        UserModel collaboratorForDelete = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(collaboratorForDelete, this.publicSiteModel, UserRole.SiteCollaborator);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator));
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).deleteSiteMember(collaboratorForDelete);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsSummary(String.format(RestErrorModel.NOT_SUFFICIENT_PERMISSIONS, this.publicSiteModel.getId()));
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that site contributor cannot delete site member with Collaborator role and gets status code 422")
    @Test(groups={"rest-api", "sites", "regression"})
    public void siteContributorIsNotAbleToDeleteSiteMemberWithCollaboratorRole() throws Exception {
        UserModel collaboratorForDelete = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(collaboratorForDelete, this.publicSiteModel, UserRole.SiteCollaborator);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor));
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).deleteSiteMember(collaboratorForDelete);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsSummary(String.format(RestErrorModel.NOT_SUFFICIENT_PERMISSIONS, this.publicSiteModel.getId()));
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that site consumer cannot delete site member with Collaborator role and gets status code 422")
    @Test(groups={"rest-api", "sites", "regression"})
    public void siteConsumerIsNotAbleToDeleteSiteMemberWithCollaboratorRole() throws Exception {
        UserModel collaboratorForDelete = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(collaboratorForDelete, this.publicSiteModel, UserRole.SiteCollaborator);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer));
        this.restClient.withCoreAPI().usingSite(this.publicSiteModel).deleteSiteMember(collaboratorForDelete);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsSummary(String.format(RestErrorModel.NOT_SUFFICIENT_PERMISSIONS, this.publicSiteModel.getId()));
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that manager can delete a site member with Collaborator role")
    @Test(groups={"rest-api", "sites", "regression"})
    public void siteManagerIsAbleToDeleteSiteMemberWithCollaboratorRole() throws Exception {
        UserModel collaboratorForDelete = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(collaboratorForDelete, this.publicSiteModel, UserRole.SiteCollaborator);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingSite(this.publicSiteModel).deleteSiteMember(collaboratorForDelete);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        Utility.sleep((int)300, (int)30000, () -> this.restClient.withCoreAPI().usingSite(this.publicSiteModel).getSiteMembers().assertThat().entriesListDoesNotContain("id", collaboratorForDelete.getUsername()));
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that admin can delete a site member with Contributor role and gets status code 204")
    @Test(groups={"rest-api", "sites", "regression"})
    public void adminIsAbleToDeleteSiteMemberWithContributorRole() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.publicSiteModel).deleteSiteMember(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor));
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.dataUser.addUserToSite(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor), this.publicSiteModel, UserRole.SiteContributor);
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that admin can delete site member with Manager role and gets status code 204")
    @Test(groups={"rest-api", "sites", "regression"})
    public void aminIsAbleToDeleteSiteMemberWithManagerRole() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.publicSiteModel).deleteSiteMember(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.dataUser.addUserToSite(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager), this.publicSiteModel, UserRole.SiteManager);
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that admin can delete site member with Consumer role and gets status code 204")
    @Test(groups={"rest-api", "sites", "regression"})
    public void adminIsAbleToDeleteSiteMemberWithConsumerRole() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.publicSiteModel).deleteSiteMember(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer));
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.dataUser.addUserToSite(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer), this.publicSiteModel, UserRole.SiteConsumer);
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that admin can delete a site member with Collaborator role and gets status code 204")
    @Test(groups={"rest-api", "sites", "regression"})
    public void adminIsAbleToDeleteSiteMemberWithCollaboratorRole() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.publicSiteModel).deleteSiteMember(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator));
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.dataUser.addUserToSite(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator), this.publicSiteModel, UserRole.SiteCollaborator);
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that admin can delete a site member of moderated site and gets status code 204")
    @Test(groups={"rest-api", "sites", "regression"})
    public void adminIsAbleToDeleteModeratedSiteMember() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        newMember.setUserRole(UserRole.SiteManager);
        this.dataUser.addUserToSite(newMember, this.moderatedSiteModel, UserRole.SiteManager);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.moderatedSiteModel).deleteSiteMember(newMember);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that admin can delete a site member of private site and gets status code 204")
    @Test(groups={"rest-api", "sites", "regression"})
    public void adminIsAbleToDeletePrivateSiteMember() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        newMember.setUserRole(UserRole.SiteManager);
        this.dataUser.addUserToSite(newMember, this.privateSiteModel, UserRole.SiteManager);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.privateSiteModel).deleteSiteMember(newMember);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that regular user can not delete admin and gets status code 422")
    @Test(groups={"rest-api", "sites", "regression"})
    public void regularUserIsNotAbleToDeleteASiteMember() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingSite(this.publicSiteModel).deleteSiteMember(this.siteCreator);
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsSummary(String.format(RestErrorModel.NOT_SUFFICIENT_PERMISSIONS, this.publicSiteModel.getTitle())).containsErrorKey(RestErrorModel.API_DEFAULT_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that admin can not delete a site member twice and gets status code 404 for the second attempt")
    @Test(groups={"rest-api", "sites", "regression"})
    @Bug(id="ACE-5447")
    public void adminIsNotAbleToRemoveSiteMemberTwice() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.publicSiteModel).deleteSiteMember(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor));
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.publicSiteModel).deleteSiteMember(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor));
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(RestErrorModel.ENTITY_NOT_FOUND);
        this.dataUser.addUserToSite(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor), this.publicSiteModel, UserRole.SiteContributor);
    }

    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is not able to remove from site a user that created a member request that was not accepted yet")
    @Test(groups={"rest-api", "sites", "regression"})
    @Bug(id="ACE-5447")
    public void adminIsNotAbleToRemoveFromSiteANonExistingMember() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(newMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.publicSiteModel);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.moderatedSiteModel).deleteSiteMember(newMember);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(RestErrorModel.ENTITY_NOT_FOUND);
    }
}

