/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.nodes;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestNodeModel;
import org.alfresco.rest.model.body.RestNodeLockBodyModel;
import org.alfresco.rest.requests.Node;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class NodesUnlockTests
extends RestTest {
    private UserModel user1;
    private UserModel user2;
    private UserModel adminUser;
    private SiteModel publicSite;
    private FileModel file1;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.adminUser)).createPublicRandomSite();
        this.user1 = this.dataUser.createRandomTestUser();
        this.user2 = this.dataUser.createRandomTestUser();
        this.dataUser.addUserToSite(this.user1, this.publicSite, UserRole.SiteCollaborator);
        this.user1.setUserRole(UserRole.SiteCollaborator);
        this.dataUser.addUserToSite(this.user2, this.publicSite, UserRole.SiteCollaborator);
        this.user2.setUserRole(UserRole.SiteCollaborator);
    }

    @Test(groups={"rest-api", "nodes", "sanity"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY}, description="Verify Collaborator canot unlock EPHEMERAL lock made by different user, but can unlock EPHEMERAL lock made by same user")
    public void lockEphemeralAndUnlock() throws Exception {
        Step.STEP((String)"1. Add user(s) as collaborators to the site created by administrator and add a file in this site.");
        this.file1 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.publicSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"2. Verify with user1 that the file is not locked.");
        RestNodeModel file1Model1 = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        file1Model1.assertThat().field("isLocked").is((Object)false);
        Step.STEP((String)"3. Lock the file using mode EPHEMERAL with user1 (POST nodes/{nodeId}/lock).");
        RestNodeLockBodyModel lockBodyModel = new RestNodeLockBodyModel();
        lockBodyModel.setLifetime("EPHEMERAL");
        lockBodyModel.setTimeToExpire(20);
        ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include?isLocked"})).lockNode(lockBodyModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"4. Verify with user1 that the file is locked.");
        RestNodeModel file1Model2 = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        file1Model2.assertThat().field("isLocked").is((Object)true);
        Step.STEP((String)"5. Cannot unlock the file with user2 while the file is still locked");
        ((Node)this.restClient.authenticateUser(this.user2).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).unlockNode();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY).containsSummary(RestErrorModel.PERMISSION_WAS_DENIED).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
        Step.STEP((String)"6. Unlock the file with user1 while the file is still locked");
        RestNodeModel file1Model3 = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).unlockNode();
        file1Model3.assertThat().field("isLocked").is((Object)false);
    }

    @Test(groups={"rest-api", "nodes", "sanity"})
    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY}, description="Verify Collaborator canot unlock PERSISTENT lock made by different user, but can unlock PERSISTENT lock made by same user")
    public void lockPersistentAndUnlock() throws Exception {
        Step.STEP((String)"1. Add user(s) as collaborators to the site created by administrator and add a file in this site.");
        this.file1 = ((DataContent)this.dataContent.usingUser(this.adminUser).usingSite(this.publicSite)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"2. Verify with admin that the file is not locked.");
        RestNodeModel file1Model1 = ((Node)this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        file1Model1.assertThat().field("isLocked").is((Object)false);
        Step.STEP((String)"3. Lock the file using mode PERSISTENT with user1 (POST nodes/{nodeId}/lock).");
        RestNodeLockBodyModel lockBodyModel = new RestNodeLockBodyModel();
        lockBodyModel.setLifetime("PERSISTENT");
        lockBodyModel.setTimeToExpire(20);
        ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include?isLocked"})).lockNode(lockBodyModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        Step.STEP((String)"4. Verify with user1 that the file is locked.");
        RestNodeModel file1Model2 = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).getNode();
        file1Model2.assertThat().field("isLocked").is((Object)true);
        Step.STEP((String)"5. Cannot unlock the file with user2 while the file is still locked");
        ((Node)this.restClient.authenticateUser(this.user2).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).unlockNode();
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY).containsSummary(RestErrorModel.PERMISSION_WAS_DENIED).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
        Step.STEP((String)"6. Unlock the file with user1 while the file is still locked");
        RestNodeModel file1Model3 = ((Node)this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.file1).usingParams(new String[]{"include=isLocked"})).unlockNode();
        file1Model3.assertThat().field("isLocked").is((Object)false);
    }
}

