/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.exception.JsonToModelConversionException;
import org.alfresco.rest.model.RestProcessDefinitionModel;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.rest.model.RestProcessModelsCollection;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.Test;

public class AddProcessCoreTests
extends RestTest {
    private UserModel assignee;
    private UserModel adminUser;
    private RestProcessModel addedProcess;
    private RestProcessModelsCollection processes;
    private RestProcessDefinitionModel processDefinition;

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify non network admin is able to start new process using REST API and status code is OK (200)")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void nonNetworkAdminUserStartsNewProcess() throws JsonToModelConversionException, Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.addedProcess = this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestProcessModel)this.addedProcess.assertThat().field("id").is((Object)this.addedProcess.getId())).and().field("startUserId").is((Object)this.adminUser.getUsername());
        this.processDefinition = this.restClient.authenticateUser(this.adminUser).withWorkflowAPI().getAllProcessDefinitions().getProcessDefinitionByKey("activitiAdhoc");
        this.processes = this.restClient.withWorkflowAPI().getProcesses();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)this.processes.assertThat().entriesListContains("id", this.addedProcess.getId())).assertThat().entriesListContains("processDefinitionId", this.processDefinition.getId())).assertThat().entriesListContains("startUserId", this.adminUser.getUsername())).assertThat().entriesListContains("startActivityId", "start")).assertThat().entriesListContains("completed", "false")).assertThat().entriesListContains("processDefinitionKey", "activitiAdhoc");
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify start new process with empty request body using REST API returns status code is Bad Request (400)")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void startNewProcessWithEmptyProcessBody() throws JsonToModelConversionException, Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(this.adminUser).withWorkflowAPI();
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)"", (String)"processes", (String[])new String[0]);
        this.restClient.processModel(RestProcessModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @Bug(id="REPO-1936")
    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify start new process with invalid request body using REST API returns status code is Bad Request (400)")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void startNewProcessWithInvalidProcessDefInProcessBody() throws JsonToModelConversionException, Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(this.adminUser).withWorkflowAPI();
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)"{\"processDefinitionKey\":\"activitiAdhoc\"}", (String)"processes", (String[])new String[0]);
        this.restClient.processModel(RestProcessModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify start new process with invalid request body using REST API returns status code is Bad Request (400)")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void startNewProcessWithInvalidVariablesInProcessBody1() throws JsonToModelConversionException, Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(this.adminUser).withWorkflowAPI();
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)"{\"variables\":{\"bpm_sendEMailNotifications\":false}}", (String)"processes", (String[])new String[0]);
        this.restClient.processModel(RestProcessModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Either processDefinitionId or processDefinitionKey is required");
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify start new process with invalid request body using REST API returns status code is Bad Request (400)")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void startNewProcessWithInvalidVariablesInProcessBody2() throws JsonToModelConversionException, Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(this.adminUser).withWorkflowAPI();
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)"{\"variables\":{\"bpm_assignee\":\"admin\"}}", (String)"processes", (String[])new String[0]);
        this.restClient.processModel(RestProcessModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Either processDefinitionId or processDefinitionKey is required");
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify start new process with invalid request body using REST API returns status code is Bad Request (400)")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void startNewProcessWithInvalidVariablesInProcessBody3() throws JsonToModelConversionException, Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(this.adminUser).withWorkflowAPI();
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)"{\"variables\":{\"bpm_workflowPriority\":2}}", (String)"processes", (String[])new String[0]);
        this.restClient.processModel(RestProcessModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary("Either processDefinitionId or processDefinitionKey is required");
    }
}

