/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.favorites;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.model.RestCommentModel;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestFavoriteSiteModel;
import org.alfresco.rest.model.RestPersonFavoritesModel;
import org.alfresco.rest.model.RestPersonFavoritesModelsCollection;
import org.alfresco.rest.model.RestSiteModel;
import org.alfresco.rest.model.RestTagModel;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataLink;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.LinkModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AddFavoriteSiteTests
extends RestTest {
    private UserModel userModel;
    private UserModel adminUser;
    private SiteModel publicSite;
    private SiteModel privateSite;
    private SiteModel moderatedSite;
    private FileModel document;
    private FolderModel folder;
    private RestFavoriteSiteModel restFavoriteSiteModel;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userModel = this.dataUser.createRandomTestUser();
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.privateSite = ((DataSite)this.dataSite.usingUser(this.userModel)).createPrivateRandomSite();
        this.moderatedSite = ((DataSite)this.dataSite.usingUser(this.userModel)).createModeratedRandomSite();
        this.document = ((DataContent)this.dataContent.usingSite(this.publicSite)).usingUser(this.adminUser).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.folder = ((DataContent)this.dataContent.usingSite(this.publicSite)).usingUser(this.adminUser).createFolder();
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify manager user add a favorite site with Rest API and response is successful (201)")
    public void managerUserAddFavoriteSiteWithSuccess() throws Exception {
        UserModel managerUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(managerUser, this.publicSite, UserRole.SiteManager);
        this.restFavoriteSiteModel = this.restClient.authenticateUser(managerUser).withCoreAPI().usingUser(managerUser).addFavoriteSite(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restFavoriteSiteModel.assertThat().field("id").is((Object)this.publicSite.getId());
        this.restClient.withCoreAPI().usingUser(managerUser).addFavoriteSite(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CONFLICT);
        this.restClient.assertLastError().containsSummary(String.format("%s is already a favourite site", this.publicSite.getId()));
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify a manager user is NOT Authorized to add a favorite site with Rest API when authentication fails (401)")
    public void managerUserNotAuthorizedFailsToAddFavoriteSite() throws Exception {
        UserModel managerUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(managerUser, this.publicSite, UserRole.SiteManager);
        managerUser.setPassword("newpassword");
        this.restClient.authenticateUser(managerUser).withCoreAPI().usingAuthUser().addFavoriteSite(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify collaborator user add a favorite site with Rest API and response is successful (201)")
    public void collaboratorUserAddFavoriteSiteWithSuccess() throws Exception {
        UserModel collaboratorUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(collaboratorUser, this.publicSite, UserRole.SiteCollaborator);
        this.restFavoriteSiteModel = this.restClient.authenticateUser(collaboratorUser).withCoreAPI().usingAuthUser().addFavoriteSite(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restFavoriteSiteModel.assertThat().field("id").is((Object)this.publicSite.getId());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor user add a favorite site with Rest API and response is successful (201)")
    public void contributorUserAddFavoriteSiteWithSuccess() throws Exception {
        UserModel contributorUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(contributorUser, this.publicSite, UserRole.SiteContributor);
        this.restFavoriteSiteModel = this.restClient.authenticateUser(contributorUser).withCoreAPI().usingAuthUser().addFavoriteSite(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restFavoriteSiteModel.assertThat().field("id").is((Object)this.publicSite.getId());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify consumer user add a favorite site with Rest API and response is successful (201)")
    public void consumerUserAddFavoriteSiteWithSuccess() throws Exception {
        UserModel consumerUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(consumerUser, this.publicSite, UserRole.SiteConsumer);
        this.restFavoriteSiteModel = this.restClient.authenticateUser(consumerUser).withCoreAPI().usingAuthUser().addFavoriteSite(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restFavoriteSiteModel.assertThat().field("id").is((Object)this.publicSite.getId());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user add a favorite site with Rest API and response is successful (201)")
    public void adminUserAddFavoriteSiteWithSuccess() throws Exception {
        this.restFavoriteSiteModel = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingAuthUser().addFavoriteSite(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restFavoriteSiteModel.assertThat().field("id").is((Object)this.publicSite.getId());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify manager user is not able to add a favorite site when the site is already favorite - status code (409)")
    public void managerUserAddFavoriteSiteAlreadyAFavoriteSite() throws Exception {
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        UserModel managerUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(managerUser, this.publicSite, UserRole.SiteManager);
        this.restClient.authenticateUser(managerUser).withCoreAPI().usingAuthUser().addFavoriteSite(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withCoreAPI().usingUser(managerUser).addFavoriteSite(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CONFLICT);
        this.restClient.assertLastError().containsSummary(String.format("%s is already a favourite site", this.publicSite.getId())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE).containsErrorKey(String.format("Site %s is already a favourite site", this.publicSite.getId()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user doesn't have permission to delete favorites of admin user with Rest API and status code is 403")
    public void userIsNotAbleToAddFavoriteSiteOfAnotherUser() throws Exception {
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        UserModel contributorUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(contributorUser, this.publicSite, UserRole.SiteContributor);
        UserModel consumerUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(consumerUser, this.publicSite, UserRole.SiteConsumer);
        this.restClient.authenticateUser(consumerUser).withCoreAPI().usingUser(contributorUser).addFavoriteSite(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify manager user is able to add as favorite a private site.")
    public void managerAddsPrivateSiteAsFavorite() throws Exception {
        UserModel managerUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(managerUser, this.privateSite, UserRole.SiteManager);
        this.restClient.authenticateUser(managerUser).withCoreAPI().usingUser(managerUser).addFavoriteSite(this.privateSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestPersonFavoritesModelsCollection favorites = this.restClient.withCoreAPI().usingAuthUser().getFavorites();
        ((RestModels)favorites.assertThat().entriesListContains("targetGuid", this.privateSite.getGuidWithoutVersion())).and().paginationField("totalItems").is("1");
        ((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestPersonFavoritesModel)favorites.getOneRandomEntry()).onModel().getTarget().getSite().assertThat().field("description").is((Object)this.privateSite.getDescription())).and().field("id").is((Object)this.privateSite.getId())).and().field("visibility").is((Object)this.privateSite.getVisibility().toString())).and().field("title").is((Object)this.privateSite.getTitle());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify manager user is able to add as favorite a moderated site.")
    public void managerAddsModeratedSiteAsFavorite() throws Exception {
        UserModel managerUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(managerUser, this.moderatedSite, UserRole.SiteManager);
        this.restClient.authenticateUser(managerUser).withCoreAPI().usingUser(managerUser).addFavoriteSite(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestPersonFavoritesModelsCollection favorites = this.restClient.withCoreAPI().usingAuthUser().getFavorites();
        ((RestModels)favorites.assertThat().entriesListContains("targetGuid", this.moderatedSite.getGuidWithoutVersion())).and().paginationField("totalItems").is("1");
        ((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestPersonFavoritesModel)favorites.getOneRandomEntry()).onModel().getTarget().getSite().assertThat().field("description").is((Object)this.moderatedSite.getDescription())).and().field("id").is((Object)this.moderatedSite.getId())).and().field("visibility").is((Object)this.moderatedSite.getVisibility().toString())).and().field("title").is((Object)this.moderatedSite.getTitle());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user removes a site from favorites using '-me-' in place of personId with Rest API and response is successful (201)")
    public void addFavoriteSiteWithSuccessUsingMeAsPersonId() throws Exception {
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingMe().addFavoriteSite(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify manager user removes a site from its favorites and adds it again and response is successful (204)")
    public void managerUserRemovesFavoriteSiteAndAddItAgain() throws Exception {
        UserModel managerUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(managerUser, this.publicSite, UserRole.SiteManager);
        ((DataSite)((DataSite)this.dataSite.usingUser(managerUser)).usingSite(this.publicSite)).addSiteToFavorites();
        this.restClient.authenticateUser(managerUser).withCoreAPI().usingAuthUser().removeFavoriteSite(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingUser(managerUser).addSiteToFavorites(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @Bug(id="ACE-2413")
    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify empty user is not able to add a site from favorites and response is (400)")
    public void emptyUserIsNotAbleToRemoveFavoriteSite() throws Exception {
        UserModel emptyUser = new UserModel("", "password");
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingUser(emptyUser).addFavoriteSite(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "emptyUser"));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify inexistent user is not able to add a site from favorites and response is (404)")
    public void inexistentUserIsNotAbleToRemoveFavoriteSite() throws Exception {
        UserModel inexistentUser = new UserModel("inexistentUser", "password");
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingUser(inexistentUser).addFavoriteSite(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "inexistentUser")).containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Bug(id="REPO-1827")
    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user is not able to add a favorite site when the 'id' is empty - status code (400)")
    public void userAddFavoriteSiteWithEmptySiteId() throws Exception {
        this.publicSite.setId("");
        this.restClient.authenticateUser(this.userModel).withCoreAPI().usingAuthUser().addFavoriteSite(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST);
        this.restClient.assertLastError().containsSummary("siteId is null").descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE).containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user doesn't have permission to add a favorite site of another user with Rest API and status code is 403")
    public void adminIsNotAbleToAddFavoriteSiteOfAnotherUser() throws Exception {
        UserModel collaboratorUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(collaboratorUser, this.publicSite, UserRole.SiteCollaborator);
        this.restClient.authenticateUser(collaboratorUser).withCoreAPI().usingUser(this.adminUser).addFavoriteSite(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Bug(id="MNT-17338")
    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user doesn't have permission to add a favorite site of another user with Rest API and status code is 403")
    public void userIsNotAbleToAddFavoriteSiteOfAdmin() throws Exception {
        UserModel consumerUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(consumerUser, this.publicSite, UserRole.SiteConsumer);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingUser(consumerUser).addFavoriteSite(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify add favorite site using empty body - status code is 400")
    public void addFavoriteSiteWithEmptyBody() throws Exception {
        this.restClient.authenticateUser(this.adminUser).withCoreAPI();
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)"{\"ids\": \"local\"}", (String)"people/{personId}/favorite-sites", (String[])new String[]{this.adminUser.getUsername()});
        this.restClient.processModel(RestPersonFavoritesModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.NO_CONTENT, "Unrecognized field \"ids\""));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify add favorite site using empty body - status code is 400")
    public void addFavoriteSiteWithEmptyRequiredFieldsBody() throws Exception {
        this.restClient.authenticateUser(this.adminUser).withCoreAPI();
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)"{\"\": \"\"}", (String)"people/{personId}/favorite-sites", (String[])new String[]{this.adminUser.getUsername()});
        this.restClient.processModel(RestPersonFavoritesModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.NO_CONTENT, "Unrecognized field \"\""));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify non member user is not able to add a private favorite site - status code is 404")
    public void userAddFavoriteSiteUserNotMemberOfPrivateSite() throws Exception {
        UserModel user = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        this.restClient.authenticateUser(user).withCoreAPI().usingAuthUser().addFavoriteSite(this.privateSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.privateSite.getId())).containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify non member user is able to add a moderated favorite site")
    public void userAddFavoriteSiteUserNotMemberOfModeratedSite() throws Exception {
        UserModel user = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        this.restClient.authenticateUser(user).withCoreAPI().usingAuthUser().addFavoriteSite(this.moderatedSite);
        RestPersonFavoritesModelsCollection favorites = this.restClient.withCoreAPI().usingAuthUser().getFavorites();
        ((RestModels)favorites.assertThat().entriesListContains("targetGuid", this.moderatedSite.getGuidWithoutVersion())).and().paginationField("totalItems").is("1");
        ((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestPersonFavoritesModel)favorites.getOneRandomEntry()).onModel().getTarget().getSite().assertThat().field("description").is((Object)this.moderatedSite.getDescription())).and().field("id").is((Object)this.moderatedSite.getId())).and().field("visibility").is((Object)this.moderatedSite.getVisibility().toString())).and().field("title").is((Object)this.moderatedSite.getTitle());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify non member user is able to add a public favorite site")
    public void userAddFavoriteSiteUserNotMemberOfPublicSite() throws Exception {
        UserModel user = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        this.restFavoriteSiteModel = this.restClient.authenticateUser(user).withCoreAPI().usingAuthUser().addFavoriteSite(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restFavoriteSiteModel.assertThat().field("id").is((Object)this.publicSite.getId());
        RestPersonFavoritesModelsCollection favorites = this.restClient.withCoreAPI().usingAuthUser().getFavorites();
        ((RestModels)favorites.assertThat().entriesListContains("targetGuid", this.publicSite.getGuidWithoutVersion())).and().paginationField("totalItems").is("1");
        ((RestSiteModel)((RestSiteModel)((RestSiteModel)((RestPersonFavoritesModel)favorites.getOneRandomEntry()).onModel().getTarget().getSite().assertThat().field("description").is((Object)this.publicSite.getDescription())).and().field("id").is((Object)this.publicSite.getId())).and().field("visibility").is((Object)this.publicSite.getVisibility().toString())).and().field("title").is((Object)this.publicSite.getTitle());
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Check that if id does not exist, status code is 404")
    public void addFavoriteSiteUsingInvalidId() throws Exception {
        SiteModel site = ((DataSite)this.dataSite.usingUser(this.adminUser)).createPublicRandomSite();
        String id = this.publicSite.getId();
        site.setId("invalidID");
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingAuthUser().addFavoriteSite(site);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "invalidID"));
        this.publicSite.setId(id);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Check that if user provides site in id but id is of a file status code is 404")
    public void addSiteToFavoritesUsingFileId() throws Exception {
        String id = this.publicSite.getId();
        this.publicSite.setId(this.document.getNodeRefWithoutVersion());
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingAuthUser().addFavoriteSite(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.document.getNodeRefWithoutVersion()));
        this.publicSite.setId(id);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Check that if user provides site in id but id is of a folder status code is 404")
    public void addSiteToFavoritesUsingFolderId() throws Exception {
        String id = this.publicSite.getId();
        this.publicSite.setId(this.folder.getNodeRefWithoutVersion());
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingAuthUser().addFavoriteSite(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.folder.getNodeRefWithoutVersion()));
        this.publicSite.setId(id);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Check that if user provides site in id but id is of a comment status code is 404")
    public void addSiteToFavoriteUsingCommentId() throws Exception {
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        String id = this.publicSite.getId();
        FileModel file = ((DataContent)this.dataContent.usingSite(this.publicSite)).usingUser(this.adminUser).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        RestCommentModel comment = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)file).addComment("This is a comment");
        file.setNodeRef(comment.getId());
        this.publicSite.setId(comment.getId());
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingAuthUser().addFavoriteSite(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
        this.publicSite.setId(id);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Check that if user provides site in id but id is of a tag status code is 404")
    public void addSiteFavoriteUsingTagId() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingSite(this.publicSite)).usingUser(this.adminUser).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        RestTagModel returnedModel = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingResource((RepoTestModel)file).addTag("random_tag");
        file.setNodeRef(returnedModel.getId());
        this.publicSite.setId(returnedModel.getId());
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingAuthUser().addFavoriteSite(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, returnedModel.getId()));
    }

    @Test(groups={"rest-api", "favorites", "regression"})
    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Check that if id does not describe a site, file, or folder status code is 400")
    public void addFavoriteUsingInvalidGuid() throws Exception {
        LinkModel link = ((DataLink)((DataLink)this.dataLink.usingAdmin()).usingSite(this.publicSite)).createRandomLink();
        SiteModel site = ((DataSite)this.dataSite.usingUser(this.adminUser)).createPublicRandomSite();
        site.setId(link.getNodeRef());
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingAuthUser().addFavoriteSite(site);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, site.getId().split("/")[3]));
    }
}

