/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.sites.members;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestSiteMemberModel;
import org.alfresco.rest.model.RestSiteMemberModelsCollection;
import org.alfresco.rest.requests.Site;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.GroupModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetSiteMembersTests
extends RestTest {
    private SiteModel publicSite;
    private SiteModel privateSite;
    private SiteModel moderatedSite;
    private SiteModel moderatedSite2;
    private SiteModel moderatedSite3;
    private SiteModel moderatedSite4;
    private RestSiteMemberModelsCollection siteMembers;
    private DataUser.ListUserWithRoles usersWithRoles;
    private DataUser.ListUserWithRoles moderatedSiteUsers;
    private UserModel regularUser;
    private UserModel privateSiteConsumer;
    private UserModel siteCreator;
    private RestSiteMemberModel firstSiteMember;
    private RestSiteMemberModel secondSiteMember;
    private RestSiteMemberModel thirdSiteMember;
    private RestSiteMemberModel fourthSiteMember;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.siteCreator = this.dataUser.createRandomTestUser();
        this.regularUser = this.dataUser.createRandomTestUser();
        this.privateSiteConsumer = this.dataUser.createRandomTestUser();
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.siteCreator)).createPublicRandomSite();
        this.privateSite = ((DataSite)this.dataSite.usingUser(this.siteCreator)).createPrivateRandomSite();
        this.moderatedSite = ((DataSite)this.dataSite.usingUser(this.siteCreator)).createModeratedRandomSite();
        this.moderatedSite2 = ((DataSite)this.dataSite.usingUser(this.siteCreator)).createModeratedRandomSite();
        this.moderatedSite3 = ((DataSite)this.dataSite.usingUser(this.siteCreator)).createModeratedRandomSite();
        this.moderatedSite4 = ((DataSite)this.dataSite.usingUser(this.siteCreator)).createModeratedRandomSite();
        this.dataUser.addUserToSite(this.privateSiteConsumer, this.privateSite, UserRole.SiteConsumer);
        this.dataUser.addUserToSite(this.privateSiteConsumer, this.moderatedSite3, UserRole.SiteConsumer);
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.publicSite, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        this.moderatedSiteUsers = this.dataUser.addUsersWithRolesToSite(this.moderatedSite, new UserRole[]{UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        this.siteMembers = ((Site)this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.moderatedSite).usingParams(new String[]{"properties=role,id"})).getSiteMembers();
        this.firstSiteMember = ((RestSiteMemberModel)this.siteMembers.getEntries().get(0)).onModel();
        this.secondSiteMember = ((RestSiteMemberModel)this.siteMembers.getEntries().get(1)).onModel();
        this.thirdSiteMember = ((RestSiteMemberModel)this.siteMembers.getEntries().get(2)).onModel();
        this.fourthSiteMember = ((RestSiteMemberModel)this.siteMembers.getEntries().get(3)).onModel();
    }

    @Test(groups={"rest-api", "sites", "sanity"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.SANITY}, description="Verify user with Manager role gets site members and gets status code OK (200)")
    public void getSiteMembersWithManagerRole() throws Exception {
        ((RestModels)((RestModels)this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingSite(this.publicSite).getSiteMembers().assertThat().entriesListIsNotEmpty()).and().entriesListContains("id", this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager).getUsername())).and().entriesListContains("role", this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager).getUserRole().toString());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Collaborator role gets site members and gets status code OK (200)")
    public void getSiteMembersWithCollaboratorRole() throws Exception {
        ((RestModels)((RestModels)this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingSite(this.publicSite).getSiteMembers().assertThat().entriesListIsNotEmpty()).assertThat().entriesListContains("id", this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator).getUsername())).and().entriesListContains("role", this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator).getUserRole().toString());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Contributor role gets site members and gets status code OK (200)")
    public void getSiteMembersWithContributorRole() throws Exception {
        ((RestModels)((RestModels)this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingSite(this.publicSite).getSiteMembers().assertThat().entriesListIsNotEmpty()).and().entriesListContains("id", this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor).getUsername())).and().entriesListContains("role", this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor).getUserRole().toString());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with Consumer role gets site members and gets status code OK (200)")
    public void getSiteMembersWithConsumerRole() throws Exception {
        ((RestModels)((RestModels)this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingSite(this.publicSite).getSiteMembers().assertThat().entriesListIsNotEmpty()).and().entriesListContains("id", this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer).getUsername())).and().entriesListContains("role", this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer).getUserRole().toString());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify user with admin usere gets site members and gets status code OK (200)")
    public void getSiteMembersWithAdminUser() throws Exception {
        ((RestSiteMemberModelsCollection)((RestModels)((RestModels)this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingSite(this.publicSite).getSiteMembers().assertThat().entriesListIsNotEmpty()).and().entriesListContains("id", this.siteCreator.getUsername())).when()).assertThat().entriesListContains("role", "SiteManager");
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "sanity"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.SANITY}, description="Failed authentication get site members call returns status code 401")
    public void unauthenticatedUserIsNotAuthorizedToRetrieveSiteMembers() throws Exception {
        UserModel userModel = this.dataUser.createRandomTestUser();
        userModel.setPassword("user wrong password");
        this.dataUser.addUserToSite(userModel, this.publicSite, UserRole.SiteManager);
        this.restClient.authenticateUser(userModel).withCoreAPI().usingSite(this.publicSite).getSiteMembers();
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify get site members call returns status code 404 if siteId does not exist")
    public void checkStatusCodeForNonExistentSiteId() throws Exception {
        this.restClient.authenticateUser(this.regularUser).withCoreAPI().usingSite("NonExistentSiteId").getSiteMembers();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "NonExistentSiteId"));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify get site members call returns status code 400 for invalid maxItems")
    public void checkStatusCodeForInvalidMaxItems() throws Exception {
        this.restClient.authenticateUser(this.regularUser).withParams(new String[]{"maxItems=0"}).withCoreAPI().usingSite(this.publicSite).getSiteMembers();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS).containsErrorKey(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
        this.restClient.withParams(new String[]{"maxItems=A"}).withCoreAPI().usingSite(this.publicSite).getSiteMembers();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_MAXITEMS, "A"));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify get site members call returns status code 400 for invalid skipCount ")
    public void checkStatusCodeForInvalidSkipCount() throws Exception {
        this.restClient.authenticateUser(this.regularUser).withParams(new String[]{"skipCount=A"}).withCoreAPI().usingSite(this.publicSite).getSiteMembers();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_SKIPCOUNT, "A"));
        this.restClient.withParams(new String[]{"skipCount=-1"}).withCoreAPI().usingSite(this.publicSite).getSiteMembers();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.NEGATIVE_VALUES_SKIPCOUNT);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if any user gets public site members and status code is 200")
    public void getPublicSiteMembers() throws Exception {
        this.siteMembers = this.restClient.authenticateUser(this.regularUser).withCoreAPI().usingSite(this.publicSite).getSiteMembers();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)this.siteMembers.assertThat().entriesListContains("id", this.siteCreator.getUsername())).and().entriesListContains("id", this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer).getUsername())).and().entriesListContains("id", this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor).getUsername())).and().entriesListContains("id", this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator).getUsername())).and().entriesListContains("id", this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager).getUsername())).and().paginationField("count").is("5");
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if any user gets moderated site members and status code is 200")
    public void getModeratedSiteMembers() throws Exception {
        this.siteMembers = this.restClient.authenticateUser(this.regularUser).withCoreAPI().usingSite(this.moderatedSite).getSiteMembers();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)((RestModels)this.siteMembers.assertThat().entriesListContains("id", this.siteCreator.getUsername())).and().entriesListContains("id", this.moderatedSiteUsers.getOneUserWithRole(UserRole.SiteCollaborator).getUsername())).and().entriesListContains("id", this.moderatedSiteUsers.getOneUserWithRole(UserRole.SiteContributor).getUsername())).and().entriesListContains("id", this.moderatedSiteUsers.getOneUserWithRole(UserRole.SiteConsumer).getUsername())).and().paginationField("count").is("4");
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if user gets private site members if he is a member of that site and status code is 200")
    public void getPrivateSiteMembersByASiteMember() throws Exception {
        this.siteMembers = this.restClient.authenticateUser(this.privateSiteConsumer).withCoreAPI().usingSite(this.privateSite).getSiteMembers();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.siteMembers.assertThat().entriesListContains("id", this.siteCreator.getUsername())).and().entriesListContains("id", this.privateSiteConsumer.getUsername())).and().paginationField("count").is("2");
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if user doesn't get private site members if he is not a member of that site and status code is 404")
    public void getPrivateSiteMembersByNotASiteMember() throws Exception {
        this.restClient.authenticateUser(this.regularUser).withCoreAPI().usingSite(this.privateSite).getSiteMembers();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, this.privateSite.getTitle()));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if user gets moderated site members after the adding of a new member and status code is 200")
    public void getSiteMembersAfterAddingNewMember() throws Exception {
        this.siteMembers = this.restClient.authenticateUser(this.regularUser).withCoreAPI().usingSite(this.moderatedSite2).getSiteMembers();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.siteMembers.assertThat().entriesListContains("id", this.siteCreator.getUsername())).and().paginationField("count").is("1");
        this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.moderatedSite2).addPerson(this.privateSiteConsumer);
        this.siteMembers = this.restClient.authenticateUser(this.regularUser).withCoreAPI().usingSite(this.moderatedSite2).getSiteMembers();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.siteMembers.assertThat().entriesListContains("id", this.siteCreator.getUsername())).and().entriesListContains("id", this.privateSiteConsumer.getUsername())).and().paginationField("count").is("2");
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if any user gets moderated site members with properties parameter applied and status code is 200")
    public void getModeratedSiteMembersUsingPropertiesParameter() throws Exception {
        this.siteMembers = ((Site)this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.moderatedSite).usingParams(new String[]{"properties=role,id"})).getSiteMembers();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)this.siteMembers.assertThat().entriesListCountIs(4)).and().entriesListDoesNotContain("person")).and().entriesListContains("role", UserRole.SiteManager.toString())).and().entriesListContains("id", this.siteCreator.getUsername())).and().entriesListContains("role", UserRole.SiteContributor.toString())).and().entriesListContains("id", this.moderatedSiteUsers.getOneUserWithRole(UserRole.SiteContributor).getUsername())).and().entriesListContains("role", UserRole.SiteCollaborator.toString())).and().entriesListContains("id", this.moderatedSiteUsers.getOneUserWithRole(UserRole.SiteCollaborator).getUsername())).and().entriesListContains("role", UserRole.SiteConsumer.toString())).and().entriesListContains("id", this.moderatedSiteUsers.getOneUserWithRole(UserRole.SiteConsumer).getUsername());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if any user gets moderated site members with skipCount parameter applied")
    public void getModeratedSiteMembersUsingSkipCountParameter() throws Exception {
        this.siteMembers = ((Site)this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.moderatedSite).usingParams(new String[]{"skipCount=2"})).getSiteMembers();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.siteMembers.assertThat().paginationField("count").is("2");
        this.siteMembers.assertThat().paginationField("skipCount").is("2");
        ((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)this.siteMembers.assertThat().entriesListDoesNotContain("id", this.firstSiteMember.getId())).and().entriesListDoesNotContain("id", this.secondSiteMember.getId())).and().entriesListContains("role", this.thirdSiteMember.getRole().toString())).and().entriesListContains("id", this.thirdSiteMember.getId())).and().entriesListContains("role", this.fourthSiteMember.getRole().toString())).and().entriesListContains("id", this.fourthSiteMember.getId());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if any user gets moderated site members with high skipCount parameter applied")
    public void getModeratedSiteMembersUsingHighSkipCountParameter() throws Exception {
        this.siteMembers = ((Site)this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.moderatedSite).usingParams(new String[]{"skipCount=100"})).getSiteMembers();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.siteMembers.assertThat().paginationField("count").is("0");
        this.siteMembers.assertThat().paginationField("skipCount").is("100");
        this.siteMembers.assertThat().entriesListIsEmpty();
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if any user gets moderated site members with maxItems parameter applied and check all pagination fields")
    public void getModeratedSiteMembersUsingMaxItemsParameter() throws Exception {
        this.siteMembers = ((Site)this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.moderatedSite).usingParams(new String[]{"maxItems=1"})).getSiteMembers();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.siteMembers.assertThat().paginationField("count").is("1");
        this.siteMembers.assertThat().paginationField("hasMoreItems").is("true");
        this.siteMembers.assertThat().paginationField("maxItems").is("1");
        this.siteMembers.assertThat().paginationField("totalItems").is("4");
        ((RestModels)((RestModels)((RestModels)this.siteMembers.assertThat().entriesListContains("id", this.firstSiteMember.getId())).and().entriesListContains("role", this.firstSiteMember.getRole().toString())).and().entriesListDoesNotContain("id", this.secondSiteMember.getId())).and().entriesListDoesNotContain("id", this.thirdSiteMember.getId());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if user gets moderated site members with member not joined yet and status code is 200")
    public void getSiteMembersFromNotJoinedModeratedSite() throws Exception {
        UserModel userNotJoined = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(userNotJoined).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite2);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.siteMembers = this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.moderatedSite2).getSiteMembers();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.siteMembers.assertThat().entriesListContains("id", this.siteCreator.getUsername())).and().entriesListDoesNotContain("id", userNotJoined.getUsername());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if any user gets site members after the member was removed from site and status code is 200")
    public void getSiteMembersAfterRemovingASiteMember() throws Exception {
        this.siteMembers = this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.moderatedSite3).getSiteMembers();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.siteMembers.assertThat().entriesListCountIs(2);
        this.restClient.withCoreAPI().usingSite(this.moderatedSite3).deleteSiteMember(this.privateSiteConsumer);
        this.siteMembers = this.restClient.withCoreAPI().usingSite(this.moderatedSite3).getSiteMembers();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.siteMembers.assertThat().entriesListCountIs(1)).and().entriesListContains("role", UserRole.SiteManager.toString())).and().entriesListContains("id", this.siteCreator.getUsername());
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if isMemberOfGroup if user part of the group")
    public void verifyIsMemberOfGroupProps() throws Exception {
        GroupModel firstGroup = this.dataGroup.createRandomGroup();
        UserModel user = this.dataUser.createRandomTestUser();
        this.dataGroup.addListOfUsersToGroup(firstGroup, new UserModel[]{user});
        this.siteMembers = this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.moderatedSite4).getSiteMembers();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.siteMembers.assertThat().entriesListCountIs(1);
        this.restClient.withCoreAPI().usingSite(this.moderatedSite4).addSiteGroup("GROUP_" + firstGroup.getGroupIdentifier(), UserRole.SiteCollaborator);
        this.siteMembers = this.restClient.withCoreAPI().usingSite(this.moderatedSite4).getSiteMembers();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.siteMembers.assertThat().entriesListCountIs(2);
        ((RestSiteMemberModel)this.siteMembers.getEntryByIndex(0)).assertThat().field("isMemberOfGroup").isNotNull();
        ((RestSiteMemberModel)this.siteMembers.getEntryByIndex(1)).assertThat().field("isMemberOfGroup").isNotNull();
        this.siteMembers = ((Site)this.restClient.withCoreAPI().usingSite(this.moderatedSite4).usingParams(new String[]{"where=(isMemberOfGroup=false)"})).getSiteMembers();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.siteMembers.assertThat().entriesListCountIs(1);
        ((RestSiteMemberModel)this.siteMembers.getEntries().get(0)).assertThat().field("isMemberOfGroup").is((Object)false);
    }
}

