/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.actions.access;

import io.restassured.response.ValidatableResponse;
import java.io.Serializable;
import java.util.Map;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.actions.access.AccessRestrictionUtil;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestResponse;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.utility.model.UserModel;
import org.hamcrest.Matchers;
import org.json.simple.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FormProcAdminAccessRestrictionTest
extends RestTest {
    private static final String ACTION_FORM_PROCESSOR_ENDPOINT = "alfresco/service/api/action/%s/formprocessor";
    private static final String PROPERTY_PREFIX = "prop_";
    private UserModel adminUser;
    private UserModel testUser;
    @Autowired
    protected RestWrapper restClient;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.testUser = this.dataUser.createRandomTestUser();
    }

    @BeforeMethod(alwaysRun=true)
    public void setup() {
        this.restClient.configureRequestSpec().setBasePath("").addHeader("Content-Type", "application/json");
    }

    @Test
    public void userShouldNotCreateAMailForm() {
        this.restClient.authenticateUser(this.testUser);
        String body = this.generateBody(AccessRestrictionUtil.createMailParameters(this.adminUser, this.testUser));
        String endpoint = String.format(ACTION_FORM_PROCESSOR_ENDPOINT, "mail");
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)body, (String)endpoint, (String[])new String[0]);
        RestResponse response = this.restClient.process(request);
        ((ValidatableResponse)((ValidatableResponse)response.assertThat().statusCode(HttpStatus.INTERNAL_SERVER_ERROR.value())).assertThat()).body("message", Matchers.containsString((String)"Only admin or system user is allowed to define uses of or directly execute this action"), new Object[0]);
    }

    @Test
    public void adminShouldCreateAMailForm() {
        this.restClient.authenticateUser(this.adminUser);
        String body = this.generateBody(AccessRestrictionUtil.createMailParameters(this.adminUser, this.testUser));
        String endpoint = String.format(ACTION_FORM_PROCESSOR_ENDPOINT, "mail");
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)body, (String)endpoint, (String[])new String[0]);
        RestResponse response = this.restClient.process(request);
        ((ValidatableResponse)((ValidatableResponse)response.assertThat().statusCode(HttpStatus.INTERNAL_SERVER_ERROR.value())).assertThat()).body("message", Matchers.containsString((String)AccessRestrictionUtil.getExpectedEmailSendFailureMessage(this.testUser)), new Object[0]);
    }

    private String generateBody(Map<String, Serializable> mailParameters) {
        JSONObject json = new JSONObject();
        mailParameters.forEach((key, value) -> json.put((Object)(PROPERTY_PREFIX + key), value));
        return json.toJSONString();
    }
}

