/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.tasks.variables;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestVariableModel;
import org.alfresco.rest.model.RestVariableModelsCollection;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TaskModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AddTaskVariablesTestsBulk1
extends RestTest {
    private UserModel userModel;
    private UserModel userWhoStartsTask;
    private SiteModel siteModel;
    private FileModel fileModel;
    private UserModel assigneeUser;
    private TaskModel taskModel;
    private RestVariableModel restVariablemodel;
    private RestVariableModelsCollection restVariableCollection;
    private RestVariableModel variableModel;
    private RestVariableModel variableModel1;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userModel = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.fileModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.userWhoStartsTask = this.dataUser.createRandomTestUser();
        this.assigneeUser = this.dataUser.createRandomTestUser();
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assigneeUser);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Create non-existing task variable with admin")
    public void createTaskVariableWithAdmin() throws Exception {
        UserModel adminUser = this.dataUser.getAdminUser();
        this.restClient.authenticateUser(adminUser);
        RestVariableModel variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.restVariablemodel = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestVariableModel)((RestVariableModel)((RestVariableModel)this.restVariablemodel.assertThat().field("scope").is((Object)variableModel.getScope())).and().field("name").is((Object)variableModel.getName())).and().field("value").is(variableModel.getValue())).and().field("type").is((Object)variableModel.getType());
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Create non-existing task variable with admin")
    public void createMultipleTaskVariablesWithAdmin() throws Exception {
        UserModel adminUser = this.dataUser.getAdminUser();
        this.restClient.authenticateUser(adminUser);
        this.variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.variableModel1 = RestVariableModel.getRandomTaskVariableModel((String)"global", (String)"d:text");
        this.restVariableCollection = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariables(new RestVariableModel[]{this.variableModel, this.variableModel1});
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestVariableModel)((RestVariableModel)((RestVariableModel)((RestVariableModel)this.restVariableCollection.getEntries().get(0)).onModel().assertThat().field("scope").is((Object)this.variableModel.getScope())).and().field("name").is((Object)this.variableModel.getName())).and().field("value").is(this.variableModel.getValue())).and().field("type").is((Object)this.variableModel.getType());
        ((RestVariableModel)((RestVariableModel)((RestVariableModel)((RestVariableModel)this.restVariableCollection.getEntries().get(1)).onModel().assertThat().field("scope").is((Object)this.variableModel1.getScope())).and().field("name").is((Object)this.variableModel1.getName())).and().field("value").is(this.variableModel1.getValue())).and().field("type").is((Object)this.variableModel1.getType());
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Create non-existing task variable with user involved in the process")
    public void createTaskVariableWithInvolvedUser() throws Exception {
        this.restClient.authenticateUser(this.assigneeUser);
        RestVariableModel variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.restVariablemodel = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestVariableModel)((RestVariableModel)((RestVariableModel)this.restVariablemodel.assertThat().field("scope").is((Object)variableModel.getScope())).and().field("name").is((Object)variableModel.getName())).and().field("value").is(variableModel.getValue())).and().field("type").is((Object)variableModel.getType());
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).getTaskVariables().assertThat().entriesListContains("name", variableModel.getName());
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Create multiple non-existing task variable with involved user")
    public void createMultipleTaskVariableWithInvolvedUser() throws Exception {
        this.restClient.authenticateUser(this.assigneeUser);
        this.variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.variableModel1 = RestVariableModel.getRandomTaskVariableModel((String)"global", (String)"d:text");
        this.restVariableCollection = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariables(new RestVariableModel[]{this.variableModel, this.variableModel1});
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestVariableModel)((RestVariableModel)((RestVariableModel)((RestVariableModel)this.restVariableCollection.getEntries().get(0)).onModel().assertThat().field("scope").is((Object)this.variableModel.getScope())).and().field("name").is((Object)this.variableModel.getName())).and().field("value").is(this.variableModel.getValue())).and().field("type").is((Object)this.variableModel.getType());
        ((RestVariableModel)((RestVariableModel)((RestVariableModel)((RestVariableModel)this.restVariableCollection.getEntries().get(1)).onModel().assertThat().field("scope").is((Object)this.variableModel1.getScope())).and().field("name").is((Object)this.variableModel1.getName())).and().field("value").is(this.variableModel1.getValue())).and().field("type").is((Object)this.variableModel1.getType());
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Create non-existing task variable with task owner")
    public void createTaskVariableWithTaskOwner() throws Exception {
        this.restClient.authenticateUser(this.userWhoStartsTask);
        RestVariableModel variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.restVariablemodel = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestVariableModel)((RestVariableModel)((RestVariableModel)this.restVariablemodel.assertThat().field("scope").is((Object)variableModel.getScope())).and().field("name").is((Object)variableModel.getName())).and().field("value").is(variableModel.getValue())).and().field("type").is((Object)variableModel.getType());
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Create multiple non-existing task variable with task owner")
    public void createMultipleTaskVariableWithTaskOwner() throws Exception {
        this.restClient.authenticateUser(this.userWhoStartsTask);
        this.variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.variableModel1 = RestVariableModel.getRandomTaskVariableModel((String)"global", (String)"d:text");
        this.restVariableCollection = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariables(new RestVariableModel[]{this.variableModel, this.variableModel1});
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        ((RestVariableModel)((RestVariableModel)((RestVariableModel)((RestVariableModel)this.restVariableCollection.getEntries().get(0)).onModel().assertThat().field("scope").is((Object)this.variableModel.getScope())).and().field("name").is((Object)this.variableModel.getName())).and().field("value").is(this.variableModel.getValue())).and().field("type").is((Object)this.variableModel.getType());
        ((RestVariableModel)((RestVariableModel)((RestVariableModel)((RestVariableModel)this.restVariableCollection.getEntries().get(1)).onModel().assertThat().field("scope").is((Object)this.variableModel1.getScope())).and().field("name").is((Object)this.variableModel1.getName())).and().field("value").is(this.variableModel1.getValue())).and().field("type").is((Object)this.variableModel1.getType());
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Create non-existing task variable with any user")
    public void createTaskVariableWithRandomUser() throws Exception {
        this.userModel = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(this.userModel);
        RestVariableModel variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.restVariablemodel = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary("Permission was denied");
    }

    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Create multiple non-existing task variable with any user")
    public void createMultipleTaskVariableWithRandomUser() throws Exception {
        this.restClient.authenticateUser(this.userModel);
        this.variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.variableModel1 = RestVariableModel.getRandomTaskVariableModel((String)"global", (String)"d:text");
        this.restVariableCollection = this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariables(new RestVariableModel[]{this.variableModel, this.variableModel1});
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary("Permission was denied");
    }
}

