/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.comments;

import java.io.File;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestCommentModel;
import org.alfresco.rest.model.RestCommentModelsCollection;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestPaginationModel;
import org.alfresco.rest.requests.Node;
import org.alfresco.utility.Utility;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DeleteCommentTests
extends RestTest {
    private UserModel adminUserModel;
    private UserModel networkUserModel;
    private FileModel document;
    private SiteModel siteModel;
    private RestCommentModelsCollection comments;
    private RestCommentModel commentModel;
    private DataUser.ListUserWithRoles usersWithRoles;
    private String commentText = "This is a new comment";

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUserModel = this.dataUser.getAdminUser();
        this.networkUserModel = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(this.adminUserModel);
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createPublicRandomSite();
        this.document = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.siteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.SANITY}, description="Verify Admin user deletes comments with Rest API and status code is 204")
    @Test(groups={"rest-api", "comments", "sanity"})
    public void adminIsAbleToDeleteComments() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel);
        this.commentModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).addComment("This is a new comment");
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).deleteComment(this.commentModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.SANITY}, description="Verify User gets status code 401 if authentication call fails")
    @Test(groups={"rest-api", "comments", "sanity"})
    public void userIsNotAbleToDeleteCommentIfAuthenticationFails() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel);
        this.commentModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).addComment("New comment addded by admin");
        UserModel nonexistentModel = new UserModel("nonexistentUser", "nonexistentPassword");
        this.restClient.authenticateUser(nonexistentModel);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).deleteComment(this.commentModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Manager user deletes own comments and status code is 204")
    @Test(groups={"rest-api", "comments", "regression"})
    public void managerIsAbleToDeleteComments() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.commentModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).addComment("New comment added by Manager");
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).deleteComment(this.commentModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator user deletes own comments and status code is 204")
    @Test(groups={"rest-api", "comments", "regression"})
    public void collaboratorIsAbleToDeleteComments() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator));
        this.commentModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).addComment("New comment added by Collaborator");
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).deleteComment(this.commentModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Contributor user deletes own comments and status code is 204")
    @Test(groups={"rest-api", "comments", "regression"})
    public void contributorIsAbleToDeleteComments() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor));
        this.commentModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).addComment("New comment added by Contributor");
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).deleteComment(this.commentModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Consumer user can't delete comments created by admin user and status code is 403")
    @Test(groups={"rest-api", "comments", "regression"})
    public void consumerIsNotAbleToDeleteComments() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel);
        this.commentModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).addComment("This is a new comment");
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).deleteComment(this.commentModel);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user can't delete comments with inexistent ID and status code is 404")
    @Test(groups={"rest-api", "comments", "regression"})
    public void userIsNotAbleToDeleteInexistentComment() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel);
        this.commentModel = new RestCommentModel();
        this.commentModel.setId("inexistent");
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).deleteComment(this.commentModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user can't delete comments with inexistend NodeId and status code is 404")
    @Test(groups={"rest-api", "comments", "regression"})
    public void userIsNotAbleToDeleteCommentWithInexistentNodeId() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel);
        this.commentModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).addComment("This is a new comment");
        FileModel inexistentDocument = new FileModel();
        inexistentDocument.setNodeRef("inexistent");
        this.restClient.withCoreAPI().usingResource((RepoTestModel)inexistentDocument).deleteComment(this.commentModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user can't delete deleted comments and status code is 404")
    @Test(groups={"rest-api", "comments", "regression"})
    public void userIsNotAbleToDeleteDeletedComment() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel);
        this.commentModel = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).addComment("This is a new comment");
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).deleteComment(this.commentModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)this.document).deleteComment(this.commentModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Manager user deletes comment created by admin and status code is 204. Check with getComments for validation")
    @Test(groups={"rest-api", "comments", "regression"})
    public void managerIsAbleToDeleteCommentCreatedByOthers() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.commentModel = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).addComment(this.commentText);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)file).deleteComment(this.commentModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.comments = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.comments.assertThat().entriesListDoesNotContain("content", this.commentText);
        ((RestPaginationModel)this.comments.getPagination().assertThat().field("totalItems").is((Object)"0")).and().field("count").is((Object)"0");
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator user can delete comment created by self and status code is 204. Check with getComments for validation")
    @Test(groups={"rest-api", "comments", "regression"})
    public void collaboratorIsAbleToDeleteCommentCreatedBySelf() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.commentModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingResource((RepoTestModel)file).addComment(this.commentText);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)file).deleteComment(this.commentModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.comments = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.comments.assertThat().entriesListDoesNotContain("content", this.commentText);
        ((RestPaginationModel)this.comments.getPagination().assertThat().field("totalItems").is((Object)"0")).and().field("count").is((Object)"0");
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Contributor user deletes comment created by self and status code is 204. Check with getComments for validation")
    @Test(groups={"rest-api", "comments", "regression"})
    @Bug(id="ACE-4614")
    public void contributorIsAbleToDeleteCommentCreatedBySelf() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.commentModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingResource((RepoTestModel)file).addComment(this.commentText);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)file).deleteComment(this.commentModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.comments = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.comments.assertThat().entriesListDoesNotContain("content", this.commentText);
        ((RestPaginationModel)this.comments.getPagination().assertThat().field("totalItems").is((Object)"0")).and().field("count").is((Object)"0");
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Consumer user cannot delete comment created by admin and status code is 403. Check with getComments for validation and check default error model schema.")
    @Test(groups={"rest-api", "comments", "regression"})
    public void consumerIsNotAbleToDeleteCommentCreatedByOthersDefaultErrorModelSchema() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.commentModel = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).addComment(this.commentText);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingResource((RepoTestModel)file).deleteComment(this.commentModel);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED).statusCodeIs(HttpStatus.FORBIDDEN).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE).containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY);
        this.comments = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.comments.assertThat().entriesListContains("content", this.commentText);
        ((RestPaginationModel)this.comments.getPagination().assertThat().field("totalItems").is((Object)"1")).and().field("count").is((Object)"1");
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Manager can delete comment with version number")
    @Test(groups={"rest-api", "comments", "regression"})
    public void usingManagerDeleteCommentWithVersionNumber() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        File updatedContent = Utility.getResourceTestDataFile((String)"sampleContent.txt");
        ((Node)this.restClient.withCoreAPI().usingNode((RepoTestModel)file).usingParams(new String[]{"majorVersion=true&name=newfile.txt"})).updateNodeContent(updatedContent);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.commentModel = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).addComment(this.commentText);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)file).deleteComment(this.commentModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify Manager user cannot delete comment with invalid node and status code is 404. Check with getComments for validation")
    @Test(groups={"rest-api", "comments", "regression"})
    public void usingManagerDeleteCommentWithInvalidNode() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.commentModel = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).addComment(this.commentText);
        file.setNodeRef("invalid");
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)file).deleteComment(this.commentModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(file.getNodeRef() + " was not found");
        this.comments = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).getNodeComments();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(file.getNodeRef() + " was not found");
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify deleteComment from node with invalid network id returns status code 401")
    @Test(groups={"rest-api", "comments", "regression"})
    public void deleteCommentWithInvalidNetworkId() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.commentModel = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).addComment(this.commentText);
        this.networkUserModel.setDomain("invalidNetwork");
        this.restClient.authenticateUser(this.networkUserModel).withCoreAPI().usingResource((RepoTestModel)file).deleteComment(this.commentModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "comments"}, executionType={ExecutionType.REGRESSION}, description="Verify deleteComment from node with empty network id returns status code 401")
    @Test(groups={"rest-api", "comments", "regression"})
    public void deleteCommentWithEmptyNetworkId() throws Exception {
        FileModel file = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.commentModel = this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingResource((RepoTestModel)file).addComment(this.commentText);
        this.networkUserModel.setDomain("");
        this.restClient.authenticateUser(this.networkUserModel).withCoreAPI().usingResource((RepoTestModel)file).deleteComment(this.commentModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }
}

