/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes.items;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestItemModelsCollection;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetProcessItemsSanityTests
extends RestTest {
    private FileModel document;
    private SiteModel siteModel;
    private UserModel userWhoStartsTask;
    private UserModel assignee;
    private RestProcessModel processModel;
    private RestItemModelsCollection items;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userWhoStartsTask = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userWhoStartsTask)).createPublicRandomSite();
        this.document = ((DataContent)this.dataContent.usingUser(this.userWhoStartsTask).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userWhoStartsTask)).usingSite(this.siteModel)).usingResource((ContentModel)this.document)).createNewTaskAndAssignTo(this.assignee);
    }

    @TestRail(section={"rest-api", "processes"}, executionType={ExecutionType.SANITY}, description="Verify that user that started the process gets all process items")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void getProcessItemsUsingTheUserWhoStartedProcess() throws Exception {
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.userWhoStartsTask).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.items = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessItems();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.items.assertThat().entriesListIsNotEmpty();
    }

    @TestRail(section={"rest-api", "processes"}, executionType={ExecutionType.SANITY}, description="Verify that user that is involved in the process gets all process items")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void getProcessItemsUsingUserInvolvedInProcess() throws Exception {
        this.processModel = ((RestProcessModel)this.restClient.authenticateUser(this.assignee).withWorkflowAPI().getProcesses().getOneRandomEntry()).onModel();
        this.items = this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessItems();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.items.assertThat().entriesListIsNotEmpty();
    }
}

