/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rules;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.model.RestActionBodyExecTemplateModel;
import org.alfresco.rest.model.RestNodeModel;
import org.alfresco.rest.model.RestRuleExecutionModel;
import org.alfresco.rest.model.RestRuleModel;
import org.alfresco.rest.rules.RulesRestTest;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"rules"})
public class ExecuteRulesTests
extends RulesRestTest {
    private UserModel user;
    private SiteModel site;
    private FolderModel parentFolder;
    private FolderModel childFolder;
    private FileModel parentFolderFile;
    private FileModel childFolderFile;
    private RestRuleModel parentFolderRule;
    private RestRuleModel childFolderRule;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() {
        Step.STEP((String)"Create user and a site");
        this.user = this.dataUser.createRandomTestUser();
        this.site = ((DataSite)this.dataSite.usingUser(this.user)).createPublicRandomSite();
    }

    @BeforeMethod(alwaysRun=true)
    public void setUp() {
        Step.STEP((String)"Create parent folder, rule folder and file in it");
        this.parentFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        this.childFolder = ((DataContent)this.dataContent.usingUser(this.user).usingResource((ContentModel)this.parentFolder)).createFolder();
        this.parentFolderFile = ((DataContent)this.dataContent.usingUser(this.user).usingResource((ContentModel)this.parentFolder)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.childFolderFile = ((DataContent)this.dataContent.usingUser(this.user).usingResource((ContentModel)this.childFolder)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        Step.STEP((String)"Create rules for parent and rule folders");
        RestActionBodyExecTemplateModel addLockableAspectAction = this.rulesUtils.createAddAspectAction("cm:lockable");
        RestRuleModel ruleModel = this.rulesUtils.createRuleModel("ruleName", List.of(addLockableAspectAction));
        ruleModel.setIsInheritable(true);
        this.parentFolderRule = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.parentFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        this.childFolderRule = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.childFolder).usingDefaultRuleSet().createSingleRule(this.rulesUtils.createRuleModelWithDefaultValues());
    }

    @Test(groups={"rest-api", "rules", "actions", "sanity"})
    public void executeRules_onlyOwnedRules() {
        Step.STEP((String)"Check if file aspects don't contain Audio one");
        RestNodeModel fileNode = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.childFolderFile).getNode();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.rulesUtils.assertThat(fileNode).notContainsAspects("audio:audio");
        Step.STEP((String)"Execute rule");
        RestRuleExecutionModel executionResult = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.childFolder).executeRules(this.rulesUtils.createRuleExecutionRequest());
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        executionResult.assertThat().field("isEachSubFolderIncluded").is((Object)false);
        Step.STEP((String)"Check if only Audio aspect was added");
        fileNode = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.childFolderFile).getNode();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.rulesUtils.assertThat(fileNode).containsAspects("audio:audio");
    }

    @Test(groups={"rest-api", "rules", "actions", "sanity"})
    public void executeRules_includeInheritedRules() {
        Step.STEP((String)"Check if file aspects don't contain Audio and Lockable ones");
        RestNodeModel fileNode = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.childFolderFile).getNode();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.rulesUtils.assertThat(fileNode).notContainsAspects("audio:audio", "cm:lockable");
        Step.STEP((String)"Execute rules including inherited rules");
        RestRuleExecutionModel ruleExecutionRequest = this.rulesUtils.createRuleExecutionRequest();
        RestRuleExecutionModel executionResult = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.childFolder).executeRules(ruleExecutionRequest);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        executionResult.assertThat().field("isEachSubFolderIncluded").is((Object)false);
        Step.STEP((String)"Check if Audio and Lockable aspects were added");
        fileNode = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.childFolderFile).getNode();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.rulesUtils.assertThat(fileNode).containsAspects("audio:audio", "cm:lockable");
    }

    @Test(groups={"rest-api", "rules", "actions", "sanity"})
    public void executeRules_includeSubFolderRules() {
        Step.STEP((String)"Check if parent folder's file aspects don't contain Audio and Lockable ones");
        RestNodeModel fileNode = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.parentFolderFile).getNode();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.rulesUtils.assertThat(fileNode).notContainsAspects("audio:audio", "cm:lockable");
        Step.STEP((String)"Check if child folder's file aspects don't contain Audio and Lockable ones");
        fileNode = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.childFolderFile).getNode();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.rulesUtils.assertThat(fileNode).notContainsAspects("audio:audio", "cm:lockable");
        Step.STEP((String)"Execute rules on parent folder including sub-folders");
        RestRuleExecutionModel ruleExecutionRequest = this.rulesUtils.createRuleExecutionRequest();
        ruleExecutionRequest.setIsEachSubFolderIncluded(true);
        RestRuleExecutionModel executionResult = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.parentFolder).executeRules(ruleExecutionRequest);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        executionResult.assertThat().field("isEachSubFolderIncluded").is((Object)true);
        Step.STEP((String)"Check if Lockable aspects was added to parent folder's file");
        fileNode = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.parentFolderFile).getNode();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.rulesUtils.assertThat(fileNode).containsAspects("cm:lockable").notContainsAspects("audio:audio");
        Step.STEP((String)"Check if Audio and Lockable aspects were added to child folder's file");
        fileNode = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.childFolderFile).getNode();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.rulesUtils.assertThat(fileNode).containsAspects("audio:audio", "cm:lockable");
    }

    @Test(groups={"rest-api", "rules", "actions"})
    public void executeRules_disabledRule() {
        Step.STEP((String)"Disable child rules");
        RestRuleModel updatedChildRule = this.rulesUtils.createRuleModelWithDefaultValues();
        updatedChildRule.setIsEnabled(false);
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.childFolder).usingDefaultRuleSet().updateRule(this.childFolderRule.getId(), updatedChildRule);
        Step.STEP((String)"Check if file aspects don't contain Audio one");
        RestNodeModel fileNode = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.childFolderFile).getNode();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.rulesUtils.assertThat(fileNode).notContainsAspects("audio:audio");
        Step.STEP((String)"Execute rule");
        RestRuleExecutionModel executionResult = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.childFolder).executeRules(this.rulesUtils.createRuleExecutionRequest());
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        executionResult.assertThat().field("isEachSubFolderIncluded").is((Object)false);
        Step.STEP((String)"Check if Audio aspect is still missing");
        fileNode = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.childFolderFile).getNode();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.rulesUtils.assertThat(fileNode).notContainsAspects("audio:audio");
    }

    @Test(groups={"rest-api", "rules", "actions"})
    public void executeRules_notInheritableRule() {
        Step.STEP((String)"Set parent rule as not inheritable");
        RestRuleModel updatedParentRule = this.rulesUtils.createRuleModelWithDefaultValues();
        updatedParentRule.setIsInheritable(false);
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.parentFolder).usingDefaultRuleSet().updateRule(this.parentFolderRule.getId(), updatedParentRule);
        Step.STEP((String)"Check if file aspects don't contain Audio and Lockable ones");
        RestNodeModel fileNode = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.childFolderFile).getNode();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.rulesUtils.assertThat(fileNode).notContainsAspects("audio:audio", "cm:lockable");
        Step.STEP((String)"Execute child folder rules including inherited rules");
        RestRuleExecutionModel executionResult = this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)this.childFolder).executeRules(this.rulesUtils.createRuleExecutionRequest());
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        executionResult.assertThat().field("isEachSubFolderIncluded").is((Object)false);
        Step.STEP((String)"Check if Audio aspect is present and Lockable is still missing");
        fileNode = this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)this.childFolderFile).getNode();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.rulesUtils.assertThat(fileNode).containsAspects("audio:audio").notContainsAspects("cm:lockable");
    }

    @Test(groups={"rest-api", "rules", "actions"})
    public void executeRules_privateFolderResultsWith403() {
        Step.STEP((String)"Using admin create private site, folder and rule");
        SiteModel privateSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        FolderModel privateFolder = ((DataContent)this.dataContent.usingAdmin().usingSite(privateSite)).createFolder();
        ((DataContent)this.dataContent.usingAdmin().usingResource((ContentModel)privateFolder)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withPrivateAPI().usingNode((RepoTestModel)privateFolder).usingDefaultRuleSet().createSingleRule(this.rulesUtils.createRuleModelWithDefaultValues());
        Step.STEP((String)"Try to execute private folder's rules by user");
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)privateFolder).executeRules(this.rulesUtils.createRuleExecutionRequest());
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
    }

    @Test(groups={"rest-api", "rules", "actions"})
    public void executeRules_privateFolderAsContributorResultsWith403() {
        Step.STEP((String)"Using admin create private site, folder, file in it, rule and add user to site as contributor");
        UserModel contributor = this.dataUser.createRandomTestUser();
        SiteModel privateSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        FolderModel privateFolder = ((DataContent)this.dataContent.usingAdmin().usingSite(privateSite)).createFolder();
        ((DataContent)this.dataContent.usingAdmin().usingResource((ContentModel)privateFolder)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.dataUser.getAdminUser()).withPrivateAPI().usingNode((RepoTestModel)privateFolder).usingDefaultRuleSet().createSingleRule(this.rulesUtils.createRuleModelWithDefaultValues());
        ((DataUser)this.dataUser.usingAdmin()).addUserToSite(contributor, privateSite, UserRole.SiteContributor);
        Step.STEP((String)"Try to execute private folder's rules by contributor");
        this.restClient.authenticateUser(contributor).withPrivateAPI().usingNode((RepoTestModel)privateFolder).executeRules(this.rulesUtils.createRuleExecutionRequest());
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN);
    }

    @Test(groups={"rest-api", "rules", "actions"})
    public void executeRules_privateFolderAsCollaborator() {
        Step.STEP((String)"Using admin create private site, folder, file in it, rule and add user to site as collaborator");
        UserModel collaborator = this.dataUser.createRandomTestUser();
        UserModel admin = this.dataUser.getAdminUser();
        SiteModel privateSite = ((DataSite)this.dataSite.usingAdmin()).createPrivateRandomSite();
        FolderModel privateFolder = ((DataContent)this.dataContent.usingAdmin().usingSite(privateSite)).createFolder();
        FileModel privateFile = ((DataContent)this.dataContent.usingAdmin().usingResource((ContentModel)privateFolder)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(admin).withPrivateAPI().usingNode((RepoTestModel)privateFolder).usingDefaultRuleSet().createSingleRule(this.rulesUtils.createRuleModelWithDefaultValues());
        ((DataUser)this.dataUser.usingAdmin()).addUserToSite(collaborator, privateSite, UserRole.SiteCollaborator);
        Step.STEP((String)"Check if file aspects don't contain Audio one");
        RestNodeModel fileNode = this.restClient.authenticateUser(admin).withCoreAPI().usingNode((RepoTestModel)privateFile).getNode();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.rulesUtils.assertThat(fileNode).notContainsAspects("audio:audio");
        Step.STEP((String)"Execute private folder's rules by collaborator");
        this.restClient.authenticateUser(collaborator).withPrivateAPI().usingNode((RepoTestModel)privateFolder).executeRules(this.rulesUtils.createRuleExecutionRequest());
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        Step.STEP((String)"Check if Audio aspect is present");
        fileNode = this.restClient.authenticateUser(admin).withCoreAPI().usingNode((RepoTestModel)privateFile).getNode();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.rulesUtils.assertThat(fileNode).containsAspects("audio:audio");
    }

    @Test(groups={"rest-api", "rules", "actions"})
    public void executeRules_copyActionWithDeletedDestinationFolder() {
        FolderModel owningFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        FileModel owningFolderFile = ((DataContent)this.dataContent.usingUser(this.user).usingResource((ContentModel)owningFolder)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        FolderModel destinationFolder = ((DataContent)this.dataContent.usingUser(this.user).usingSite(this.site)).createFolder();
        Step.STEP((String)"Create copy action and rule");
        Map<String, Serializable> copyParams = Map.of("destination-folder", destinationFolder.getNodeRef(), "deep-copy", true);
        RestActionBodyExecTemplateModel copyAction = this.rulesUtils.createCustomActionModel("copy", copyParams);
        RestRuleModel ruleModel = this.rulesUtils.createRuleModelWithDefaultValues();
        ruleModel.setActions(Arrays.asList(copyAction));
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)owningFolder).usingDefaultRuleSet().createSingleRule(ruleModel);
        Step.STEP((String)"Delete destination folder and execute rule");
        this.restClient.authenticateUser(this.user).withCoreAPI().usingNode((RepoTestModel)destinationFolder).deleteNode(destinationFolder.getNodeRef());
        this.restClient.authenticateUser(this.user).withPrivateAPI().usingNode((RepoTestModel)owningFolder).executeRules(this.rulesUtils.createRuleExecutionRequest());
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }
}

