/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes.tasks;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.exception.JsonToModelConversionException;
import org.alfresco.rest.model.RestTaskModelsCollection;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetProcessTasksSanityTests
extends RestTest {
    private FileModel document;
    private SiteModel siteModel;
    private UserModel userModel;
    private UserModel assignee1;
    private UserModel assignee2;
    private UserModel assignee3;
    private ProcessModel process;
    private RestTaskModelsCollection processTasks;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userModel = this.dataUser.createRandomTestUser();
        this.assignee1 = this.dataUser.createRandomTestUser();
        this.assignee2 = this.dataUser.createRandomTestUser();
        this.assignee3 = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.document = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.process = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.document)).createMoreReviewersWorkflowAndAssignTo(new UserModel[]{this.assignee1, this.assignee2, this.assignee3});
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.SANITY}, description="Verify user who started the process gets all tasks of started process with Rest API and response is successfull (200)")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void userWhoStartedProcessCanGetProcessTasks() throws JsonToModelConversionException, Exception {
        this.processTasks = this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingProcess(this.process).getProcessTasks();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)this.processTasks.assertThat().entriesListCountIs(3)).and().entriesListContains("assignee", this.assignee1.getUsername())).and().entriesListContains("assignee", this.assignee2.getUsername())).and().entriesListContains("assignee", this.assignee3.getUsername());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.SANITY}, description="Verify any assignee user of the process gets all tasks of the process with Rest API and response is successfull (200)")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void assigneeUserCanGetAllProcessTasks() throws JsonToModelConversionException, Exception {
        this.processTasks = this.restClient.authenticateUser(this.assignee1).withWorkflowAPI().usingProcess(this.process).getProcessTasks();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.processTasks.assertThat().entriesListContains("assignee", this.assignee1.getUsername())).and().entriesListContains("assignee", this.assignee2.getUsername())).and().entriesListContains("assignee", this.assignee3.getUsername());
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.SANITY}, description="Verify any assignee user of the process gets all tasks of the process with Rest API and response is successfull (200)")
    @Test(groups={"rest-api", "workflow", "processes", "sanity"})
    public void involvedUserCanGetAllProcessTasks() throws JsonToModelConversionException, Exception {
        ProcessModel process = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.document)).createMoreReviewersWorkflowAndAssignTo(new UserModel[]{this.assignee1, this.assignee2, this.assignee3});
        ((DataWorkflow)this.dataWorkflow.usingUser(this.assignee1)).approveTask(process);
        this.processTasks = this.restClient.authenticateUser(this.assignee2).withWorkflowAPI().usingProcess(process).getProcessTasks();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.processTasks.assertThat().entriesListIsNotEmpty()).assertThat().entriesListContains("assignee", this.userModel.getUsername());
    }
}

