/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.sites.membershipRequests;

import org.alfresco.dataprep.SiteService;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestSiteMembershipRequestModel;
import org.alfresco.rest.model.RestTaskModel;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetSiteMembershipRequestTests
extends RestTest {
    private SiteModel publicSite;
    private SiteModel moderatedSite;
    private DataUser.ListUserWithRoles usersWithRoles;
    private UserModel adminUser;
    private UserModel siteCreator;
    private UserModel newMember;
    private RestSiteMembershipRequestModel returnedModel;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.adminUser)).createPublicRandomSite();
        this.siteCreator = this.dataUser.createRandomTestUser();
        this.moderatedSite = ((DataSite)this.dataSite.usingUser(this.siteCreator)).createModeratedRandomSite();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.moderatedSite, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        this.newMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(this.newMember).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify site manager is able to retrieve site membership request")
    public void siteManagerIsAbleToRetrieveSiteMembershipRequest() throws Exception {
        this.returnedModel = this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingUser(this.newMember).getSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)this.returnedModel.assertThat().field("id").is((Object)this.moderatedSite.getId())).and().field("message").is((Object)"Please accept me")).and().field("site.title").is((Object)this.moderatedSite.getTitle())).and().field("site.visibility").is((Object)SiteService.Visibility.MODERATED.toString())).and().field("site.guid").isNotEmpty()).and().field("site.description").is((Object)this.moderatedSite.getDescription())).and().field("site.preset").is((Object)"site-dashboard");
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify site collaborator is able to retrieve site membership request")
    public void siteCollaboratorIsNotAbleToRetrieveSiteMembershipRequest() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingUser(this.newMember).getSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify site contributor is able to retrieve site membership request")
    public void siteContributorIsNotAbleToRetrieveSiteMembershipRequest() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingUser(this.newMember).getSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify site consumer is able to retrieve site membership request")
    public void siteConsumerIsNotAbleToRetrieveSiteMembershipRequest() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingUser(this.newMember).getSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user is able to retrieve site membership request")
    public void adminIsAbleToRetrieveSiteMembershipRequest() throws Exception {
        this.returnedModel = this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingUser(this.newMember).getSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)this.returnedModel.assertThat().field("id").is((Object)this.moderatedSite.getId())).and().field("message").is((Object)"Please accept me")).and().field("site.title").is((Object)this.moderatedSite.getTitle())).and().field("site.visibility").is((Object)SiteService.Visibility.MODERATED.toString())).and().field("site.guid").isNotEmpty()).and().field("site.description").is((Object)this.moderatedSite.getDescription())).and().field("site.preset").is((Object)"site-dashboard");
    }

    @Test(groups={"rest-api", "people", "sanity"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.SANITY}, description="Verify user fails to get all site membership requests of a specific person with Rest API when the authentication fails (401)")
    public void unauthorizedUserFailsToGetSiteMembershipRequests() throws Exception {
        UserModel manager = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.siteCreator)).addUserToSite(manager, this.moderatedSite, UserRole.SiteManager);
        manager.setPassword("newpassword");
        this.restClient.authenticateUser(manager).withCoreAPI().usingUser(this.newMember).getSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify a user gets all its own site membership requests using '-me-' with Rest API and response is successful (200)")
    public void usingMeGetSiteMembershipRequestsWithSuccess() throws Exception {
        this.restClient.authenticateUser(this.newMember).withCoreAPI().usingMe().getSiteMembershipRequest(this.moderatedSite).assertThat().field("id").is((Object)this.moderatedSite.getId());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager can't get site membership requests for inexistent user and response is not found (404)")
    public void siteManagerCantGetSiteMembershipRequestsInexistentUser() throws Exception {
        this.restClient.authenticateUser(this.newMember).withCoreAPI().usingUser(UserModel.getRandomUserModel()).getSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, ""));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user can get site membership requests on site with no requests and response is successful (200)")
    public void userWithNoRequestsCantGetSiteMembershipRequests() throws Exception {
        UserModel noRequestUser = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(noRequestUser).withCoreAPI().usingMe().getSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, noRequestUser.getUsername(), this.moderatedSite.getId()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager can't get site membership requests on public site and response is not found (404)")
    public void siteManagerCantGetPublicSiteMembershipRequests() throws Exception {
        UserModel publicUser = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(publicUser).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.publicSite);
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingUser(publicUser).getSiteMembershipRequest(this.publicSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, publicUser.getUsername(), this.publicSite.getId()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager can't get site membership requests on private site and response is not found (404)")
    public void siteManagerCantGetPrivateSiteMembershipRequests() throws Exception {
        UserModel privateUser = this.dataUser.createRandomTestUser();
        SiteModel privateSite = ((DataSite)this.dataSite.usingUser(this.siteCreator)).createPrivateRandomSite();
        this.restClient.authenticateUser(privateUser).withCoreAPI().usingAuthUser().addSiteMembershipRequest(privateSite);
        this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingUser(privateUser).getSiteMembershipRequest(privateSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, privateUser.getUsername(), privateSite.getId()));
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify site manager can't get site membership requests  for inexistent site and response is not found (404)")
    public void siteManagerCantGetSiteMembershipRequestsForInexistentSite() throws Exception {
        SiteModel inexistentSite = SiteModel.getRandomSiteModel();
        this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingMe().getSiteMembershipRequest(inexistentSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.siteCreator.getUsername(), inexistentSite.getId()));
    }

    @Bug(id="ACE-2413")
    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify if person ID field is empty user can't get site membership requests on moderated site and response is not found (400)")
    public void emptyPersonIdCantGetModeratedSiteMembershipRequests() throws Exception {
        UserModel emptyUser = new UserModel("", "password");
        this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingUser(emptyUser).getSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(RestErrorModel.API_DEFAULT_ERRORKEY).containsSummary(String.format("The entity with id: personId is null. was not found", new Object[0])).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Approve site membership request then verify get site membership requests - response is 404")
    @Test(groups={"rest-api", "people", "regression"})
    public void approveRequestThenGetSiteMembershipRequest() throws Exception {
        UserModel userWithApprovedRequests = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(userWithApprovedRequests).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestTaskModel taskModel = this.restClient.authenticateUser(userWithApprovedRequests).withWorkflowAPI().getTasks().getTaskModelByDescription(this.moderatedSite);
        this.workflow.approveSiteMembershipRequest(this.siteCreator.getUsername(), this.siteCreator.getPassword(), taskModel.getId(), true, "Approve");
        this.returnedModel = this.restClient.authenticateUser(userWithApprovedRequests).withCoreAPI().usingMe().getSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, userWithApprovedRequests.getUsername(), this.moderatedSite.getId())).containsErrorKey(RestErrorModel.RELATIONSHIP_NOT_FOUND_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Reject site membership request then verify get site membership requests - response is 404")
    public void rejectRequestThenGetSiteMembershipRequest() throws Exception {
        UserModel userWithRejectedRequests = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(userWithRejectedRequests).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        RestTaskModel taskModel = this.restClient.authenticateUser(userWithRejectedRequests).withWorkflowAPI().getTasks().getTaskModelByDescription(this.moderatedSite);
        this.workflow.approveSiteMembershipRequest(this.siteCreator.getUsername(), this.siteCreator.getPassword(), taskModel.getId(), false, "Rejected");
        this.returnedModel = this.restClient.authenticateUser(userWithRejectedRequests).withCoreAPI().usingMe().getSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, userWithRejectedRequests.getUsername(), this.moderatedSite.getId())).containsErrorKey(RestErrorModel.RELATIONSHIP_NOT_FOUND_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify entry details for get site favorite response with Rest API")
    public void checkResponseSchemaForGetSiteMembershipRequest() throws Exception {
        ((DataUser)this.dataUser.usingUser(this.siteCreator)).addUserToSite(this.newMember, this.moderatedSite, UserRole.SiteContributor);
        this.returnedModel = this.restClient.authenticateUser(this.newMember).withCoreAPI().usingAuthUser().getSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)((RestSiteMembershipRequestModel)this.returnedModel.assertThat().field("id").is((Object)this.moderatedSite.getId())).and().field("message").is((Object)"Please accept me")).and().field("site.title").is((Object)this.moderatedSite.getTitle())).and().field("site.visibility").is((Object)SiteService.Visibility.MODERATED.toString())).and().field("site.guid").isNotEmpty()).and().field("site.description").is((Object)this.moderatedSite.getDescription())).and().field("site.preset").is((Object)"site-dashboard")).and().field("site.role").is((Object)"SiteContributor");
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify that getFavoriteSites request applies valid properties param")
    @Test(groups={"rest-api", "people", "regression"})
    public void getSiteMembershipRequestWithValidPropertiesParam() throws Exception {
        RestSiteMembershipRequestModel returnedModel = this.restClient.authenticateUser(this.newMember).withParams(new String[]{"properties=message"}).withCoreAPI().usingAuthUser().getSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMembershipRequestModel)returnedModel.assertThat().fieldsCount().is((Object)1)).assertThat().field("message").isNotEmpty();
    }

    @Test(groups={"rest-api", "people", "regression"})
    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify that getFavoriteSites request returns status 200 when using valid parameters")
    public void getSiteMembershipRequestUsingParameters() throws Exception {
        RestSiteMembershipRequestModel returnedModel = this.restClient.withParams(new String[]{"message=Please accept me"}).authenticateUser(this.newMember).withCoreAPI().usingMe().getSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestSiteMembershipRequestModel)returnedModel.assertThat().field("id").is((Object)this.moderatedSite.getId())).and().field("site.title").is((Object)this.moderatedSite.getTitle());
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user doesn't have permission to get site membership request of admin without membership request with Rest API and status code is 404")
    @Test(groups={"rest-api", "people", "regression"})
    public void userIsNotAbleToGetSiteMembershipRequestOfAdminWithoutRequest() throws Exception {
        this.returnedModel = this.restClient.authenticateUser(this.newMember).withCoreAPI().usingUser(this.adminUser).getSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsErrorKey(RestErrorModel.RELATIONSHIP_NOT_FOUND_ERRORKEY).containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.adminUser.getUsername(), this.moderatedSite.getId())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify user doesn't have permission to get site membership request of admin with requests with Rest API and status code is 404")
    @Test(groups={"rest-api", "people", "regression"})
    public void userIsNotAbleToGetSiteMembershipRequestOfAdminWithRequest() throws Exception {
        UserModel newMember = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(this.adminUser).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        this.returnedModel = this.restClient.authenticateUser(newMember).withCoreAPI().usingUser(this.adminUser).getSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsErrorKey(RestErrorModel.RELATIONSHIP_NOT_FOUND_ERRORKEY).containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.adminUser.getUsername(), this.moderatedSite.getId())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "people"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user doesn't have permission to get site membership request of another user with Rest API and status code is 404")
    @Test(groups={"rest-api", "people", "regression"})
    public void userIsNotAbleToGetSiteMembershipRequestOfAnotherUser() throws Exception {
        UserModel userCollaborator = this.dataUser.createRandomTestUser();
        UserModel userConsumer = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(userConsumer).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        ((DataUser)this.dataUser.usingUser(this.siteCreator)).addUserToSite(userConsumer, this.moderatedSite, UserRole.SiteConsumer);
        this.restClient.authenticateUser(userCollaborator).withCoreAPI().usingAuthUser().addSiteMembershipRequest(this.moderatedSite);
        ((DataUser)this.dataUser.usingUser(this.siteCreator)).addUserToSite(userCollaborator, this.moderatedSite, UserRole.SiteCollaborator);
        this.returnedModel = this.restClient.authenticateUser(userCollaborator).withCoreAPI().usingUser(userConsumer).getSiteMembershipRequest(this.moderatedSite);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsErrorKey(RestErrorModel.RELATIONSHIP_NOT_FOUND_ERRORKEY).containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, userConsumer.getUsername(), this.moderatedSite.getId())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }
}

