/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.repo.resource.general;

import java.util.function.Function;
import org.alfresco.rest.repo.resource.general.Creator;
import org.alfresco.rest.repo.resource.general.ResourceCreator;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;

public abstract class ContentCreator<CONTENT extends ContentModel, SELF extends Creator.ContentCreator<CONTENT, ?>>
extends ResourceCreator<CONTENT, SELF>
implements Creator.ContentCreator<CONTENT, SELF> {
    private static final FolderModel DOCUMENT_LIBRARY = null;
    protected SiteModel site;
    protected final CONTENT contentModel;
    protected FolderModel parent = DOCUMENT_LIBRARY;

    public ContentCreator(CONTENT contentModel) {
        this.contentModel = contentModel;
    }

    @Override
    protected abstract SELF self();

    @Override
    public SELF withName(String name) {
        this.contentModel.setName(name);
        return (SELF)this.self();
    }

    @Override
    public SELF withTitle(String title) {
        this.contentModel.setTitle(title);
        return (SELF)this.self();
    }

    @Override
    public SELF withDescription(String description) {
        this.contentModel.setDescription(description);
        return (SELF)this.self();
    }

    @Override
    public <FOLDER extends FolderModel> SELF underFolder(FOLDER parent) {
        this.parent = parent;
        return (SELF)this.self();
    }

    @Override
    public <SITE extends SiteModel> SELF withinSite(SITE site) {
        this.site = site;
        return (SELF)this.self();
    }

    protected CONTENT create(DataContent dataContent, Function<CONTENT, CONTENT> creator) {
        if (this.site != null) {
            dataContent.usingSite(this.site);
        }
        if (this.parent != null) {
            dataContent.usingResource((ContentModel)this.parent);
        }
        if (this.user != null) {
            dataContent.usingUser(this.user);
        }
        return (CONTENT)((ContentModel)creator.apply(this.contentModel));
    }
}

