/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.sites.groups;

import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestSiteGroupModel;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.GroupModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AddSiteGroupTests
extends RestTest {
    private UserModel adminUserModel;
    private SiteModel publicSiteModel;
    private SiteModel moderatedSiteModel;
    private DataUser.ListUserWithRoles publicSiteUsersWithRoles;
    private String addMemberJson;
    private String addMembersJson;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUserModel = this.dataUser.getAdminUser();
        this.publicSiteModel = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createPublicRandomSite();
        this.moderatedSiteModel = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createModeratedRandomSite();
        this.publicSiteUsersWithRoles = this.dataUser.addUsersWithRolesToSite(this.publicSiteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        this.addMemberJson = "{\"role\":\"%s\",\"id\":\"%s\"}";
        this.addMembersJson = "{\"role\":\"%s\",\"id\":\"%s\"}, {\"role\":\"%s\",\"id\":\"%s\"}";
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that user can not be added to an inexistent site and gets status code 404")
    public void notAbleToAddGroupToAnInExistentSite() throws Exception {
        GroupModel group = this.dataGroup.createRandomGroup();
        SiteModel inexistentSite = new SiteModel("inexistentSite");
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(inexistentSite).addSiteGroup(this.getId(group), UserRole.SiteManager);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, inexistentSite.getId()));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that inexistent group can not be added to site and gets status code 404")
    public void notAbleToAddInExistentGroupToSite() throws Exception {
        GroupModel group = new GroupModel("inExistentGroup");
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.publicSiteModel).addSiteGroup(group.getGroupIdentifier(), UserRole.SiteManager);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsErrorKey(RestErrorModel.API_DEFAULT_ERRORKEY).containsSummary(String.format("An authority was not found for %s", group.getGroupIdentifier())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that user can not add group that is already present and gets status code 409")
    public void notAbleToAddGroupThatIsAlreadyAPresent() throws Exception {
        GroupModel group = this.dataGroup.createRandomGroup();
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.moderatedSiteModel).addSiteGroup(this.getId(group), UserRole.SiteManager);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.moderatedSiteModel).addSiteGroup(this.getId(group), UserRole.SiteManager);
        this.restClient.assertStatusCodeIs(HttpStatus.CONFLICT).assertLastError().containsSummary(String.format(RestErrorModel.ALREADY_Site_MEMBER, this.getId(group), this.moderatedSiteModel.getId()));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that several groups with different roles can be added once in a row to a site and gets status code 201")
    public void addSeveralGroupsWithDifferentRolesToASite() throws Exception {
        GroupModel firstGroup = this.dataGroup.createRandomGroup();
        GroupModel secondGroup = this.dataGroup.createRandomGroup();
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI();
        String json = String.format(this.addMembersJson, UserRole.SiteContributor, this.getId(firstGroup), UserRole.SiteCollaborator, this.getId(secondGroup));
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)json, (String)"sites/{siteId}/group-members?{parameters}", (String[])new String[]{this.publicSiteModel.getId(), this.restClient.getParameters()});
        this.restClient.processModel(RestSiteGroupModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that several groups with same roles can be added once in a row to a site and gets status code 201")
    public void addSeveralGroupsWithSameRolesToASite() throws Exception {
        GroupModel firstGroup = this.dataGroup.createRandomGroup();
        GroupModel secondGroup = this.dataGroup.createRandomGroup();
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI();
        String json = String.format(this.addMembersJson, UserRole.SiteCollaborator, this.getId(firstGroup), UserRole.SiteCollaborator, this.getId(secondGroup));
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)json, (String)"sites/{siteId}/group-members?{parameters}", (String[])new String[]{this.publicSiteModel.getId(), this.restClient.getParameters()});
        this.restClient.processModel(RestSiteGroupModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that several users that are already added to the site can not be added once in a row and gets status code 400")
    public void addSeveralGroupsThatAreAlreadyAddedToASite() throws Exception {
        GroupModel firstGroup = this.dataGroup.createRandomGroup();
        GroupModel secondGroup = this.dataGroup.createRandomGroup();
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI();
        String json = String.format(this.addMembersJson, UserRole.SiteCollaborator, this.getId(firstGroup), UserRole.SiteCollaborator, this.getId(secondGroup));
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)json, (String)"sites/{siteId}/group-members?{parameters}", (String[])new String[]{this.publicSiteModel.getId(), this.restClient.getParameters()});
        this.restClient.processModel(RestSiteGroupModel.class, request);
        this.restClient.processModel(RestSiteGroupModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.CONFLICT).assertLastError().containsSummary(String.format(RestErrorModel.ALREADY_Site_MEMBER, this.getId(firstGroup), this.publicSiteModel.getId()));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Add new site group membership request by providing an empty body")
    public void addSiteGroupsUsingEmptyBody() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI();
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)"", (String)"sites/{siteId}/group-members?{parameters}", (String[])new String[]{this.publicSiteModel.getId(), this.restClient.getParameters()});
        this.restClient.processModel(RestSiteGroupModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.NO_CONTENT, "No content to map due to end-of-input")).containsErrorKey(String.format(RestErrorModel.NO_CONTENT, "No content to map due to end-of-input")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Check lower and upper case letters for role field")
    public void checkLowerUpperCaseLettersForRole() throws Exception {
        GroupModel group = this.dataGroup.createRandomGroup();
        String json = String.format(this.addMemberJson, "SITEMANAGER", this.getId(group));
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI();
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)json, (String)"sites/{siteId}/group-members?{parameters}", (String[])new String[]{this.publicSiteModel.getId(), this.restClient.getParameters()});
        this.restClient.processModel(RestSiteGroupModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format("An authority was not found for GROUP_site_%s_%s", this.publicSiteModel.getId(), "SITEMANAGER")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
        json = String.format(this.addMemberJson, "sitemanager", this.getId(group));
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI();
        request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)json, (String)"sites/{siteId}/group-members?{parameters}", (String[])new String[]{this.publicSiteModel.getId(), this.restClient.getParameters()});
        this.restClient.processModel(RestSiteGroupModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format("An authority was not found for GROUP_site_%s_%s", this.publicSiteModel.getId(), "sitemanager")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Check empty value for user role")
    public void checkEmptyValueForRole() throws Exception {
        GroupModel group = this.dataGroup.createRandomGroup();
        String json = String.format(this.addMemberJson, "", this.getId(group));
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI();
        RestRequest request = RestRequest.requestWithBody((HttpMethod)HttpMethod.POST, (String)json, (String)"sites/{siteId}/group-members?{parameters}", (String[])new String[]{this.publicSiteModel.getId(), this.restClient.getParameters()});
        this.restClient.processModel(RestSiteGroupModel.class, request);
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(String.format(RestErrorModel.NO_CONTENT, "N/A")).containsSummary(String.format(RestErrorModel.NO_CONTENT, "N/A")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "sites", "sanity"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.SANITY}, description="Verify that manager is able to add site group membership and gets status code CREATED (201)")
    public void managerIsAbleToAddSiteGroup() throws Exception {
        GroupModel group = this.dataGroup.createRandomGroup();
        this.restClient.authenticateUser(this.publicSiteUsersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        ((RestSiteGroupModel)this.restClient.withCoreAPI().usingSite(this.publicSiteModel).addSiteGroup(this.getId(group), UserRole.SiteCollaborator).assertThat().field("id").is((Object)this.getId(group))).and().field("role").is((Object)UserRole.SiteCollaborator);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that site collaborator is not able to add site group membership and gets status code FORBIDDEN (403)")
    public void collaboratorIsNotAbleToAddSiteGroup() throws Exception {
        GroupModel group = this.dataGroup.createRandomGroup();
        this.restClient.authenticateUser(this.publicSiteUsersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingSite(this.publicSiteModel).addSiteGroup(this.getId(group), UserRole.SiteCollaborator);
        this.restClient.assertLastError().containsSummary("The current user does not have permissions to modify the membership details of the site");
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that site contributor is not able to add site group membership and gets status code FORBIDDEN (403)")
    public void contributorIsNotAbleToAddSiteGroup() throws Exception {
        GroupModel group = this.dataGroup.createRandomGroup();
        this.restClient.authenticateUser(this.publicSiteUsersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingSite(this.publicSiteModel).addSiteGroup(this.getId(group), UserRole.SiteContributor);
        this.restClient.assertLastError().containsSummary("The current user does not have permissions to modify the membership details of the site");
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that site consumer is not able to add site group membership and gets status code FORBIDDEN (403)")
    public void consumerIsNotAbleToAddSiteGroup() throws Exception {
        GroupModel group = this.dataGroup.createRandomGroup();
        this.restClient.authenticateUser(this.publicSiteUsersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingSite(this.publicSiteModel).addSiteGroup(this.getId(group), UserRole.SiteConsumer);
        this.restClient.assertLastError().containsSummary("The current user does not have permissions to modify the membership details of the site");
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @Test(groups={"rest-api", "sites", "sanity"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.SANITY}, description="Verify that admin user is able to add site group membership and gets status code CREATED (201)")
    public void adminIsAbleToAddSiteGroup() throws Exception {
        GroupModel group = this.dataGroup.createRandomGroup();
        ((RestSiteGroupModel)this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.publicSiteModel).addSiteGroup(this.getId(group), UserRole.SiteConsumer).assertThat().field("id").is((Object)this.getId(group))).and().field("role").is((Object)UserRole.SiteConsumer);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    @Test(groups={"rest-api", "sites", "sanity"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.SANITY}, description="Verify that unauthenticated user is not able to add site group membership")
    public void unauthenticatedUserIsNotAuthorizedToAddSiteGroup() throws Exception {
        GroupModel group = this.dataGroup.createRandomGroup();
        UserModel userModel = this.dataUser.createRandomTestUser();
        userModel.setPassword("user wrong password");
        this.dataUser.addUserToSite(userModel, this.publicSiteModel, UserRole.SiteManager);
        this.restClient.authenticateUser(userModel).withCoreAPI().usingSite(this.publicSiteModel).addSiteGroup(this.getId(group), UserRole.SiteCollaborator);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify that manager can add another user as manager to a public site and gets status code CREATED (201)")
    public void addManagerToPublicSite() throws Exception {
        GroupModel group = this.dataGroup.createRandomGroup();
        ((RestSiteGroupModel)this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.publicSiteModel).addSiteGroup(this.getId(group), UserRole.SiteManager).assertThat().field("id").is((Object)this.getId(group))).and().field("role").is((Object)UserRole.SiteManager);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
    }

    String getId(GroupModel group) {
        return "GROUP_" + group.getGroupIdentifier();
    }
}

