/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DeleteProcessFullTests
extends RestTest {
    private UserModel userWhoAddsProcess;
    private UserModel assignee;
    private RestProcessModel process;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userWhoAddsProcess = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify user is NOT able to delete process started by him twice using REST API and status code is NOT FOUND (404)")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void deleteProcessByUserWhoStartedProcessTwice() throws Exception {
        this.process = this.restClient.authenticateUser(this.userWhoAddsProcess).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.process).deleteProcess();
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withWorkflowAPI().usingProcess((ProcessModel)this.process).deleteProcess();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).containsSummary(String.format(RestErrorModel.ENTITY_WAS_NOT_FOUND, this.process.getId())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
        this.restClient.withWorkflowAPI().getProcesses().assertThat().entriesListDoesNotContain("id", this.process.getId());
    }
}

