/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.tasks.candidates;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestCandidateModelsCollection;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.GroupModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TaskModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetTaskCandidatesSanityTests
extends RestTest {
    private UserModel userModel;
    private UserModel user;
    private UserModel userModel1;
    private UserModel userModel2;
    private SiteModel siteModel;
    private FileModel fileModel;
    private TaskModel taskModel;
    private GroupModel group;
    private RestCandidateModelsCollection candidateModels;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userModel = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.fileModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.user = this.dataUser.createRandomTestUser();
        this.userModel1 = this.dataUser.createRandomTestUser();
        this.userModel2 = this.dataUser.createRandomTestUser();
        this.group = this.dataGroup.createRandomGroup();
        this.dataGroup.addListOfUsersToGroup(this.group, new UserModel[]{this.userModel1, this.userModel2});
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.user)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createPooledReviewTaskAndAssignTo(this.group);
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Verify that admin gets task candidates")
    public void getTaskCandidatesByAdmin() throws Exception {
        this.candidateModels = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withWorkflowAPI().usingTask(this.taskModel).getTaskCandidates();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.candidateModels.assertThat().entriesListContains("candidateType", "group")).and().entriesListContains("candidateId", String.format("GROUP_%s", this.group.getGroupIdentifier()));
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Verify that user that started the process gets task candidates")
    public void getTaskCandidatesByUserWhoStartedProcess() throws Exception {
        this.candidateModels = this.restClient.authenticateUser(this.user).withWorkflowAPI().usingTask(this.taskModel).getTaskCandidates();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.candidateModels.assertThat().entriesListContains("candidateType", "group")).and().entriesListContains("candidateId", String.format("GROUP_%s", this.group.getGroupIdentifier()));
    }

    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Verify that user from the assighed group to the process gets task candidates")
    public void getTaskCandidatesByCandidateUser() throws Exception {
        this.candidateModels = this.restClient.authenticateUser(this.userModel1).withWorkflowAPI().usingTask(this.taskModel).getTaskCandidates();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)this.candidateModels.assertThat().entriesListContains("candidateType", "group")).and().entriesListContains("candidateId", String.format("GROUP_%s", this.group.getGroupIdentifier()));
    }
}

