/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.repo.resource.general;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.alfresco.rest.repo.resource.general.MultiCreator;
import org.alfresco.rest.repo.resource.general.MultipleResourcesCreator;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;

public abstract class MultipleContentsCreator<CONTENT extends ContentModel, SELF extends MultiCreator.ContentsCreator<CONTENT, ?>>
extends MultipleResourcesCreator<CONTENT, SELF>
implements MultiCreator.ContentsCreator<CONTENT, SELF> {
    protected FolderModel parent;
    protected SiteModel site;
    protected UserModel user;
    protected List<String> titles = new ArrayList<String>();
    protected List<String> descriptions = new ArrayList<String>();

    @Override
    public SELF withTitles(String ... titles) {
        this.titles = Stream.of(titles).collect(Collectors.toList());
        return (SELF)((MultiCreator.ContentsCreator)this.self());
    }

    @Override
    public SELF withRandomTitles() {
        this.titles = IntStream.range(0, this.names.size()).mapToObj(i -> RandomStringUtils.randomAlphanumeric((int)10)).collect(Collectors.toList());
        return (SELF)((MultiCreator.ContentsCreator)this.self());
    }

    @Override
    public SELF withDescriptions(String ... descriptions) {
        this.descriptions = Stream.of(descriptions).collect(Collectors.toList());
        return (SELF)((MultiCreator.ContentsCreator)this.self());
    }

    @Override
    public SELF withRandomDescriptions() {
        this.descriptions = IntStream.range(0, this.names.size()).mapToObj(i -> RandomStringUtils.randomAlphanumeric((int)20)).collect(Collectors.toList());
        return (SELF)((MultiCreator.ContentsCreator)this.self());
    }

    @Override
    public <FOLDER extends FolderModel> SELF underFolder(FOLDER parent) {
        this.parent = parent;
        return (SELF)((MultiCreator.ContentsCreator)this.self());
    }

    @Override
    public <SITE extends SiteModel> SELF withinSite(SITE site) {
        this.site = site;
        return (SELF)((MultiCreator.ContentsCreator)this.self());
    }

    protected void verifyDataConsistency() {
        if (CollectionUtils.isEmpty((Collection)this.names)) {
            throw new IllegalArgumentException("Names of files/folders to create needs to be provided");
        }
        if (CollectionUtils.isNotEmpty(this.titles) && this.titles.size() < this.names.size()) {
            throw new IllegalArgumentException("Provided titles size is different from created files/folders amount");
        }
        if (CollectionUtils.isNotEmpty(this.descriptions) && this.descriptions.size() < this.names.size()) {
            throw new IllegalArgumentException("Provided descriptions size is different from created files/folders amount");
        }
    }
}

