/*-
 * #%L
 * alfresco-tas-restapi
 * %%
 * Copyright (C) 2005 - 2022 Alfresco Software Limited
 * %%
 * This file is part of the Alfresco software. 
 * If the software was purchased under a paid Alfresco license, the terms of 
 * the paid license agreement will prevail.  Otherwise, the software is 
 * provided under the following open source license terms:
 * 
 * Alfresco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Alfresco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with Alfresco. If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.alfresco.rest.search;

import com.fasterxml.jackson.annotation.JsonProperty;

import org.alfresco.rest.core.IRestModel;
import org.alfresco.utility.model.TestModel;

/**
 * Generated by 'gethin' on '2017-03-01 12:12' from 'Alfresco Search REST API' swagger file Generated from 'Alfresco Search REST API' swagger file Base Path {@linkplain /alfresco/api/-default-/public/search/versions/1}
 */
public class RestRequestFacetSetModel extends TestModel implements IRestModel<RestRequestFacetSetModel>
{
    @JsonProperty(value = "entry")
    RestRequestFacetSetModel model;

    @Override
    public RestRequestFacetSetModel onModel()
    {
        return model;
    }

    /**
     * A label to use to identify the set
     */

    private String label;
    /**
     * The start of the range
     */

    private String start;
    /**
     * The end of the range
     */

    private String end;
    /**
     * When true, the set will include values greater or equal to "start"
     */

    private boolean startInclusive = true;
    /**
     * When true, the set will include values less than or equal to "end"
     */

    private boolean endInclusive = true;

    public String getLabel()
    {
        return this.label;
    }

    public void setLabel(String label)
    {
        this.label = label;
    }

    public String getStart()
    {
        return this.start;
    }

    public void setStart(String start)
    {
        this.start = start;
    }

    public String getEnd()
    {
        return this.end;
    }

    public void setEnd(String end)
    {
        this.end = end;
    }

    public boolean isStartInclusive()
    {
        return this.startInclusive;
    }

    public void setStartInclusive(boolean startInclusive)
    {
        this.startInclusive = startInclusive;
    }

    public boolean isEndInclusive()
    {
        return this.endInclusive;
    }

    public void setEndInclusive(boolean endInclusive)
    {
        this.endInclusive = endInclusive;
    }
}
